<?php
/**
 * dormatic functions and definitions [dormatic]
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package dormatic  DORMATIC_THEME_URI DORMATIC
 */

defined( 'DORMATIC_THEME_URI' ) or define( 'DORMATIC_THEME_URI', get_template_directory_uri() );
define( 'DORMATIC_THEME_DRI', get_template_directory() );
define( 'DORMATIC_IMG_URL', DORMATIC_THEME_URI . '/assets/images/' );
define( 'DORMATIC_CSS_URL', DORMATIC_THEME_URI . '/assets/css/' );
define( 'DORMATIC_JS_URL', DORMATIC_THEME_URI . '/assets/js/' );
define( 'DORMATIC_FRAMEWORK_DRI', DORMATIC_THEME_DRI . '/framework/' );

require_once DORMATIC_FRAMEWORK_DRI . 'styles/index.php';
require_once DORMATIC_FRAMEWORK_DRI . 'styles/daynamic-style.php';
require_once DORMATIC_FRAMEWORK_DRI . 'scripts/index.php';
require_once DORMATIC_FRAMEWORK_DRI . 'redux/redux-config.php';
require_once DORMATIC_FRAMEWORK_DRI . 'plugin-list.php';
require_once DORMATIC_FRAMEWORK_DRI . 'tgm/class-tgm-plugin-activation.php';
require_once DORMATIC_FRAMEWORK_DRI . 'tgm/config-tgm.php';
require_once DORMATIC_FRAMEWORK_DRI . 'dashboard/class-dashboard.php';
require_once DORMATIC_FRAMEWORK_DRI . 'classes/dormatic-int.php';
require_once DORMATIC_FRAMEWORK_DRI . 'classes/dormatic-act.php';

/**
 * Theme option compatibility.
 */
if ( ! function_exists( 'dormatic_get_options' ) ) :
	function dormatic_get_options( $key ) {
		global $dormatic_options;
		$opt_pref = 'dormatic_';
		if ( empty( $dormatic_options ) ) {
			$dormatic_options = get_option( $opt_pref . 'options' );
		}
		$index = $opt_pref . $key;
		if ( ! isset( $dormatic_options[ $index ] ) ) {
			return false;
		}
		return $dormatic_options[ $index ];
	}
endif;

if ( ! function_exists( 'dormatic_setup' ) ) :
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which
	 * runs before the init hook. The init hook is too late for some features, such
	 * as indicating support for post thumbnails.
	 */
	function dormatic_setup() {
		/*
		* Make theme available for translation.
		* Translations can be filed in the /languages/ directory.
		* If you're building a theme based on love us, use a find and replace
		* to change 'dormatic' to the name of your theme in all the template files.
		*/
		load_theme_textdomain( 'dormatic', get_template_directory() . '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		/*
		* Let WordPress manage the document title.
		* By adding theme support, we declare that this theme does not use a
		* hard-coded <title> tag in the document head, and expect WordPress to
		* provide it for us.
		*/
		add_theme_support( 'title-tag' );

		/*
		* Enable support for Post Thumbnails on posts and pages.
		*
		* @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		*/
		add_theme_support( 'post-thumbnails' );

		// This theme uses wp_nav_menu() in one location.
		register_nav_menus(
			array(
				'primary' => esc_html__( 'Primary', 'dormatic' ),
			)
		);

		function dormatic_upload_mimes( $existing_mimes ) {
			$existing_mimes['webp'] = 'image/webp';
			return $existing_mimes;
		}
		add_filter( 'mime_types', 'dormatic_upload_mimes' );

		/*
		* Switch default core markup for search form, comment form, and comments
		* to output valid HTML5.
		*/
		add_theme_support(
			'html5',
			array(
				'search-form',
				'comment-form',
				'comment-list',
				'gallery',
				'caption',
			)
		);

		// Set up the WordPress core custom background feature.
		add_theme_support(
			'custom-background',
			apply_filters(
				'dormatic_custom_background_args',
				array(
					'default-color' => 'ffffff',
					'default-image' => '',
				)
			)
		);

		// Add theme support for selective refresh for widgets.
		add_theme_support( 'customize-selective-refresh-widgets' );

		/**
		 * Add support for core custom logo.
		 *
		 * @link https://codex.wordpress.org/Theme_Logo
		 */
		add_theme_support(
			'custom-logo',
			array(
				'height'      => 250,
				'width'       => 250,
				'flex-width'  => true,
				'flex-height' => true,
			)
		);

		add_image_size( 'dormatic-recent-post-size', 66, 67, true );
		add_image_size( 'dormatic-blog-grid', 360, 300, true );
	}
endif;
add_action( 'after_setup_theme', 'dormatic_setup' );
/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function dormatic_content_width() {
	// This variable is intended to be overruled from themes.
	// Open WPCS issue: {@link https://github.com/WordPress-Coding-Standards/WordPress-Coding-Standards/issues/1043}.
	// phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
	$GLOBALS['content_width'] = apply_filters( 'dormatic_content_width', 640 );
}
add_action( 'after_setup_theme', 'dormatic_content_width', 0 );
/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function dormatic_widgets_init() {

	register_sidebar(
		array(
			'name'          => esc_html__( 'Blog Sidebar', 'dormatic' ),
			'id'            => 'sidebar-1',
			'description'   => esc_html__( 'Add widgets here.', 'dormatic' ),
			'before_widget' => '<div id="%1$s" class="sidebar-widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<div class="widget-title"><h3>',
			'after_title'   => '</h3></div>',
		)
	);

	register_sidebar(
		array(
			'name'          => esc_html__( 'Service Sidebar', 'dormatic' ),
			'id'            => 'service-sidebar',
			'description'   => esc_html__( 'Add widgets here.', 'dormatic' ),
			'before_widget' => '<div id="%1$s" class="sidebar-widget sidebar-category %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<div class="widget-title"><h3>',
			'after_title'   => '</h3></div>',
		)
	);

}
add_action( 'widgets_init', 'dormatic_widgets_init' );

function dormatic_tag_cloud_widget() {
	$tag_args = array(
		'format' => 'list',
		'echo'   => false,
	);
	return $tag_args;
}
add_filter( 'widget_tag_cloud_args', 'dormatic_tag_cloud_widget' );


/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require get_template_directory() . '/inc/template-functions.php';

/**
 * google font compatibility.
 */
function dormatic_google_font() {
	global $dormatic_options;
	$enable_google_fonts = isset( $dormatic_options['enable_google_fonts'] ) && $dormatic_options['enable_google_fonts'] == 0;

	$protocol   = is_ssl() ? 'https' : 'http';
	$subsets    = 'latin,cyrillic-ext,latin-ext,cyrillic,greek-ext,greek,vietnamese';
	$variants   = ':300,400,400i,500,500i,600,600i,700,700i,800,800i,900,900i';
	$query_args = array(
		'family' => 'Barlow' . $variants,
		'subset' => $subsets,
	);
	$font_url   = add_query_arg( $query_args, $protocol . '://fonts.googleapis.com/css?display=swap' );
	if ( $enable_google_fonts != 1 ) {
		wp_enqueue_style( 'dormatic-google-fonts', $font_url, array(), null );
	}
}
add_action( 'init', 'dormatic_google_font' );


function dormatic_elementor_library() {
	$pageslist = get_posts(
		array(
			'post_type'      => 'elementor_library',
			'posts_per_page' => -1,
		)
	);
	$pagearray = array();
	if ( ! empty( $pageslist ) ) {
		foreach ( $pageslist as $page ) {
			$pagearray[ $page->ID ] = $page->post_title;
		}
	}
	return $pagearray;
}

add_filter( 'comment_form_fields', 'dormatic_custom_field' );
function dormatic_custom_field( $fields ) {
	$comment_field = $fields['comment'];
	unset( $fields['comment'] );
	unset( $fields['cookies'] );
	$fields['comment'] = $comment_field;
	return $fields;
}

function dormatic_add_query_vars_filter( $vars ) {
	 $vars[] = 'blog_style';
	return $vars;
}
add_filter( 'query_vars', 'dormatic_add_query_vars_filter' );

function dormatic_add_query_vars_filter_header( $vars ) {
	$vars[] = 'header_type';
	return $vars;
}
add_filter( 'query_vars', 'dormatic_add_query_vars_filter_header' );

/**
* Create Logo Setting and size Control
*/
function dormatic_new_customizer_settings($wp_customize) {
	// add a setting for the site logo size
	$wp_customize->add_setting('dormatic_logo_max_width', array(
		'sanitize_callback'  => 'esc_attr',
	));
	// Add a control to upload the logo size
	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'dormatic_logo_max_width',
	array(
	'label' => 'Logo Max Width in px Value',
	'section' => 'title_tagline',
	'settings' => 'dormatic_logo_max_width',
	'type'   => 'number',
	'priority' => 10,
	) ) );
	$wp_customize->add_setting('dormatic_sticky_logo_max_width', array(
		'sanitize_callback'  => 'esc_attr',
	));
	// Add a control to upload the logo size
	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'dormatic_sticky_logo_max_width',
	array(
	'label' => 'Sticky Logo Max Width in px Value',
	'section' => 'title_tagline',
	'settings' => 'dormatic_sticky_logo_max_width',
	'type'   => 'number',
	'priority' => 10,
	) ) );
	$wp_customize->add_setting('dormatic_responsive_logo_max_width', array(
		'sanitize_callback'  => 'esc_attr',
	));
	// Add a control to upload the logo size
	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'dormatic_responsive_logo_max_width',
	array(
	'label' => 'Responsive Logo Max Width in px Value',
	'section' => 'title_tagline',
	'settings' => 'dormatic_responsive_logo_max_width',
	'type'   => 'number',
	'priority' => 10,
	) ) );
	}
add_action('customize_register', 'dormatic_new_customizer_settings');