<?php
function dormatic_daynamic_styles() {
	ob_start();
	$dormatic_daynamic_styles_array = array();
	
	if ( is_page() ) {
		$featured_img_url = get_the_post_thumbnail_url( get_the_ID(), 'full' );
		if ( $featured_img_url ) {
			$page_breadcrumb_bg               = '
                .page-breadcrumb {
                    background-image: url(' . esc_url( $featured_img_url ) . ');
                }
                ';
			$dormatic_daynamic_styles_array[] = $page_breadcrumb_bg;
		}
	}
	$dormatic_daynamic_styles_array_expolord = implode( ' ', $dormatic_daynamic_styles_array );
	$dormatic_custom_css                     = ob_get_clean();
	return $dormatic_daynamic_styles_array_expolord;
}

function dormatic_get_custom_styles() {
	global $dormatic_options;
	$redix_opt_prefix = 'dormatic_';
	if ( ( isset( $dormatic_options[ $redix_opt_prefix . 'main_color' ] ) ) && ( ! empty( $dormatic_options[ $redix_opt_prefix . 'main_color' ] ) ) ) {
		$dormatic_main_color = $dormatic_options[ $redix_opt_prefix . 'main_color' ];
	}
	if ( ( isset( $dormatic_options[ $redix_opt_prefix . 'secondary_color' ] ) ) && ( ! empty( $dormatic_options[ $redix_opt_prefix . 'secondary_color' ] ) ) ) {
		$dormatic_secondary_color = $dormatic_options[ $redix_opt_prefix . 'secondary_color' ];
	}
	if ( get_theme_mod( 'dormatic_logo_max_width' ) ) {
		$dormatic_logo_max_width = get_theme_mod( 'dormatic_logo_max_width' );
	}
	if ( get_theme_mod( 'dormatic_sticky_logo_max_width' ) ) {
		$dormatic_sticky_logo_max_width = get_theme_mod( 'dormatic_sticky_logo_max_width' );
	}
	if ( get_theme_mod( 'dormatic_responsive_logo_max_width' ) ) {
		$dormatic_responsive_logo_max_width = get_theme_mod( 'dormatic_responsive_logo_max_width' );
	}
	ob_start();
	if ( !empty($dormatic_logo_max_width ) ) { ?>
		.logo img {
			max-width: <?php echo esc_attr( $dormatic_logo_max_width ); ?>px;
			width: <?php echo esc_attr( $dormatic_logo_max_width ); ?>px;
		}
		<?php } 
		
		if ( !empty($dormatic_sticky_logo_max_width ) ) { ?>
		.main-header .sticky-header .logo img {
			max-width: <?php echo esc_attr( $dormatic_sticky_logo_max_width ); ?>px;
			width: <?php echo esc_attr( $dormatic_sticky_logo_max_width ); ?>px;
		}
		<?php } 
	
		if ( !empty($dormatic_responsive_logo_max_width ) ) { ?>
		@media only screen and (max-width: 991px){
			.logo img {
			max-width: <?php echo esc_attr( $dormatic_responsive_logo_max_width ); ?>px;
			width: <?php echo esc_attr( $dormatic_responsive_logo_max_width ); ?>px;
			}
		}
		<?php } 
	if ( ( isset( $dormatic_options[ $redix_opt_prefix . 'main_color' ] ) ) && ( ! empty( $dormatic_options[ $redix_opt_prefix . 'main_color' ] ) ) ) {
		?>
.scroll-top {
	background-color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.header-top .top-inner .info li i {
	color: #66dce9;
}
.header-top .top-inner .social-links li a:hover {
	color: <?php echo esc_attr( $dormatic_main_color ); ?> !important;
}
.header-top .top-inner .dropdown-box ul li a:hover {
	color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.header-top .top-inner .dropdown-box ul {
	border-top: 2px solid <?php echo esc_attr( $dormatic_main_color ); ?> !important;
}
.theme-btn-one {
	background-color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.main-menu .navigation>li>a:before {
	background-color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.main-header .search-box-btn:hover {
	color: <?php echo esc_attr( $dormatic_main_color ); ?>;
	border-color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.main-menu .navigation>li>ul>li>a:hover,
.main-menu .navigation>li>.megamenu li>a:hover {
	color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.main-menu .navigation>li>ul>li>ul>li>a:hover {
	color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.banner-carousel .content-box h5 {
	color: <?php echo esc_attr( $dormatic_secondary_color ); ?>;
}
.banner-carousel .content-box .btn-box .call-now {
	border: 1px dashed #20445a;
}
.banner-carousel .content-box .btn-box .call-now .inner {
	background-color: #20445a;
}
.service-form-section .service-form .title-inner .link a {
	border: 1px dashed <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.service-form-section .service-form .title-inner .link a i {
	color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.service-form-section .service-form .title-inner .link a svg {
    fill: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.service-form-section .service-form .title-inner .link a:hover {
	color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.service-form-section .service-form .form-inner .form-group input:focus {
	border: 1px solid <?php echo esc_attr( $dormatic_main_color ); ?> !important;
}
.feature-block-one .inner-box {
	border-left: 2px solid <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.feature-block-one .inner-box .icon-box {
	border: 1px dashed <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.feature-block-one .inner-box .icon-box .icon:before {
	background-color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.feature-block-one .inner-box:hover .icon-box .icon {
	background-color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.feature-block-one .inner-box .link a:before {
	background-color: <?php echo esc_attr( $dormatic_secondary_color ); ?>;
}
.feature-block-one .inner-box .link a:hover {
	color: <?php echo esc_attr( $dormatic_main_color ); ?>;
	border-color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.image_block_1 .image-box .image-content {
	border-left: 4px solid <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.image_block_1 .image-box .image-content h2 {
	color: <?php echo esc_attr( $dormatic_secondary_color ); ?>;
}
.banner-section .owl-theme .owl-dots .owl-dot span:before {
	background-color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.content_block_1 .content-box .author-box h3 {
	color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.service-block-one .inner-box .image-box {
	background-color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.service-block-one .inner-box .lower-content .icon-box .icon:before {
	background-color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.service-block-one .inner-box:hover .lower-content .icon-box .icon {
	background-color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.service-block-one .inner-box .lower-content .text h3 a:hover {
	color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.service-block-one .inner-box .lower-content .link a:hover {
	color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.service-block-one .inner-box .lower-content .link a:before {
	background: <?php echo esc_attr( $dormatic_secondary_color ); ?>;
}
.service-block-one .inner-box .lower-content .link {
	border-bottom: 2px solid <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.service-block-one .inner-box {
	border-bottom: 2px solid <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.nav-style-one .owl-prev:hover,
.nav-style-one .owl-next:hover {
	border-color: <?php echo esc_attr( $dormatic_main_color ); ?>;
	background: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.cta-text h3 a {
	color: <?php echo esc_attr( $dormatic_secondary_color ); ?>;
	border-bottom: 1px dashed <?php echo esc_attr( $dormatic_secondary_color ); ?>;
}
.cta-text h3 a span {
	color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.content_block_2 .content-box .inner-box .text h2 {
	color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.chooseus-block-one .inner-box .icon-box .icon-shape:before {
	background-color: <?php echo esc_attr( $dormatic_secondary_color ); ?>;
}
.chooseus-block-one .inner-box .icon-box .icon-shape:after {
	background-color: <?php echo esc_attr( $dormatic_secondary_color ); ?>;
}
.project-block-one .inner-box .lower-content .inner .link a {
	color: <?php echo esc_attr( $dormatic_main_color ); ?>;
	border-bottom: 1px solid <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.project-block-one .inner-box .lower-content .inner .link a:before {
	background-color: <?php echo esc_attr( $dormatic_secondary_color ); ?>;
}
.dots-style-one .owl-dots .owl-dot.active span,
.dots-style-one .owl-dots .owl-dot span:hover {
	background-color: <?php echo esc_attr( $dormatic_main_color ); ?>;
	border-color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.testimonial-section .title-inner .text a {
	border: 1px dashed <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.testimonial-section .title-inner .text a:hover {
	color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.testimonial-block-one .inner-box .author-box .rating li.full {
	color: <?php echo esc_attr( $dormatic_secondary_color ); ?>;
}
.counter-block-one .inner-box .icon-box {
	color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.counter-block-one .inner-box p {
	border-bottom: 1px dashed #51d0de;
}
.content_block_3 .content-box .text .location-list li:before {
	color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.content_block_4 .content-box .support-box {
	border: 1px dashed <?php echo esc_attr( $dormatic_secondary_color ); ?>;
}
.content_block_4 .content-box .support-box h3 a {
	color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.content_block_4 .content-box .support-box:before,
.content_block_4 .content-box .support-box:after {
	background-color: <?php echo esc_attr( $dormatic_secondary_color ); ?>;
}
.news-block-one .inner-box .image-box a {
	border: 1px dashed <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.news-block-one .inner-box .image-box a:before {
	background-color: <?php echo esc_attr( $dormatic_secondary_color ); ?>;
}
.news-block-one .inner-box .image-box a:hover {
	color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.news-block-one .inner-box .lower-content .inner .post-meta li a:hover {
	color: <?php echo esc_attr( $dormatic_main_color ); ?> !important;
}
.news-block-one .inner-box .lower-content .inner .post-meta li span.cat-list a {
	background-color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.news-block-one .inner-box .lower-content .inner h3 a:hover {
	color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.news-block-one .inner-box .lower-content .post-info .info li a:hover {
	color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.cta-section {
	border-bottom: 3px solid <?php echo esc_attr( $dormatic_secondary_color ); ?>;
}
.cta-section .inner-box .btn-box a.call {
	color: <?php echo esc_attr( $dormatic_secondary_color ); ?>;
	border: 1px dashed <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.main-footer .widget-section .logo-widget .social-links li a:hover {
	background-color: <?php echo esc_attr( $dormatic_secondary_color ); ?>;
}
.main-footer .widget-title:before {
	border: 1px dashed <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.main-footer .widget-section .links-widget .links-list li a:hover:before {
	color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.main-footer .widget-section .contact-widget .info li a:hover {
	color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.main-footer .footer-bottom .copyright p a:hover {
	color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.cta-section .inner-box .btn-box a.call:hover {
	color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.header-top .phone-box p i {
	color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.header-top .phone-box p a {
	color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.main-header .header-top .single-box p i {
	color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.feature-block-two .inner-box .link a {
	color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.feature-block-two .inner-box .overlay-content .icon-box:before {
	border-bottom: 1px dashed #66dce9;
}
.feature-block-two .inner-box .overlay-content {
	border-bottom: 4px solid <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.feature-block-two .inner-box .overlay-content .link a:before {
	border: 1px dashed <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.image_block_2 .image-box .single-box {
	border-left: 4px solid #68dbe8;
}
.image_block_2 .image-box .single-box h2 i {
	color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.image_block_2 .image-box .single-box p {
	border-bottom: 1px dashed #68dae7;
}
.image_block_2 .image-box .content-three {
	border: 2px solid #329b48;
}
.image_block_2 .image-box .content-three .text {
	background-color: #329b48;
}
.image_block_2 .image-box .content-three .icon-box ul li {
	color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.content_block_5 .content-box .text .list li:before {
	color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.content_block_5 .content-box .btn-box a {
	border: 2px dashed <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.content_block_5 .content-box .btn-box a:before {
	background-color: <?php echo esc_attr( $dormatic_secondary_color ); ?>;
}
.content_block_5 .content-box .btn-box a:hover {
	border: 2px solid <?php echo esc_attr( $dormatic_main_color ); ?>;
	background-color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.service-block-two .inner-box .content-box .icon-box {
	background-color: #68dbe8;
}
.service-block-two .inner-box .content-box h2 a:hover {
	color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.service-block-two .inner-box .content-box .list li:before {
	color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.service-block-two .inner-box .content-box .btn-box .theme-btn-one:before,
.service-block-two .inner-box .content-box .btn-box .theme-btn-one:after {
	background-color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.service-block-two .inner-box .image-box .image-content .icon {
	background-color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.service-block-two .inner-box .image-box .image-content h5 {
	border: 2px dashed <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.bg-color-3 {
	background-color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.work-block-one .inner-box .icon-box span {
	color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.work-block-one .inner-box .icon-box .shape:before,
.work-block-one .inner-box .icon-box .shape:after {
	background-color: <?php echo esc_attr( $dormatic_secondary_color ); ?>;
}
.tabs-box .tab-btn-box .tab-btns li {
	border-bottom: 1px solid <?php echo esc_attr( $dormatic_secondary_color ); ?>;
}
.tabs-box .tab-btn-box .tab-btns li:before {
	background-color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.tabs-box .tab-btn-box .tab-btns li:hover .icon-box,
.tabs-box .tab-btn-box .tab-btns li.active-btn .icon-box {
	color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.tabs-box .tabs-content .text a {
	border: 1px dashed <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.tabs-box .tabs-content .text a:before {
	background-color: <?php echo esc_attr( $dormatic_secondary_color ); ?>;
}
.tabs-box .tabs-content .text a:hover {
	border-color: <?php echo esc_attr( $dormatic_main_color ); ?>;
	background-color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.video_block_1 .video-content .video-btn a {
	background-color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.team-block-one .inner-box .lower-content h3 a:hover {
	color: <?php echo esc_attr( $dormatic_main_color ); ?> !important;
}
.team-block-one .inner-box .lower-content .link a {
	color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.team-block-one .inner-box .lower-content .link a:hover {
	background: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.team-block-one .inner-box .lower-content .link a:before {
	border: 1px dashed <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.team-block-one .inner-box:hover {
	border-color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.team-block-one .inner-box .lower-content .social-links li a:hover {
	color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.project-block-two .inner-box .link a:hover {
	color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.project-block-two .inner-box .text a {
	color: <?php echo esc_attr( $dormatic_main_color ); ?>;
	border-bottom: 1px solid <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.project-style-two .sortable-masonry .filters .filter-tabs li.active,
.project-style-two .sortable-masonry .filters .filter-tabs li:hover {
	color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.testimonial-block-two .inner-box .icon-box {
	color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.testimonial-block-two .inner-box .author-box .rating li {
	color: #ffce4a;
}
.testimonial-style-two .thumb-box .icon-1 {
	background-color: <?php echo esc_attr( $dormatic_secondary_color ); ?>;
}
.testimonial-style-two .thumb-box .icon-3 {
	background-color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.testimonial-style-two .thumb-box .icon-4 {
	background-color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.testimonial-style-two .thumb-box .icon-6 {
	background-color: <?php echo esc_attr( $dormatic_secondary_color ); ?>;
}
.header-upper {
	border-top: 5px solid <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.header-upper .upper-info li h3 a:hover {
	color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.main-header.style-three .menu-right-content form .form-group input[type='search']:focus {
	border-color: <?php echo esc_attr( $dormatic_main_color ); ?> !important;
}
.main-header.style-three .menu-right-content form .form-group input:focus+button,
.main-header.style-three .menu-right-content form .form-group button:hover {
	color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.main-header.style-three .menu-right-content .social-links li a:hover {
	background: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.banner-section.style-three .content-box .btn-box {
	border: 1px dashed #66dce9;
}
.banner-section.style-three .banner-btn .btn-shape:before,
.banner-section.style-three .banner-btn .btn-shape:after {
	background: <?php echo esc_attr( $dormatic_secondary_color ); ?>;
}
.feature-block-three .inner-box .icon-box {
	border: 1px dashed <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.feature-block-three .inner-box:hover .icon-box {
	color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.service-block-one .inner-box:hover .lower-content .icon-box .icon {
	border-color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.about-style-three .content-box .author h3 {
	color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.counter-block-two .inner-box p {
	border-bottom: 1px dashed <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.service-style-three .service-block-one .inner-box:hover .lower-content .icon-box {
	background: #f1f7fb;
}
.service-style-three .service-block-one .inner-box .lower-content .link a:hover {
	color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.service-style-three .service-block-one .inner-box .lower-content .text h3 a:hover {
	color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.feature-block-four .inner-box .link a {
	border: 1px dashed <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.feature-block-four .inner-box .link a:hover {
	border: 1px solid <?php echo esc_attr( $dormatic_main_color ); ?>;
	background-color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.feature-block-four .inner-box .icon-box:before,
.feature-block-four .inner-box .icon-box:after {
	background-color: <?php echo esc_attr( $dormatic_secondary_color ); ?>;
}
.feature-style-four .image-box .image-content .inner h2 {
	color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.pricing-block-one .pricing-table .table-header {
	border-bottom: 1px dashed #66dce9;
}
.pricing-block-one .pricing-table .table-content h3 {
	color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.pricing-block-one .pricing-table .table-footer a:before,
.pricing-block-one .pricing-table .table-footer a:after {
	background-color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.project-block-three .inner-box .content-box .text a {
	color: <?php echo esc_attr( $dormatic_main_color ); ?>;
	border-bottom: 1px solid <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.project-block-three .inner-box .content-box .text a:before {
	background-color: <?php echo esc_attr( $dormatic_secondary_color ); ?>;
}
.appointment-section .map-inner .map-content .inner .icon-box {
	background-color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.appointment-section .map-inner .map-content .inner h6 a:hover {
	color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.appointment-section .appointment-form .form-group input:focus,
.appointment-section .appointment-form .form-group textarea:focus {
	border-color: <?php echo esc_attr( $dormatic_main_color ); ?> !important;
}
.border-top {
	border-top: 3px solid <?php echo esc_attr( $dormatic_secondary_color ); ?> !important;
}
.rtl .image_block_1 .image-box .image-content {
	border-right: 4px solid <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.page-title .content-box .bread-crumb li:before {
	background-color: <?php echo esc_attr( $dormatic_secondary_color ); ?>;
}
.page-title .content-box .bread-crumb li a:hover {
	color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.cta-section .inner-box .btn-box a.theme-btn-one:hover {
	color: <?php echo esc_attr( $dormatic_main_color ); ?> !important;
}
.cta-section .inner-box .btn-box a.theme-btn-one:hover .btn-shape:before,
.cta-section .inner-box .btn-box a.theme-btn-one:hover .btn-shape:after {
	background: <?php echo esc_attr( $dormatic_main_color ); ?>;
	opacity: 0.2;
}
.service-details-content .two-column .inner-box .single-item .icon-box .icon-shape:before,
.service-details-content .two-column .inner-box .single-item .icon-box .icon-shape:after {
	background-color: <?php echo esc_attr( $dormatic_secondary_color ); ?>;
}
.service-details-content .content-two .text ul li:before {
	color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.service-details-content .service-project .single-project .link a {
	color: <?php echo esc_attr( $dormatic_main_color ); ?>;
	border-bottom: 1px solid <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.service-details-content .service-project .single-project .link a:before {
	background: <?php echo esc_attr( $dormatic_secondary_color ); ?>;
}
.service-details-content .service-project .single-project .overlay-content .view-btn a:hover {
	color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.default-sidebar .widget-title:before {
	background: <?php echo esc_attr( $dormatic_secondary_color ); ?>;
}
.service-sidebar .sidebar-category .category-list li a {
	border: 1px dashed <?php echo esc_attr( $dormatic_secondary_color ); ?>;
}
.service-sidebar .sidebar-category .category-list li a.current,
.service-sidebar .sidebar-category .category-list li a:hover {
	color: <?php echo esc_attr( $dormatic_main_color ); ?>;
	border-color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.service-sidebar .sidebar-category .category-list li a.current:before,
.service-sidebar .sidebar-category .category-list li a:hover:before {
	color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.service-sidebar .download-brochure .list li a:hover {
	color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.default-sidebar .support-box .inner-box .icon-box {
	border: 2px dashed <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.default-sidebar .support-box .inner-box a.phone-box {
	color: <?php echo esc_attr( $dormatic_secondary_color ); ?>;
	border: 1px dashed <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.default-sidebar .support-box .inner-box a.phone-box:hover {
	color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.default-sidebar .support-box .inner-box a.email:hover {
	color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.default-sidebar .support-box .inner-box {
	border-bottom: 2px solid <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.pagination li a:hover,
.pagination li a.current {
	color: <?php echo esc_attr( $dormatic_main_color ); ?>;
	border-color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.news-block-one .inner-box .lower-content .inner h2 a:hover {
	color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.sidebar-page-container .news-block-one .inner-box .lower-content .post-info .info li.link a:before {
	background-color: <?php echo esc_attr( $dormatic_secondary_color ); ?>;
}
.sidebar-page-container .news-block-one .inner-box .lower-content .post-info .info li.link a:hover {
	color: <?php echo esc_attr( $dormatic_main_color ); ?>;
	border-color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.blog-sidebar .sidebar-search .search-form .form-group button {
	color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.blog-sidebar .sidebar-search .search-form .form-group input:focus {
	border-color: <?php echo esc_attr( $dormatic_main_color ); ?> !important;
}
.blog-sidebar .widget_archive ul li a:hover,
.blog-sidebar .widget_categories ul li a:hover {
	color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.blog-sidebar .sidebar-post .post h5 a:hover {
	color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.blog-sidebar .sidebar-post .post .post-date i {
	color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.blog-sidebar .sidebar-tags .tags-list li a:hover {
	background: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.blog-details-content .news-block-one .inner-box .post-info .tags li i {
	color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.blog-details-content .nav-box a:hover {
	color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.blog-details-content .nav-box a i {
	color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.group-title:before {
	background-color: <?php echo esc_attr( $dormatic_secondary_color ); ?>;
}
.blog-details-content .comment-box .comment .comment-inner a.reply-btn {
	border: 1px dashed <?php echo esc_attr( $dormatic_secondary_color ); ?>;
}
.blog-details-content .comment-box .comment .comment-inner a.reply-btn i {
	color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.blog-details-content .comment-box .comment .comment-inner a.reply-btn:hover {
	color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.blog-details-content .comments-form-area .default-form .form-group input:focus,
.blog-details-content .comments-form-area .default-form .form-group textarea:focus {
	border-color: <?php echo esc_attr( $dormatic_main_color ); ?> !important;
}
.contact-section .inner-content .title-inner .link a {
	border: 1px dashed <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.contact-section .inner-content .title-inner .link a i {
	color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.contact-section .inner-content .title-inner .link a svg {
	fill: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.contact-section .inner-content .title-inner .link a:hover {
	color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.contact-section .default-form .form-group input:focus,
.contact-section .default-form .form-group textarea:focus {
	border-color: <?php echo esc_attr( $dormatic_main_color ); ?> !important;
}
.contact-info-two .single-info-box .icon-box {
	border: 1px dashed <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.contact-info-two .single-info-box p a:hover {
	color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
.news-block-one .inner-box .lower-content .inner .post-meta li i {
	color: <?php echo esc_attr( $dormatic_main_color ); ?>;
}
		<?php
	}
	$dormatic_custom_css = ob_get_clean();
	return $dormatic_custom_css;
}
