<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package dormatic
 */

$footer_copyright = dormatic_get_options( 'footer_copyright' );
?>

<footer class="main-footer border-top">
<?php get_template_part( 'components/footer/footer-top' ); ?>
	<div class="footer-bottom centred">
		<div class="auto-container">
			<div class="copyright">
				<p>
					<?php
					if ( $footer_copyright != '' ) :
						echo wp_kses( $footer_copyright, 'dormatic_kses' );
						else :
							echo esc_html__( '&copy; Copyright 2021 by DORMATIC', 'dormatic' );
						endif;
						?>
				</p>
			</div>
		</div>
	</div>
</footer>
<?php do_action( 'dormatic_back_to_top' ); ?>
<?php wp_footer(); ?>
</body>
</html>
