<?php
$header_button_text = dormatic_get_options( 'header_button_text' );
$header_button_url  = dormatic_get_options( 'header_button_url' );

$header_address_two = dormatic_get_options( 'header_address_two' );
$header_hours       = dormatic_get_options( 'header_hours' );
$header_phone_two   = dormatic_get_options( 'header_phone_two' );
$header_social      = dormatic_get_options( 'header_social' );
$sticky_header_on   = dormatic_get_options( 'sticky_header_on' );

?>
<header class="main-header style-three">
	<!-- header-upper -->
	<div class="header-upper">
		<div class="auto-container">
			<div class="upper-inner">
				<?php do_action( 'dormatic_header_logo_two' ); ?>
				<ul class="upper-info clearfix">
					<li>
						<i class="fal fa-phone"></i>
						<?php echo wp_kses( $header_phone_two, 'dormatic_kses' ); ?>
					</li>
					<li>
						<i class="fal fa-map-signs"></i> 
						<?php echo wp_kses( $header_address_two, 'dormatic_kses' ); ?>
					</li>
					<?php if ( $header_button_text && $header_button_url ) : ?>
						<li class="btn-box">
							<a href="<?php echo esc_url( $header_button_url ); ?>" class="theme-btn-one"><span class="btn-shape"></span><?php echo esc_html( $header_button_text ); ?></a>
						</li>
					<?php endif; ?>
				</ul>
			</div>
		</div>
	</div>

	<!-- header-lower -->
	<div class="auto-container">
		<div class="header-lower">
			<div class="outer-box clearfix">
				<div class="menu-area pull-left">
					<!--Mobile Navigation Toggler-->
					<div class="mobile-nav-toggler">
						<i class="icon-bar"></i>
						<i class="icon-bar"></i>
						<i class="icon-bar"></i>
					</div>
					<?php do_action( 'dormatic_header_menu' ); ?>
				</div>
				<div class="menu-right-content clearfix">
					<?php do_action( 'dormatic_search_form' ); ?>
					<?php if ( $header_social ) : ?>
					<ul class="social-links clearfix">
						<?php echo wp_kses( $header_social, 'dormatic_kses' ); ?>
					</ul>
					<?php endif; ?>
				</div>
			</div>
		</div>
	</div>

	<!--sticky Header-->
	<?php if ( $sticky_header_on ) : ?>
	<div class="sticky-header">
		<div class="auto-container">
			<div class="outer-box clearfix">
				<?php do_action( 'dormatic_header_logo_sticky' ); ?>
				<div class="menu-area pull-right">
					<nav class="main-menu clearfix">
						<!--Keep This Empty / Menu will come through Javascript-->
					</nav>
					<div class="menu-right-content clearfix">
						<?php do_action( 'dormatic_search_popup_sticky' ); ?>
						<?php if ( $header_button_text && $header_button_url ) : ?>
						<div class="btn-box">
							<a href="<?php echo esc_url( $header_button_url ); ?>" class="theme-btn-one"><span class="btn-shape"></span><?php echo esc_html( $header_button_text ); ?></a>
						</div>
						<?php endif; ?>
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php endif; ?>
</header>
<!-- main-header end -->
