<?php
function to_bool( $bool ) {
	 return ( is_bool( $bool ) ? $bool : ( is_numeric( $bool ) ? ( (bool) intval( $bool ) ) : $bool !== 'false' ) );
}

function dormatic_images_size() {
	add_image_size( 'dormatic-blog-home', 370, 290, true );
	add_image_size( 'dormatic-blog-image-size', 370, 317, true );
}

add_action( 'after_setup_theme', 'dormatic_images_size' );

if ( ! function_exists( 'get_elementor_library' ) ) {
	function get_elementor_library() {
		$pageslist = get_posts(
			array(
				'post_type'      => 'elementor_library',
				'posts_per_page' => -1,
			)
		);
		$pagearray = array();
		if ( ! empty( $pageslist ) ) {
			foreach ( $pageslist as $page ) {
				$pagearray[ $page->ID ] = $page->post_title;
			}
		}
		return $pagearray;
	}
}

function getContactForm7Posts() {
	$args    = array(
		'post_type'      => 'wpcf7_contact_form',
		'posts_per_page' => -1,
	);
	$catlist = array();
	if ( $categories = get_posts( $args ) ) {
		foreach ( $categories as $category ) {
			(int) $catlist[ $category->ID ] = $category->post_title;
		}
	} else {
		(int) $catlist['0'] = esc_html__( 'No contect From 7 form found', 'dormatic-core' );
	}
	return $catlist;
}

// css individual Load
add_filter( 'combine_vc_ele_css_pb_build_css_assets_css_path', 'dormatic_css_list' );
function dormatic_css_list( $product_css_path ) {
	$product_css_path = plugin_dir_path( __DIR__ ) . '/assets/elementor/css/';
	return $product_css_path;
}

add_filter( 'combine_vc_ele_css_pb_build_css_assets_css_url', 'dormatic_css_list_url' );
function dormatic_css_list_url() {
	 $product_css_path = plugin_dir_url( __DIR__ ) . '/assets/elementor/css/';
	return $product_css_path;
}

add_filter( 'combine_vc_ele_css_pb_sc_list_array', 'dormatic_array_list' );
function dormatic_array_list( $product_css_array ) {
	$product_css_array = array(
		'dormatic_banner_slider'        => array(
			'css'      => array( 'banner-slider' ),
			'js'       => array(),
			'external' => array(
				'css' => array(),
				'js'  => array(),
			),
		),
		'dormatic_feature'              => array(
			'css'      => array( 'feature-section' ),
			'js'       => array(),
			'external' => array(
				'css' => array(),
				'js'  => array(),
			),
		),
		'dormatic_about_section'        => array(
			'css'      => array( 'about-section' ),
			'js'       => array(),
			'external' => array(
				'css' => array(),
				'js'  => array(),
			),
		),
		'dormatic_about_section'        => array(
			'css'      => array( 'about-section' ),
			'js'       => array(),
			'external' => array(
				'css' => array(),
				'js'  => array(),
			),
		),
		'dormatic_about_two'            => array(
			'css'      => array( 'about-section' ),
			'js'       => array(),
			'external' => array(
				'css' => array(),
				'js'  => array(),
			),
		),
		'dormatic_servces'              => array(
			'css'      => array( 'service-section' ),
			'js'       => array(),
			'external' => array(
				'css' => array(),
				'js'  => array(),
			),
		),
		'dormatic_servces_two'          => array(
			'css'      => array( 'service-section' ),
			'js'       => array(),
			'external' => array(
				'css' => array(),
				'js'  => array(),
			),
		),
		'dormatic_why_choose_us'        => array(
			'css'      => array( 'chooseus-section', 'feature-section' ),
			'js'       => array(),
			'external' => array(
				'css' => array(),
				'js'  => array(),
			),
		),
		'dormatic_installation_section' => array(
			'css'      => array( 'installation-section' ),
			'js'       => array(),
			'external' => array(
				'css' => array(),
				'js'  => array(),
			),
		),
		'dormatic_projects'             => array(
			'css'      => array( 'project-section' ),
			'js'       => array(),
			'external' => array(
				'css' => array(),
				'js'  => array(),
			),
		),
		'dormatic_team'                 => array(
			'css'      => array( 'team-section' ),
			'js'       => array(),
			'external' => array(
				'css' => array(),
				'js'  => array(),
			),
		),
		'dormatic_pricing'              => array(
			'css'      => array( 'pricing-section' ),
			'js'       => array(),
			'external' => array(
				'css' => array(),
				'js'  => array(),
			),
		),
		'dormatic_funfact'              => array(
			'css'      => array( 'funfact-section' ),
			'js'       => array(),
			'external' => array(
				'css' => array(),
				'js'  => array(),
			),
		),
		'dormatic_testimonial'          => array(
			'css'      => array( 'testimonial-section' ),
			'js'       => array(),
			'external' => array(
				'css' => array(),
				'js'  => array(),
			),
		),
		'dormatic_cta'                  => array(
			'css'      => array( 'cta-section' ),
			'js'       => array(),
			'external' => array(
				'css' => array(),
				'js'  => array(),
			),
		),
		'dormatic_cta_two'              => array(
			'css'      => array( 'cta-section' ),
			'js'       => array(),
			'external' => array(
				'css' => array(),
				'js'  => array(),
			),
		),

		'dormatic_clients'              => array(
			'css'      => array( 'clients-section' ),
			'js'       => array(),
			'external' => array(
				'css' => array(),
				'js'  => array(),
			),
		),
		'dormatic_works'                => array(
			'css'      => array( 'works-section' ),
			'js'       => array(),
			'external' => array(
				'css' => array(),
				'js'  => array(),
			),
		),
		'dormatic_appointment_section'  => array(
			'css'      => array( 'appointment-section' ),
			'js'       => array(),
			'external' => array(
				'css' => array(),
				'js'  => array(),
			),
		),
		'dormatic_contact_info'         => array(
			'css'      => array( 'contact-info' ),
			'js'       => array(),
			'external' => array(
				'css' => array(),
				'js'  => array(),
			),
		),
		'dormatic_contact_info_two'     => array(
			'css'      => array( 'contact-info' ),
			'js'       => array(),
			'external' => array(
				'css' => array(),
				'js'  => array(),
			),
		),
		'dormatic_service_form'         => array(
			'css'      => array( 'service-form' ),
			'js'       => array(),
			'external' => array(
				'css' => array(),
				'js'  => array(),
			),
		),
	);
	return $product_css_array;
}


