<?php
namespace Dormatic\Helper\Elementor\Widgets;

use Elementor\Utils;
use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use Elementor\Plugin;
use Elementor\Repeater;
use Elementor\Group_Control_Typography;

class Dormatic_Testimonial extends Widget_Base {

	public function get_name() {
		return 'dormatic_testimonial';
	}

	public function get_title() {
		return esc_html__( 'Dormatic Testimonial', 'dormatic' );
	}

	public function get_icon() {
		return 'sds-widget-ico';
	}

	public function get_categories() {
		return array( 'Dormatic' );
	}

	protected function register_controls() {

		$this->start_controls_section(
			'general',
			array(
				'label' => esc_html__( 'general', 'dormatic' ),
			)
		);
		$this->add_control(
			'layout_style',
			array(
				'label'   => esc_html__( 'Layout Style', 'dormatic-core' ),
				'type'    => Controls_Manager::SELECT,
				'options' => array(
					'style_1' => esc_html__( 'Style One', 'dormatic-core' ),
					'style_2' => esc_html__( 'Style Two', 'dormatic-core' ),
				),
				'default' => 'style_1',
			)
		);
		$this->add_control(
			'tagline',
			array(
				'label'   => esc_html__( 'Tagline', 'dormatic' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'Garage Door installation & Repair', 'dormatic' ),
			)
		);

		$this->add_control(
			'heading',
			array(
				'label'   => esc_html__( 'Heading', 'dormatic' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'Fully Satisfied And Happy Customers', 'dormatic' ),
			)
		);

		$this->add_control(
			'header_size',
			[
				'label' => esc_html__( 'HTML Tag', 'elementor' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'h1' => 'H1',
					'h2' => 'H2',
					'h3' => 'H3',
					'h4' => 'H4',
					'h5' => 'H5',
					'h6' => 'H6',
				],
				'default' => 'h2',
			]
		);

		$this->add_control(
			'sub_heading',
			array(
				'label'       => esc_html__( 'Sub Heading', 'dormatic' ),
				'type'        => Controls_Manager::TEXTAREA,
				'rows'        => 6,
				'default'     => __( 'Quam arcu pretium quis quam sed, laorey afficitur liquam volutpat.lobortis sem consq consequat imperdiet. In nulla sed. Lorem ipsum dolor sit ame tempor.', 'dormatic' ),
				'placeholder' => esc_html__( 'Type your description here', 'dormatic' ),

			)
		);

		$this->add_control(
			'button_text',
			array(
				'label'   => esc_html__( 'Button Text', 'dormatic' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'View All Customer Reviews', 'dormatic' ),
			)
		);

		$this->add_control(
			'button_url',
			array(
				'label'         => esc_html__( 'Button URL', 'dormatic' ),
				'type'          => Controls_Manager::URL,
				'placeholder'   => esc_html__( 'https://your-link.com', 'dormatic' ),
				'show_external' => true,
				'default'       => array(
					'url'         => '',
					'is_external' => false,
					'nofollow'    => false,
				),

			)
		);
		$this->add_control(
			'background_shape',
			array(
				'label'   => esc_html__( 'Background Shape', 'dormatic' ),
				'type'    => Controls_Manager::MEDIA,
				'default' => array(
					'url' => Utils::get_placeholder_image_src(),
				),

			)
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'item',
			array(
				'label' => esc_html__( 'item', 'dormatic' ),
			)
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'item_title',
			array(
				'label'   => esc_html__( 'Name', 'dormatic' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'Aaron Finch', 'dormatic' ),
			)
		);

		$repeater->add_control(
			'item_designation',
			array(
				'label'   => esc_html__( 'Designation', 'dormatic' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'Newyork, USA', 'dormatic' ),
			)
		);

		$repeater->add_control(
			'item_image',
			array(
				'label'   => esc_html__( 'Image', 'dormatic' ),
				'type'    => Controls_Manager::MEDIA,
				'default' => array(
					'url' => Utils::get_placeholder_image_src(),
				),

			)
		);
		$repeater->add_control(
			'review_title',
			array(
				'label'   => esc_html__( 'Review Title', 'dormatic' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'What Customers Are Saying ...', 'dormatic' ),
			)
		);
		$repeater->add_control(
			'item_text',
			array(
				'label'       => esc_html__( 'Review Text', 'dormatic' ),
				'type'        => Controls_Manager::TEXTAREA,
				'rows'        => 6,
				'default'     => __( 'Exercitation ullamco laboris nist aliquip ex ea comm aodo consequat. Duis autys irure dolor in reprehenderit in voluptate velit esse cillum dolore fugiat nulla ...', 'dormatic' ),
				'placeholder' => esc_html__( 'Type your description here', 'dormatic' ),

			)
		);

		$repeater->add_control(
			'item_select_rating',
			array(
				'label'   => esc_html__( 'Select Rating', 'dormatic' ),
				'type'    => Controls_Manager::SELECT,
				'options' => array(
					'1' => esc_html__( 'One', 'dormatic' ),
					'2' => esc_html__( 'Two', 'dormatic' ),
					'3' => esc_html__( 'Three', 'dormatic' ),
					'4' => esc_html__( 'Four', 'dormatic' ),
					'5' => esc_html__( 'Five', 'dormatic' ),

				),
				'default' => '1',

			)
		);

		$this->add_control(
			'items',
			array(
				'label'   => esc_html__( 'Repeater List', 'dormatic' ),
				'type'    => Controls_Manager::REPEATER,
				'fields'  => $repeater->get_controls(),
				'default' => array(
					array(
						'list_title'   => esc_html__( 'Title #1', 'dormatic' ),
						'list_content' => esc_html__( 'Item content. Click the edit button to change this text.', 'dormatic' ),
					),
					array(
						'list_title'   => esc_html__( 'Title #2', 'dormatic' ),
						'list_content' => esc_html__( 'Item content. Click the edit button to change this text.', 'dormatic' ),
					),
				),
			)
		);

		$this->end_controls_section();

		// Typography Section
		$this->start_controls_section(
			'typography_section',
			array(
				'label' => __( 'Typography Section', 'pruners' ),
				'tab'   =>  \Elementor\Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'     => 'tagline_typography',
				'label'    => __( 'Tagline', 'pruners' ),
				'selector' => '{{WRAPPER}} .sec-title span',
			)
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'     => 'heading_typography',
				'label'    => __( 'Heading', 'pruners' ),
				'selector' => '{{WRAPPER}} .sec-title h2,{{WRAPPER}} .testimonial-block-two .inner-box h2',
			)
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'     => 'subheading_typography',
				'label'    => __( 'Sub Heading', 'pruners' ),
				'selector' => '{{WRAPPER}}  p',
			)
		);

		$this->end_controls_section();

		// color_section
		$this->start_controls_section(
			'color_section',
			array(
				'label' => __( 'Color Section', 'elementor' ),
				'tab'   =>  \Elementor\Controls_Manager::TAB_STYLE,
			)
		);
		$this->start_controls_tabs( 'tabs_button_style' );
		$this->start_controls_tab(
			'tab_button_normal',
			array(
				'label' => __( 'Normal', 'elementor' ),
			)
		);
		$this->add_control(
			'button_text_color',
			array(
				'label'     => __( 'Button Text color', 'elementor' ),
				'separator' => 'before',
				'type'      =>  \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .testimonial-section .title-inner .text a' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'rating_color',
			array(
				'label'     => __( 'Rating Color', 'elementor' ),
				'separator' => 'before',
				'type'      =>  \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .testimonial-block-two .inner-box .author-box .rating li' => 'color: {{VALUE}}',
				),
			)
		);

		$this->end_controls_tab();
		$this->start_controls_tab(
			'tab_button_hover',
			array(
				'label' => __( 'Hover', 'elementor' ),
			)
		);

		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();

	}
	protected function render() {
		$settings            = $this->get_settings_for_display();
		$layout_style        = $settings['layout_style'];
		$tagline             = $settings['tagline'];
		$heading             = $settings['heading'];
		$heading_html = sprintf( '<%1$s %2$s>%3$s</%1$s>', Utils::validate_html_tag( $settings['header_size'] ), $this->get_render_attribute_string( 'heading' ), $heading );
		$sub_heading         = $settings['sub_heading'];
		$button_text         = $settings['button_text'];
		$button_url          = $settings['button_url']['url'];
		$button_url_external = $settings['button_url']['is_external'] ? 'target="_blank"' : '';
		$button_url_nofollow = $settings['button_url']['nofollow'] ? 'rel="nofollow"' : '';
		$background_shape    = ( $settings['background_shape']['id'] != '' ) ? wp_get_attachment_image_url( $settings['background_shape']['id'], 'full' ) : $settings['background_shape']['url'];
		?>
		<?php if ( $layout_style == 'style_1' ) { ?>
<section class="testimonial-section">
	<div class="large-container">
		<div class="row clearfix">
			<div class="col-lg-4 col-md-12 col-sm-12 title-column">
				<div class="title-inner">
					<div class="sec-title">
						<span><?php echo $tagline; ?></span>
						<?php echo $heading_html; ?>
					</div>
					<div class="text">
						<p><?php echo $sub_heading; ?></p>
						<?php if(!empty($button_text)){ ?>
						<a href="<?php echo esc_attr( $button_url ); ?>" <?php echo $button_url_external; ?>  <?php echo $button_url_nofollow; ?>><?php echo $button_text; ?></a>
						<?php } ?>
					</div>
				</div>
			</div>
			<div class="col-lg-8 col-md-12 col-sm-12 testimonial-column">
				<div class="testimonial-inner">
					<div class="two-column-carousel owl-carousel owl-theme owl-dots-none owl-nav-none">
							<?php
							$i = 1;
							foreach ( $settings['items'] as $item ) {
								$item_title         = $item['item_title'];
								$item_designation   = $item['item_designation'];
								$item_image         = ( $item['item_image']['id'] != '' ) ? wp_get_attachment_image( $item['item_image']['id'], 'full' ) : $item['item_image']['url'];
								$item_image_alt     = get_post_meta( $item['item_image']['id'], '_wp_attachment_image_alt', true );
								$item_text          = $item['item_text'];
								$item_select_rating = $item['item_select_rating'];
								?>
					  <div class="testimonial-block-one">
						<div class="inner-box">
							<div class="text">
							<figure class="icon-1"><img src="<?php echo DORMATIC_IMG_URL; ?>icons/icon-7.png" alt=""></figure>
							<figure class="icon-2"><img src="<?php echo DORMATIC_IMG_URL; ?>icons/icon-8.png" alt=""></figure>
							<p><?php echo $item_text; ?></p>
							</div>
							<div class="author-box">
							<figure class="image-box">
								<?php
								if ( wp_http_validate_url( $item_image ) ) {
									?>
							<img src="<?php echo esc_url( $item_image ); ?>" alt="<?php esc_attr( $item_image_alt ); ?>">
									<?php
								} else {
									echo $item_image;
								}
								?>
					</figure>
						<h4><?php echo $item_title; ?></h4>
						<span class="designation"><?php echo $item_designation; ?></span>
						<ul class="rating clearfix">
						<?php for ($x = 0; $x < $item_select_rating; $x++){ ?>
							<li class="full"><i class="fas fa-star"></i></li>
						<?php }
						for ($x = 0; $x < (5 - $item_select_rating); $x++){ ?>	
							<li class="null"><i class="fas fa-star"></i></li>
						<?php } ?>
							
						</ul>
						</div>
					</div>
					</div> 
					<?php $i++; } ?> 
					</div>
				</div>
			</div>
		</div>
	</div>
</section>
<?php } elseif ( $layout_style == 'style_2' ) { ?>
			<section class="testimonial-style-two centred">
				<div class="pattern-layer" style="background-image: url(<?php echo $background_shape; ?>);"></div>
				<div class="thumb-box">
				<?php
					$i = 1;
				foreach ( $settings['items'] as $item ) {
					$item_image     = ( $item['item_image']['id'] != '' ) ? wp_get_attachment_image( $item['item_image']['id'], 'full' ) : $item['item_image']['url'];
					$item_image_alt = get_post_meta( $item['item_image']['id'], '_wp_attachment_image_alt', true );
					?>
					<figure class="thumb thumb-<?php echo $i; ?>">								
						<?php
						if ( wp_http_validate_url( $item_image ) ) {
							?>
							<img src="<?php echo esc_url( $item_image ); ?>" alt="<?php esc_attr( $item_image_alt ); ?>">
								<?php
						} else {
							echo $item_image;
						}
						?>
					</figure>
					<?php $i++; } ?> 
					<div class="anim-icon icon-1"></div>
					<div class="anim-icon icon-2"></div>
					<div class="anim-icon icon-3"></div>
					<div class="anim-icon icon-4"></div>
					<div class="anim-icon icon-5"></div>
					<div class="anim-icon icon-6"></div>
				</div>
				<div class="auto-container">
					<div class="single-item-carousel owl-carousel owl-theme owl-nav-none dots-style-one">
					<?php
							$i = 1;
					foreach ( $settings['items'] as $item ) {
						$item_title         = $item['item_title'];
						$item_designation   = $item['item_designation'];
						$item_image         = ( $item['item_image']['id'] != '' ) ? wp_get_attachment_image( $item['item_image']['id'], 'full' ) : $item['item_image']['url'];
						$item_image_alt     = get_post_meta( $item['item_image']['id'], '_wp_attachment_image_alt', true );
						$review_title          = $item['review_title'];
						$item_text          = $item['item_text'];
						$item_select_rating = $item['item_select_rating'];
						?>
						<div class="testimonial-block-two">
							<div class="inner-box">
								<div class="icon-box">
									<i class="icon-quotes"></i>
									<figure class="quot-icon-1"><img src="<?php echo DORMATIC_IMG_URL; ?>icons/quote-2.png" alt=""></figure>
									<figure class="quot-icon-2"><img src="<?php echo DORMATIC_IMG_URL; ?>icons/quote-3.png" alt=""></figure>
								</div>
								<h2><?php echo $review_title;?></h2>
								<div class="text">
									<p><?php echo $item_text; ?></p>
								</div>
								<div class="author-box">
									<h4><?php echo $item_title; ?></h4>
									<span class="designation"><?php echo $item_designation; ?></span>
									<ul class="rating clearfix">
									<?php for ($x = 0; $x < $item_select_rating; $x++){ ?>
										<li class="full"><i class="fas fa-star"></i></li>
									<?php }
									for ($x = 0; $x < (5 - $item_select_rating); $x++){ ?>	
										<li class="null"><i class="fas fa-star"></i></li>
									<?php } ?>
									</ul>
								</div>
							</div>
						</div>
						<?php $i++; } ?> 
					</div>
				</div>
			</section>
						<?php
}
	}

	protected function content_template() {
	}
}
