<?php
namespace Dormatic\Helper\Elementor\Widgets;

use Elementor\Utils;
use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use Elementor\Plugin;
use \Elementor\Repeater;

class Dormatic_Service_Items extends Widget_Base {

	public function get_name() {
		return 'dormatic_service_items';
	}

	public function get_title() {
		return esc_html__( 'Dormatic Service Items', 'dormatic' );
	}

	public function get_icon() {
		return 'sds-widget-ico';
	}

	public function get_categories() {
		return array( 'Dormatic' );
	}

	protected function register_controls() {

		$this->start_controls_section(
			'general',
			array(
				'label' => esc_html__( 'general', 'dormatic' ),
			)
		);

		$this->add_control(
			'right_image',
			array(
				'label'   => esc_html__( 'Right Image', 'dormatic' ),
				'type'    => Controls_Manager::MEDIA,
				'default' => array(
					'url' => Utils::get_placeholder_image_src(),
				),

			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'item',
			array(
				'label' => esc_html__( 'item', 'dormatic' ),
			)
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'item_title',
			array(
				'label'   => esc_html__( 'Title', 'dormatic' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'Quality Services', 'dormatic' ),
			)
		);

		$repeater->add_control(
			'header_size',
			[
				'label' => esc_html__( 'HTML Tag', 'elementor' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'h1' => 'H1',
					'h2' => 'H2',
					'h3' => 'H3',
					'h4' => 'H4',
					'h5' => 'H5',
					'h6' => 'H6',
				],
				'default' => 'h2',
			]
		);

		$repeater->add_control(
			'item_content',
			array(
				'label'       => esc_html__( 'Content', 'dormatic' ),
				'type'        => Controls_Manager::TEXTAREA,
				'rows'        => 6,
				'default'     => __( 'Kaoreet efficitur aliquam volut consequat sed imperdiet', 'dormatic' ),
				'placeholder' => esc_html__( 'Type your description here', 'dormatic' ),

			)
		);

		$repeater->add_control(
			'item_image',
			array(
				'label'   => esc_html__( 'Image', 'dormatic' ),
				'type'    => Controls_Manager::MEDIA,
				'default' => array(
					'url' => Utils::get_placeholder_image_src(),
				),

			)
		);

		$this->add_control(
			'items',
			array(
				'label'   => esc_html__( 'Repeater List', 'dormatic' ),
				'type'    => Controls_Manager::REPEATER,
				'fields'  => $repeater->get_controls(),
				'default' => array(
					array(
						'list_title'   => esc_html__( 'Title #1', 'dormatic' ),
						'list_content' => esc_html__( 'Item content. Click the edit button to change this text.', 'dormatic' ),
					),
					array(
						'list_title'   => esc_html__( 'Title #2', 'dormatic' ),
						'list_content' => esc_html__( 'Item content. Click the edit button to change this text.', 'dormatic' ),
					),
				),
			)
		);

		$this->end_controls_section();

		// Typography Section

		$this->start_controls_section(
			'typography_section',
			array(
				'label' => __( 'Typography Section', 'elementor' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'     => 'title_typography',
				'label'    => __( 'Item Title', 'elementor' ),
				'selector' => '{{WRAPPER}} .service-details-content .two-column .inner-box .single-item h3',
			)
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'     => 'subtitle_typography',
				'label'    => __( 'Item Sub Title', 'elementor' ),
				'selector' => '{{WRAPPER}} .service-details-content .two-column .inner-box .single-item h3',
			)
		);
		$this->end_controls_section();

		// color_section

		$this->start_controls_section(
			'color_section',
			array(
				'label' => __( 'Color Section', 'elementor' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);
		$this->start_controls_tabs( 'tabs_button_style' );
		$this->start_controls_tab(
			'tab_button_normal',
			array(
				'label' => __( 'Normal', 'elementor' ),
			)
		);

		$this->add_control(
			'icon_bg_color',
			array(
				'label'     => __( ' Icon BG Color', 'elementor' ),
				'separator' => 'before',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}}.service-details-content .two-column .inner-box .single-item .icon-box .icon-shape' => 'background: {{VALUE}}',
					
				),
			)
		);

		$this->end_controls_tab();
		$this->start_controls_tab(
			'tab_button_hover',
			array(
				'label' => __( 'Hover', 'elementor' ),
			)
		);

		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();

	}
	protected function render() {
		$settings                = $this->get_settings_for_display();
		$right_image             = ( $settings['right_image']['id'] != '' ) ? wp_get_attachment_image( $settings['right_image']['id'], 'full' ) : $settings['right_image']['url'];
				$right_image_alt = get_post_meta( $settings['right_image']['id'], '_wp_attachment_image_alt', true );
		?> <div class="two-column">
	<figure class="image-box">
		<?php
		if ( wp_http_validate_url( $right_image ) ) {
			?>
							<img src="<?php echo esc_url( $right_image ); ?>" alt="<?php esc_url( $right_image_alt ); ?>">
			<?php
		} else {
			echo $right_image;
		}
		?>
					</figure>
	<div class="inner-box">
		<?php
				$i = 1;
		foreach ( $settings['items'] as $item ) {
			$item_title     = $item['item_title'];
			$heading_html = sprintf( '<%1$s %2$s>%3$s</%1$s>', Utils::validate_html_tag( $item['header_size'] ), $this->get_render_attribute_string( 'item_title' ), $item_title );
			$item_content   = $item['item_content'];
			$item_image     = ( $item['item_image']['id'] != '' ) ? wp_get_attachment_image( $item['item_image']['id'], 'full' ) : $item['item_image']['url'];
			$item_image_alt = get_post_meta( $item['item_image']['id'], '_wp_attachment_image_alt', true );
			?>
					  <div class="single-item">
  <figure class="icon-box">
			<?php
			if ( wp_http_validate_url( $item_image ) ) {
				?>
							<img src="<?php echo esc_url( $item_image ); ?>" alt="<?php esc_url( $item_image_alt ); ?>">
									<?php
			} else {
				echo $item_image;
			}
			?>
	<div class="icon-shape"></div>
  </figure>
  <?php echo $heading_html; ?>
  <p><?php echo $item_content; ?></p>
</div> <?php $i++; } ?> 
									
	</div>
</div> 
		<?php
	}

	protected function content_template() {
	}
}
