<?php
namespace Dormatic\Helper\Elementor\Widgets;

use Elementor\Utils;
use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use Elementor\Plugin;
use \Elementor\Repeater;

class Dormatic_Projects extends Widget_Base {

	public function get_name() {
		return 'dormatic_projects';
	}

	public function get_title() {
						return esc_html__( 'Dormatic Projects', 'dormatic' );
	}

	public function get_icon() {
		return 'sds-widget-ico';
	}

	public function get_categories() {
		return array( 'Dormatic' );
	}

	protected function register_controls() {

		$this->start_controls_section(
			'general',
			array(
				'label' => esc_html__( 'general', 'dormatic' ),
			)
		);
		$this->add_control(
			'layout_style',
			array(
				'label'   => esc_html__( 'Layout Style', 'dormatic-core' ),
				'type'    => Controls_Manager::SELECT,
				'options' => array(
					'style_1' => esc_html__( 'Style One', 'dormatic-core' ),
					'style_2' => esc_html__( 'Style Two', 'dormatic-core' ),
					'style_3' => esc_html__( 'Style Three', 'dormatic-core' ),
				),
				'default' => 'style_1',
			)
		);
		$this->add_control(
			'background_shape',
			array(
				'label'   => esc_html__( 'Background Shape', 'dormatic' ),
				'type'    => Controls_Manager::MEDIA,
				'default' => array(
					'url' => Utils::get_placeholder_image_src(),
				),

			)
		);

		$this->add_control(
			'tagline',
			array(
				'label'   => esc_html__( 'Tagline', 'dormatic' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'Garage Door installation & Repair', 'dormatic' ),
			)
		);

		$this->add_control(
			'heading',
			array(
				'label'   => esc_html__( 'Heading', 'dormatic' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'Our Projects Tailored To Client’s Needs', 'dormatic' ),
			)
		);

		$this->add_control(
			'header_size',
			[
				'label' => esc_html__( 'HTML Tag', 'elementor' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'h1' => 'H1',
					'h2' => 'H2',
					'h3' => 'H3',
					'h4' => 'H4',
					'h5' => 'H5',
					'h6' => 'H6',
				],
				'default' => 'h2',
			]
		);

		$this->add_control(
			'sub_heading',
			array(
				'label'       => esc_html__( 'Sub Heading', 'dormatic' ),
				'type'        => Controls_Manager::TEXTAREA,
				'rows'        => 6,
				'default'     => __( 'Aute irure dolor reprehenderit cepteur ocaecat cupidatate sed ipsum non proident int sunt indys sint sed ipsum culpa quis.', 'dormatic' ),
				'placeholder' => esc_html__( 'Type your description here', 'dormatic' ),

			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'item',
			array(
				'label' => esc_html__( 'item', 'dormatic' ),
			)
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'item_title',
			array(
				'label'   => esc_html__( 'Title', 'dormatic' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'Garage Door Installation', 'dormatic' ),
			)
		);

		$repeater->add_control(
			'item_category',
			array(
				'label'   => esc_html__( 'Category', 'dormatic' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'Residential Project', 'dormatic' ),
			)
		);

		$repeater->add_control(
			'item_image',
			array(
				'label'   => esc_html__( 'Image', 'dormatic' ),
				'type'    => Controls_Manager::MEDIA,
				'default' => array(
					'url' => Utils::get_placeholder_image_src(),
				),

			)
		);

		$repeater->add_control(
			'item_button_text',
			array(
				'label'   => esc_html__( 'Button Text', 'dormatic' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'View details', 'dormatic' ),
			)
		);

		$repeater->add_control(
			'item_project_url',
			array(
				'label'         => esc_html__( 'Project URL', 'dormatic' ),
				'type'          => Controls_Manager::URL,
				'placeholder'   => esc_html__( 'https://your-link.com', 'dormatic' ),
				'show_external' => true,
				'default'       => array(
					'url'         => '',
					'is_external' => true,
					'nofollow'    => true,
				),

			)
		);

		$this->add_control(
			'items',
			array(
				'label'   => esc_html__( 'Repeater List', 'dormatic' ),
				'type'    => Controls_Manager::REPEATER,
				'fields'  => $repeater->get_controls(),
				'default' => array(
					array(
						'list_title'   => esc_html__( 'Title #1', 'dormatic' ),
						'list_content' => esc_html__( 'Item content. Click the edit button to change this text.', 'dormatic' ),
					),
					array(
						'list_title'   => esc_html__( 'Title #2', 'dormatic' ),
						'list_content' => esc_html__( 'Item content. Click the edit button to change this text.', 'dormatic' ),
					),
				),
			)
		);

		$this->end_controls_section();

		// Typography Section
		$this->start_controls_section(
			'typography_section',
			array(
				'label' => __('Typography Section', 'pruners'),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'     => 'tagline_typography',
				'label'    => __('Tagline', 'pruners'),
				'selector' => '{{WRAPPER}} .sec-title span',
			)
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'     => 'heading_typography',
				'label'    => __('Heading', 'pruners'),
				'selector' => '{{WRAPPER}} .sec-title h2',
			)
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'     => 'subheading_typography',
				'label'    => __('Sub Heading', 'pruners'),
				'selector' => '{{WRAPPER}} .project-section .title-inner .text p,{{WRAPPER}} .project-style-two .upper-box .sec-title p',
			)
		);
		

		$this->end_controls_section();

		// color_section
		$this->start_controls_section(
			'color_section',
			array(
				'label' => __('Color Section', 'elementor'),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);
		$this->start_controls_tabs('tabs_button_style');
		$this->start_controls_tab(
			'tab_button_normal',
			array(
				'label' => __('Normal', 'elementor'),
			)
		);
		$this->add_control(
            'button_bg_color',
            array(
                'label'     => __('Button BG color', 'elementor'),
                'separator' => 'before',
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => array(
                    '{{WRAPPER}} .theme-btn-one  ' => 'background-color: {{VALUE}}',
                ),
            )
		);

		$this->add_control(
            'text_color',
            array(
                'label'     => __('Text Color', 'elementor'),
                'separator' => 'before',
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => array(
					'{{WRAPPER}} .project-block-one .inner-box .lower-content .inner .link a' => 'color: {{VALUE}}',
					'{{WRAPPER}} .project-style-two .sortable-masonry .filters .filter-tabs li' => 'color: {{VALUE}}',
                ),
            )
		);
		
		$this->end_controls_tab();
		$this->start_controls_tab(
			'tab_button_hover',
			array(
				'label' => __('Hover', 'elementor'),
			)
		);

	

		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();


	}
	protected function render() {
		$settings         = $this->get_settings_for_display();
		$layout_style     = $settings['layout_style'];
		$background_shape = ( $settings['background_shape']['id'] != '' ) ? wp_get_attachment_image_url( $settings['background_shape']['id'], 'full' ) : $settings['background_shape']['url'];

				$tagline     = $settings['tagline'];
				$heading     = $settings['heading'];
				$heading_html = sprintf( '<%1$s %2$s>%3$s</%1$s>', Utils::validate_html_tag( $settings['header_size'] ), $this->get_render_attribute_string( 'heading' ), $heading );
				$sub_heading = $settings['sub_heading'];
		?>
		<?php if ( $layout_style == 'style_1' ) { ?>
<section class="project-section bg-color-2">
	<div class="pattern-layer" style="background-image: url(<?php echo $background_shape; ?>);"></div>
	<div class="auto-container">
		<div class="title-inner clearfix">
			<div class="sec-title text-right">
				<span><?php echo $tagline; ?></span>
				<?php echo $heading_html; ?>
			</div>
			<div class="text">
				<p><?php echo $sub_heading; ?></p>
			</div>
		</div>
	</div>
	<div class="carousel-inner">
		<div class="project-carousel owl-carousel owl-theme owl-nav-none dots-style-one">
							 <?php
								$i = 1;
								foreach ( $settings['items'] as $item ) {
									$item_title                = $item['item_title'];
									$item_category             = $item['item_category'];
									$item_image                = ( $item['item_image']['id'] != '' ) ? wp_get_attachment_image( $item['item_image']['id'], 'full' ) : $item['item_image']['url'];
									$item_image_alt            = get_post_meta( $item['item_image']['id'], '_wp_attachment_image_alt', true );
									$item_button_text          = $item['item_button_text'];
									$item_project_url          = $item['item_project_url']['url'];
									$item_project_url_external = $item['item_project_url']['is_external'] ? 'target="_blank"' : '';
									$item_project_url_nofollow = $item['item_project_url']['nofollow'] ? 'rel="nofollow"' : '';
									?>
					  <div class="project-block-one">
						<div class="inner-box">
							<figure class="image-box">
									<?php
									if ( wp_http_validate_url( $item_image ) ) {
										?>
								<img src="<?php echo esc_url( $item_image ); ?>" alt="<?php esc_attr( $item_image_alt ); ?>">
										<?php
									} else {
										echo $item_image;
									}
									?>
							</figure>
							<div class="lower-content">
								<div class="inner">
									<div class="link"><a href="<?php echo esc_attr( $item_project_url ); ?>" <?php echo $item_project_url_external; ?>  <?php echo $item_project_url_nofollow; ?>><?php echo $item_title; ?></a></div>
									<h2><?php echo $item_category; ?></h2>
									<div class="btn-box"><a href="<?php echo esc_attr( $item_project_url ); ?>" <?php echo $item_project_url_external; ?>  <?php echo $item_project_url_nofollow; ?> class="theme-btn-one"><span class="btn-shape"></span><?php echo $item_button_text; ?></a></div>
								</div>
							</div>
						</div>
					</div> 
				<?php $i++; } ?> 					
		</div>
	</div>
</section>
	<?php } elseif ( $layout_style == 'style_2' ) { ?>
		<section class="project-style-two">
	<div class="auto-container">
		<div class="sortable-masonry">
			<div class="upper-box">
				<div class="sec-title">
					<span><?php echo $tagline; ?></span>
					<?php echo $heading_html; ?>
					<p><?php echo $sub_heading; ?></p>
				</div>
				<div class="filters">
				<?php
				$category_arr       = array();
				$category_arr_class = array();
				foreach ( $settings['items'] as $key => $item ) {
					$cat                        = $item['item_category'];
					$child_categories_ex        = explode( ',', $cat );
					$child_categories           = str_replace( ',', ' ', $cat );
					$category_arr_class[ $key ] = strtolower( $child_categories );
					foreach ( $child_categories_ex as $child_category ) {
						$category_arr[] = strtolower( $child_category );
					}
				}
				?>
					<ul class="filter-tabs filter-btns clearfix">
						<li class="active filter" data-role="button" data-filter=".all"><?php esc_html_e( 'All projects', 'domatic-core' ); ?></li>
						<?php
						$category_arr = array_unique( $category_arr );
						foreach ( $category_arr as $category ) {
							$category_slug = str_replace( ' ', '-', $category );
							echo '<li class="filter" data-role="button" data-filter=".' . $category_slug . '">' . $category . '</li>';
						}
						?>
					</ul>
				</div>
			</div>
			<div class="items-container row clearfix">

			<?php
			$i             = 1;
			$category_slug = array();
			foreach ( $settings['items'] as $item ) {
				$item_title                = $item['item_title'];
				$item_category             = $item['item_category'];
				$item_image                = ( $item['item_image']['id'] != '' ) ? wp_get_attachment_image( $item['item_image']['id'], 'full' ) : $item['item_image']['url'];
				$item_image_url            = ( $item['item_image']['id'] != '' ) ? wp_get_attachment_image_url( $item['item_image']['id'], 'full' ) : $item['item_image']['url'];
				$item_image_alt            = get_post_meta( $item['item_image']['id'], '_wp_attachment_image_alt', true );
				$item_button_text          = $item['item_button_text'];
				$item_project_url          = $item['item_project_url']['url'];
				$item_project_url_external = $item['item_project_url']['is_external'] ? 'target="_blank"' : '';
				$item_project_url_nofollow = $item['item_project_url']['nofollow'] ? 'rel="nofollow"' : '';

				$category_slug = strtolower( str_replace( ' ', '-', $item_category ) );

				?>
				<div class="col-lg-4 col-md-6 col-sm-12 masonry-item small-column all <?php echo esc_attr( $category_slug ); ?>">
					<div class="project-block-two">
						<div class="inner-box">
							<figure class="image-box">
							<?php
							if ( wp_http_validate_url( $item_image ) ) {
								?>
										<img src="<?php echo esc_url( $item_image ); ?>" alt="<?php esc_attr( $item_image_alt ); ?>">
								<?php
							} else {
								echo $item_image;
							}
							?>
							</figure>
							<div class="link">
								<a href="<?php echo $item_image_url; ?>" class="lightbox-image" data-fancybox="gallery"><i class="icon-search"></i></a>
							</div>
							<div class="text">
							<a href="<?php echo esc_attr( $item_project_url ); ?>" <?php echo $item_project_url_external; ?>  <?php echo $item_project_url_nofollow; ?>><?php echo $item_category; ?></a>
								<h3><?php echo $item_title; ?></h3>
							</div>
						</div>
					</div>
				</div>
					<?php $i++; } ?> 

			</div>
		</div>
	</div>
</section>
	<?php } elseif ( $layout_style == 'style_3' ) { ?>
<section class="project-style-three">
	<div class="container-fluid">
		<div class="inner-content clearfix">

		<?php
			$i = 1;
		foreach ( $settings['items'] as $item ) {
			$item_title                = $item['item_title'];
			$item_category             = $item['item_category'];
			$item_image                = ( $item['item_image']['id'] != '' ) ? wp_get_attachment_image( $item['item_image']['id'], 'full' ) : $item['item_image']['url'];
			$item_image_url            = ( $item['item_image']['id'] != '' ) ? wp_get_attachment_image_url( $item['item_image']['id'], 'full' ) : $item['item_image']['url'];
			$item_image_alt            = get_post_meta( $item['item_image']['id'], '_wp_attachment_image_alt', true );
			$item_button_text          = $item['item_button_text'];
			$item_project_url          = $item['item_project_url']['url'];
			$item_project_url_external = $item['item_project_url']['is_external'] ? 'target="_blank"' : '';
			$item_project_url_nofollow = $item['item_project_url']['nofollow'] ? 'rel="nofollow"' : '';

			if ( $i == 1 || $i == 2 ) {
				$class = 'big-column';
			} else {
				$class = 'small-column';
			}
			?>
						 
		<div class="<?php echo $class; ?> project-block">
			<div class="project-block-three">
				<div class="inner-box">
				<figure class="image-box">
						<?php
						if ( wp_http_validate_url( $item_image ) ) {
							?>
										<img src="<?php echo esc_url( $item_image ); ?>" alt="<?php esc_attr( $item_image_alt ); ?>">
							<?php
						} else {
							echo $item_image;
						}
						?>
								</figure>
				<div class="content-box">
					<div class="view-btn"><a href="<?php echo $item_image_url; ?>" class="lightbox-image" data-fancybox="gallery"><i class="fal fa-plus"></i></a></div>
					<div class="text">
					<h2><?php echo $item_title; ?></h2>
					<a href="<?php echo esc_attr( $item_project_url ); ?>" <?php echo $item_project_url_external; ?>  <?php echo $item_project_url_nofollow; ?>><?php echo $item_category; ?></a>
					</div>
				</div>
				</div>
			</div>
		</div>
<?php $i++; } ?> 
	
		</div>
	</div>
</section>
			<?php
	}
	}

	protected function content_template() {
	}
}
