<?php
namespace Dormatic\Helper\Elementor\Widgets;

use Elementor\Utils;
use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use Elementor\Plugin;
use \Elementor\Repeater;

class Dormatic_Newslatter_Form extends Widget_Base {

	public function get_name() {
		return 'dormatic_newslatter_form';
	}

	public function get_title() {
		return esc_html__( 'Dormatic Newslatter Form', 'dormatic' );
	}

	public function get_icon() {
		return 'sds-widget-ico';
	}

	public function get_categories() {
		return array( 'Dormatic' );
	}

	protected function register_controls() {

		$this->start_controls_section(
			'general',
			array(
				'label' => esc_html__( 'general', 'dormatic' ),
			)
		);
		$this->add_control(
			'title',
			array(
				'label'   => esc_html__( 'Title', 'dormatic' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'Subscribe To Newsletter', 'dormatic' ),
			)
		);

		$this->add_control(
			'header_size',
			[
				'label' => esc_html__( 'HTML Tag', 'elementor' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'h1' => 'H1',
					'h2' => 'H2',
					'h3' => 'H3',
					'h4' => 'H4',
					'h5' => 'H5',
					'h6' => 'H6',
				],
				'default' => 'h2',
			]
		);
		$this->add_control(
			'form_shortcode',
			array(
				'label'       => esc_html__( 'Form Shortcode', 'dormatic' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
			)
		);

		$this->end_controls_section();

	}
	protected function render() {
		$settings       = $this->get_settings_for_display();
		$title          = $settings['title'];
		$heading_html = sprintf( '<%1$s %2$s>%3$s</%1$s>', Utils::validate_html_tag( $settings['header_size'] ), $this->get_render_attribute_string( 'title' ), $title );
		$form_shortcode = $settings['form_shortcode'];
		?> 
		<div class="subscribe-inner clearfix">
			<div class="widget-title pull-left"><?php echo $heading_html; ?></div>
			<div class="form-inner pull-right">
				<div class="subscribe-form clearfix">
				<?php echo $form_shortcode; ?>
				</div>
			</div>
		</div>
		<?php
	}

	protected function content_template() {
	}
}
