<?php
namespace Dormatic\Helper\Elementor\Widgets;

use Elementor\Utils;
use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use Elementor\Plugin;
use \Elementor\Repeater;

class Dormatic_Feature extends Widget_Base {

	public function get_name() {
		return 'dormatic_feature';
	}

	public function get_title() {
		return esc_html__( 'Dormatic Feature', 'dormatic' );
	}

	public function get_icon() {
		return 'sds-widget-ico';
	}

	public function get_categories() {
		return array( 'Dormatic' );
	}

	protected function register_controls() {

		$this->start_controls_section(
			'item',
			array(
				'label' => esc_html__( 'item', 'dormatic' ),
			)
		);
		$this->add_control(
			'layout_style',
			array(
				'label'   => esc_html__( 'Layout Style', 'dormatic-core' ),
				'type'    => Controls_Manager::SELECT,
				'options' => array(
					'style_1' => esc_html__( 'Style One', 'dormatic-core' ),
					'style_2' => esc_html__( 'Style Two', 'dormatic-core' ),
					'style_3' => esc_html__( 'Style Three', 'dormatic-core' ),
				),
				'default' => 'style_1',
			)
		);
		$this->add_control(
			'layout_type',
			array(
				'label'      => esc_html__( 'Layout Type', 'dormatic-core' ),
				'type'       => Controls_Manager::SELECT,
				'options'    => array(
					'grid'   => esc_html__( 'Grid', 'dormatic-core' ),
					'slider' => esc_html__( 'Slider', 'dormatic-core' ),
				),
				'default'    => 'grid',
				'conditions' => array(
					'relation' => 'and',
					'terms'    => array(
						array(
							'name'     => 'layout_style',
							'operator' => '!==',
							'value'    => 'style_3',
						),
					),
				),
			)
		);
		$this->add_control(
			'extra_class',
			array(
				'label' => esc_html__( 'Extra Class', 'dormatic-core' ),
				'type'  => Controls_Manager::TEXT,
			)
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'item_title',
			array(
				'label'   => esc_html__( 'Title', 'dormatic' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'Urgent 24/7 Garage Door Repair Services', 'dormatic' ),
			)
		);

		$repeater->add_control(
			'header_size',
			[
				'label' => esc_html__( 'HTML Tag', 'elementor' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'h1' => 'H1',
					'h2' => 'H2',
					'h3' => 'H3',
					'h4' => 'H4',
					'h5' => 'H5',
					'h6' => 'H6',
				],
				'default' => 'h3',
			]
		);

		$repeater->add_control(
			'item_icon',
			array(
				'label' => esc_html__( 'Icon', 'dormatic' ),
				'type'  => Controls_Manager::ICONS,
			)
		);

		$repeater->add_control(
			'item_content',
			array(
				'label'       => esc_html__( 'Content', 'dormatic' ),
				'type'        => Controls_Manager::TEXTAREA,
				'rows'        => 6,
				'default'     => __( 'Nunc quam ar pretium quis lobortis sequat consetetur diam nuc bibend ipsum dolor sit amet consecty.', 'dormatic' ),
				'placeholder' => esc_html__( 'Type your description here', 'dormatic' ),

			)
		);

		$repeater->add_control(
			'item_button_text',
			array(
				'label'   => esc_html__( 'Button Text', 'dormatic' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'Read More', 'dormatic' ),
			)
		);

		$repeater->add_control(
			'item_button_url',
			array(
				'label'         => esc_html__( 'Button URL', 'dormatic' ),
				'type'          => Controls_Manager::URL,
				'placeholder'   => esc_html__( 'https://your-link.com', 'dormatic' ),
				'show_external' => true,
				'default'       => array(
					'url'         => '',
					'is_external' => true,
					'nofollow'    => true,
				),

			)
		);

		$repeater->add_control(
			'item_image',
			array(
				'label'   => esc_html__( 'Image', 'dormatic' ),
				'type'    => Controls_Manager::MEDIA,
				'default' => array(
					'url' => Utils::get_placeholder_image_src(),
				),

			)
		);

		$this->add_control(
			'items',
			array(
				'label'   => esc_html__( 'Repeater List', 'dormatic' ),
				'type'    => Controls_Manager::REPEATER,
				'fields'  => $repeater->get_controls(),
				'default' => array(
					array(
						'list_title'   => esc_html__( 'Title #1', 'dormatic' ),
						'list_content' => esc_html__( 'Item content. Click the edit button to change this text.', 'dormatic' ),
					),
					array(
						'list_title'   => esc_html__( 'Title #2', 'dormatic' ),
						'list_content' => esc_html__( 'Item content. Click the edit button to change this text.', 'dormatic' ),
					),
				),
			)
		);

		$this->end_controls_section();

		// Typography Section

		$this->start_controls_section(
			'typography_section',
			array(
				'label' => __( 'Typography Section', 'elementor' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'     => 'title_typography',
				'label'    => __( 'Title', 'elementor' ),
				'selector' => '{{WRAPPER}} .feature-block-one .inner-box h3,{{WRAPPER}} .feature-block-two .inner-box h3,{{WRAPPER}} .feature-block-three .inner-box h3',
			)
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'     => 'text-content',
				'label'    => __( 'Text Content', 'elementor' ),
				'selector' => '{{WRAPPER}} p,{{WRAPPER}} .feature-block-two .inner-box .overlay-content p',
			)
		);

		$this->end_controls_section();

		// color_section

		$this->start_controls_section(
			'color_section',
			array(
				'label' => __( 'Color Section', 'elementor' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);
		$this->start_controls_tabs( 'tabs_button_style' );
		$this->start_controls_tab(
			'tab_button_normal',
			array(
				'label' => __( 'Normal', 'elementor' ),
			)
		);
		$this->add_control(
			'icon_color',
			array(
				'label'     => __( 'Icon Color', 'elementor' ),
				'separator' => 'before',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .feature-block-one .inner-box .icon-box .icon ' => 'color: {{VALUE}}',
					'{{WRAPPER}} .feature-block-two .inner-box .overlay-content .icon-box ' => 'color: {{VALUE}}',
					'{{WRAPPER}} .feature-block-three .inner-box .icon-box ' => 'color: {{VALUE}}',

				),
			)
		);

		$this->add_control(
			'icon_bg_color',
			array(
				'label'     => __( 'Icon BG Color', 'elementor' ),
				'separator' => 'before',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .feature-block-one .inner-box .icon-box .icon ' => 'background: {{VALUE}}',
					'{{WRAPPER}} .feature-block-two .inner-box .overlay-content .icon-box ' => 'background: {{VALUE}}',
					'{{WRAPPER}} .feature-block-three .inner-box .icon-box ' => 'background: {{VALUE}}',
				),
			)
		);

		$this->end_controls_tab();
		$this->start_controls_tab(
			'tab_button_hover',
			array(
				'label' => __( 'Hover', 'elementor' ),
			)
		);

		$this->add_control(
			'icon_hover_color',
			array(
				'label'     => __( 'Icon Hover Color', 'elementor' ),
				'separator' => 'before',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .feature-block-one .inner-box .icon-box .icon:before ' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .feature-block-three .inner-box .icon-box:hover' => 'background-color: {{VALUE}}',
				),
			)
		);

		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();

	}
	protected function render() {
		$settings     = $this->get_settings_for_display();
		$layout_style = $settings['layout_style'];
		$extra_class  = $settings['extra_class'];
		?> 
		<?php
		if ( $layout_style == 'style_1' ) {
			$layout_type = $settings['layout_type'];
			?>
			<?php if ( $layout_type == 'grid' ) { ?>
			<section class="feature-section <?php echo $extra_class; ?>">
				<div class="auto-container">
					<div class="row clearfix">
						<?php
						$i = 1;
						foreach ( $settings['items'] as $item ) {
							$item_title               = $item['item_title'];
							$heading_html = sprintf( '<%1$s %2$s>%3$s</%1$s>', Utils::validate_html_tag( $item['header_size'] ), $this->get_render_attribute_string( 'item_title' ), $item_title );
							$item_icon                = $item['item_icon'];
							$item_content             = $item['item_content'];
							$item_button_text         = $item['item_button_text'];
							$item_button_url          = $item['item_button_url']['url'];
							$item_button_url_external = $item['item_button_url']['is_external'] ? 'target="_blank"' : '';
							$item_button_url_nofollow = $item['item_button_url']['nofollow'] ? 'rel="nofollow"' : '';
							?>
										
						<div class="col-lg-4 col-md-6 col-sm-12 feature-block">
							<div class="feature-block-one">
								<div class="inner-box">
								<div class="icon-box">
									<div class="icon"><?php \Elementor\Icons_Manager::render_icon( ( $item_icon ), array( 'aria-hidden' => 'true' ) ); ?></div>
								</div>
								<?php echo $heading_html; ?>
								<p><?php echo $item_content; ?></p>
								<?php if ( $item_button_url && $item_title ) { ?>
								<div class="link"><a href="<?php echo esc_attr( $item_button_url ); ?>" <?php echo $item_button_url_external; ?>  <?php echo $item_button_url_nofollow; ?>><?php echo $item_button_text; ?></a></div>
								<?php } ?>
								</div>
							</div>
						</div>
				<?php $i++; } ?>                 
					</div>
				</div>
			</section> 
			<?php } elseif ( $layout_type == 'slider' ) { ?>
				<section class="feature-section <?php echo $extra_class; ?>">
				<div class="auto-container">
					<div class="three-item-carousel owl-carousel owl-theme owl-dots-none owl-nav-none">
						<?php
						$i = 1;
						foreach ( $settings['items'] as $item ) {
							$item_title               = $item['item_title'];
$heading_html = sprintf( '<%1$s %2$s>%3$s</%1$s>', Utils::validate_html_tag( $item['header_size'] ), $this->get_render_attribute_string( 'item_title' ), $item_title );
							$item_icon                = $item['item_icon'];
							$item_content             = $item['item_content'];
							$item_button_text         = $item['item_button_text'];
							$item_button_url          = $item['item_button_url']['url'];
							$item_button_url_external = $item['item_button_url']['is_external'] ? 'target="_blank"' : '';
							$item_button_url_nofollow = $item['item_button_url']['nofollow'] ? 'rel="nofollow"' : '';
							?>
							<div class="feature-block-one">
								<div class="inner-box">
								<div class="icon-box">
									<div class="icon"><?php \Elementor\Icons_Manager::render_icon( ( $item_icon ), array( 'aria-hidden' => 'true' ) ); ?></div>
								</div>
								<?php echo $heading_html; ?>
								<p><?php echo $item_content; ?></p>
								<?php if ( $item_button_url && $item_title ) { ?>
								<div class="link"><a href="<?php echo esc_attr( $item_button_url ); ?>" <?php echo $item_button_url_external; ?>  <?php echo $item_button_url_nofollow; ?>><?php echo $item_button_text; ?></a></div><?php } ?>
								</div>
							</div>
				<?php $i++; } ?>                 
					</div>
				</div>
			</section> 
			<?php } ?>
			<?php
		} elseif ( $layout_style == 'style_2' ) {
			$layout_type = $settings['layout_type'];
			?>
			<?php if ( $layout_type == 'grid' ) { ?>
				<section class="feature-style-two centred <?php echo $extra_class; ?>">
					<div class="auto-container">
						<div class="inner-container clearfix">
						<?php
						$i = 1;
						foreach ( $settings['items'] as $item ) {
							$item_title               = $item['item_title'];
$heading_html = sprintf( '<%1$s %2$s>%3$s</%1$s>', Utils::validate_html_tag( $item['header_size'] ), $this->get_render_attribute_string( 'item_title' ), $item_title );
							$item_icon                = $item['item_icon'];
							$item_content             = $item['item_content'];
							$item_button_text         = $item['item_button_text'];
							$item_button_url          = $item['item_button_url']['url'];
							$item_button_url_external = $item['item_button_url']['is_external'] ? 'target="_blank"' : '';
							$item_button_url_nofollow = $item['item_button_url']['nofollow'] ? 'rel="nofollow"' : '';
							$item_image               = ( $item['item_image']['id'] != '' ) ? wp_get_attachment_image_url( $item['item_image']['id'], 'full' ) : $item['item_image']['url'];
							?>
						<div class="feature-block-two">
							<div class="inner-box" style="background-image: url(<?php echo $item_image; ?>);">
								<div class="text">
								<?php echo $heading_html; ?>
								<div class="link"><a href="index-2.html"><i class="far fa-angle-right"></i></a></div>
								</div>
								<div class="overlay-content" style="background-image: url(<?php echo $item_image; ?>);">
								<div class="icon-box"><?php \Elementor\Icons_Manager::render_icon( ( $item_icon ), array( 'aria-hidden' => 'true' ) ); ?></div>
								<?php echo $heading_html; ?>
								<p><?php echo $item_content; ?></p>
								<?php if ( $item_button_url && $item_title ) { ?>
								<div class="link"><a href="<?php echo esc_attr( $item_button_url ); ?>" <?php echo $item_button_url_external; ?>  <?php echo $item_button_url_nofollow; ?>><i class="far fa-angle-right"></i></a></div><?php } ?>
								</div>
							</div>
						</div> 
						<?php $i++; } ?> 
						</div>
					</div>
				</section>
				<?php } elseif ( $layout_type == 'slider' ) { ?>
				<section class="feature-style-two centred <?php echo $extra_class; ?>">
					<div class="auto-container">
						<div class="three-item-carousel owl-carousel owl-theme owl-dots-none owl-nav-none">
						<?php
						$i = 1;
						foreach ( $settings['items'] as $item ) {
							$item_title               = $item['item_title'];
$heading_html = sprintf( '<%1$s %2$s>%3$s</%1$s>', Utils::validate_html_tag( $item['header_size'] ), $this->get_render_attribute_string( 'item_title' ), $item_title );
							$item_icon                = $item['item_icon'];
							$item_content             = $item['item_content'];
							$item_button_text         = $item['item_button_text'];
							$item_button_url          = $item['item_button_url']['url'];
							$item_button_url_external = $item['item_button_url']['is_external'] ? 'target="_blank"' : '';
							$item_button_url_nofollow = $item['item_button_url']['nofollow'] ? 'rel="nofollow"' : '';
							$item_image               = ( $item['item_image']['id'] != '' ) ? wp_get_attachment_image_url( $item['item_image']['id'], 'full' ) : $item['item_image']['url'];
							?>
							<div class="feature-block-two">
								<div class="inner-box" style="background-image: url(<?php echo $item_image; ?>);">
									<div class="text">
									<?php echo $heading_html; ?>
									<div class="link"><a href="index-2.html"><i class="far fa-angle-right"></i></a></div>
									</div>
									<div class="overlay-content" style="background-image: url(<?php echo $item_image; ?>);">
									<div class="icon-box"><?php \Elementor\Icons_Manager::render_icon( ( $item_icon ), array( 'aria-hidden' => 'true' ) ); ?></div>
									<?php echo $heading_html; ?>
									<p><?php echo $item_content; ?></p>
								<?php if ( $item_button_url && $item_title ) { ?>
								<div class="link"><a href="<?php echo esc_attr( $item_button_url ); ?>" <?php echo $item_button_url_external; ?>  <?php echo $item_button_url_nofollow; ?>><i class="far fa-angle-right"></i></a></div> <?php } ?>
									</div>
								</div>
							</div> 
						<?php $i++; } ?> 
						</div>
					</div>
				</section>
				<?php } ?>
				<?php } elseif ( $layout_style == 'style_3' ) { ?>
					<section class="feature-style-three">
						<div class="outer-container">
							<div class="inner-content clearfix">
							<?php
									$i = 1;
							foreach ( $settings['items'] as $item ) {
								$item_title               = $item['item_title'];
								$heading_html = sprintf( '<%1$s %2$s>%3$s</%1$s>', Utils::validate_html_tag( $item['header_size'] ), $this->get_render_attribute_string( 'item_title' ), $item_title );
								$item_icon                = $item['item_icon'];
								$item_content             = $item['item_content'];
								$item_button_text         = $item['item_button_text'];
								$item_button_url          = $item['item_button_url']['url'];
								$item_button_url_external = $item['item_button_url']['is_external'] ? 'target="_blank"' : '';
								$item_button_url_nofollow = $item['item_button_url']['nofollow'] ? 'rel="nofollow"' : '';
								?>
								<div class="feature-block-three">
									<div class="inner-box">
										<div class="icon-box"><?php \Elementor\Icons_Manager::render_icon( ( $item_icon ), array( 'aria-hidden' => 'true' ) ); ?></div>
										<?php echo $heading_html; ?>
										<p><?php echo $item_content; ?></p>
										<?php if ( $item_button_url && $item_title ) { ?>
										<a href="<?php echo esc_attr( $item_button_url ); ?>" <?php echo $item_button_url_external; ?>  <?php echo $item_button_url_nofollow; ?>><?php echo $item_title; ?></a>
										<?php } ?>
									</div>
								</div>
								<?php $i++; } ?> 
							</div>
						</div>
					</section>
			<?php
				}
	}

	protected function content_template() {
	}
}


