<?php
namespace Dormatic\Helper\Elementor\Widgets;

use Elementor\Utils;
use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use Elementor\Plugin;
use \Elementor\Repeater;

class Dormatic_About_Two extends Widget_Base {


	public function get_name() {
		return 'dormatic_about_two';
	}

	public function get_title() {
		return esc_html__( 'Dormatic About Two', 'dormatic-core' );
	}

	public function get_icon() {
		return 'sds-widget-ico';
	}

	public function get_categories() {
		return array( 'Dormatic' );
	}

	protected function register_controls() {

		$this->start_controls_section(
			'general',
			array(
				'label' => esc_html__( 'general', 'dormatic-core' ),
			)
		);

		$this->add_control(
			'left_image',
			array(
				'label'   => esc_html__( 'Left Image', 'dormatic-core' ),
				'type'    => Controls_Manager::MEDIA,
				'default' => array(
					'url' => Utils::get_placeholder_image_src(),
				),

			)
		);

		$this->add_control(
			'caption_01_icon',
			array(
				'label'     => esc_html__( 'Caption 01 Icon', 'dormatic-core' ),
				'type'      => Controls_Manager::ICONS,
				'separator' => 'before',
			)
		);

		$this->add_control(
			'caption_01_number',
			array(
				'label'   => esc_html__( 'Caption 01 Number', 'dormatic-core' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( '1.9k', 'dormatic-core' ),
			)
		);

		$this->add_control(
			'caption_01_title',
			array(
				'label'     => esc_html__( 'Caption 01 Title', 'dormatic-core' ),
				'type'      => Controls_Manager::TEXT,
				'default'   => __( 'Projects Completed', 'dormatic-core' ),
				'separator' => 'before',
			)
		);

		$this->add_control(
			'caption_02_icon',
			array(
				'label' => esc_html__( 'Caption 02 Icon', 'dormatic-core' ),
				'type'  => Controls_Manager::ICONS,
			)
		);

		$this->add_control(
			'caption_02_number',
			array(
				'label'   => esc_html__( 'Caption 02 Number', 'dormatic-core' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( '50+', 'dormatic-core' ),
			)
		);

		$this->add_control(
			'caption_02_title',
			array(
				'label'     => esc_html__( 'Caption 02 Title', 'dormatic-core' ),
				'type'      => Controls_Manager::TEXT,
				'default'   => __( 'Service Locations', 'dormatic-core' ),
				'separator' => 'before',
			)
		);

		$this->add_control(
			'certified_icon',
			array(
				'label' => esc_html__( 'Certified Icon', 'dormatic-core' ),
				'type'  => Controls_Manager::ICONS,
			)
		);

		$this->add_control(
			'certified_rating',
			array(
				'label'       => esc_html__( 'Certified Rating', 'dormatic-core' ),
				'type'        => Controls_Manager::TEXTAREA,
				'rows'        => 6,
				'placeholder' => esc_html__( 'Type your description here', 'dormatic-core' ),

			)
		);

		$this->add_control(
			'certified_title',
			array(
				'label'   => esc_html__( 'Certified Title', 'dormatic-core' ),
				'type'    => Controls_Manager::TEXTAREA,
				'rows'    => 0,
				'default' => __( 'Best Garage Door Company Award', 'dormatic-core' ),
			)
		);

		$this->add_control(
			'certified_number',
			array(
				'label'     => esc_html__( 'Certified Number', 'dormatic-core' ),
				'type'      => Controls_Manager::TEXT,
				'default'   => __( 'ISO 2022:99 Certified', 'dormatic-core' ),
				'separator' => 'before',
			)
		);

		$this->add_control(
			'sub_title',
			array(
				'label'   => esc_html__( 'Sub Title', 'dormatic-core' ),
				'type'    => Controls_Manager::TEXTAREA,
				'rows'    => 0,
				'default' => __( 'Garage Door installation & Repair', 'dormatic-core' ),
			)
		);

		$this->add_control(
			'title',
			array(
				'label'   => esc_html__( 'Title', 'dormatic-core' ),
				'type'    => Controls_Manager::TEXTAREA,
				'rows'    => 0,
				'default' => __( 'From Small Touch-Ups To Full Day Jobs - We Fix!', 'dormatic-core' ),
			)
		);		

		$this->add_control(
			'header_size',
			[
				'label' => esc_html__( 'HTML Tag', 'elementor' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'h1' => 'H1',
					'h2' => 'H2',
					'h3' => 'H3',
					'h4' => 'H4',
					'h5' => 'H5',
					'h6' => 'H6',
				],
				'default' => 'h2',
			]
		);

		$this->add_control(
			'description',
			array(
				'label'       => esc_html__( 'Description', 'dormatic-core' ),
				'type'        => Controls_Manager::TEXTAREA,
				'rows'        => 6,
				'default'     => __( 'Nunc quam arcu pretium quis quam sed, laoreet efficitur liquam volutpa sem consequat consequat imperdiet. In nulla sed viverraut loremut etur bibendum imperdiets ipsum lorem ipsum dolor sit amet.', 'dormatic-core' ),
				'placeholder' => esc_html__( 'Type your description here', 'dormatic-core' ),

			)
		);

		$this->add_control(
			'list_content',
			array(
				'label'       => esc_html__( 'List Content', 'dormatic-core' ),
				'type'        => Controls_Manager::TEXTAREA,
				'rows'        => 6,
				'placeholder' => esc_html__( 'Type your description here', 'dormatic-core' ),

			)
		);

		$this->add_control(
			'button_text',
			array(
				'label'   => esc_html__( 'Button Text', 'dormatic-core' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'Read More', 'dormatic-core' ),
			)
		);

		$this->add_control(
			'button_link',
			array(
				'label'         => esc_html__( 'Button Link', 'dormatic-core' ),
				'type'          => Controls_Manager::URL,
				'placeholder'   => esc_html__( 'https://your-link.com', 'dormatic-core' ),
				'show_external' => true,
				'default'       => array(
					'url'         => '',
					'is_external' => false,
					'nofollow'    => false,
				),

			)
		);

		$this->end_controls_section();

		// Typography Section
		
        $this->start_controls_section(
            'typography_section',
            array(
                'label' => __('Typography Section', 'elementor'),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            )
        );

		$this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            array(
                'name'     => 'tagline_typography',
                'label'    => __('Tagline', 'elementor'),
                'selector' => '{{WRAPPER}} .sec-title span',
            )
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            array(
                'name'     => 'heading_typography',
                'label'    => __('Heading', 'prunelementorers'),
                'selector' => '{{WRAPPER}} .sec-title h2',
            )
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            array(
                'name'     => 'short_desc_typography',
                'label'    => __('Short Description', 'elementor'),
                'selector' => '{{WRAPPER}} .content_block_5 .content-box .text p',
            )
        );
        $this->end_controls_section();

        // color_section
        $this->start_controls_section(
            'color_section',
            array(
                'label' => __('Color Section', 'elementor'),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            )
        );
        $this->start_controls_tabs('tabs_button_style');
        $this->start_controls_tab(
            'tab_button_normal',
            array(
                'label' => __('Normal', 'elementor'),
            )
		);
		
		$this->add_control(
			'icon1_color',
			array(
				'label'     => __( 'Icon1 & Icon2 Color', 'elementor' ),
				'separator' => 'before',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .image_block_2 .image-box .single-box h2 i' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'icon3_color',
			array(
				'label'     => __( 'Icon3 Color', 'elementor' ),
				'separator' => 'before',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .image_block_2 .image-box .content-three .icon-box i.icon' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'bottom_text_bg_color',
			array(
				'label'     => __( 'Bottom Text BG Color', 'elementor' ),
				'separator' => 'before',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .image_block_2 .image-box .content-three .text' => 'background-color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
            'button_text_color',
            array(
                'label'     => __('Button Text Color', 'elementor'),
                'separator' => 'before',
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => array(
                    '{{WRAPPER}} .content_block_5 .content-box .btn-box a' => 'color: {{VALUE}}',
                ),
            )
		);
		
		$this->add_control(
			'button_bg_color',
			array(
				'label'     => __( 'Button BG Color', 'elementor' ),
				'separator' => 'before',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .content_block_5 .content-box .btn-box a' => 'background-color: {{VALUE}}',
				),
			)
		);

		
        $this->end_controls_tab();
        $this->start_controls_tab(
            'tab_button_hover',
            array(
                'label' => __('Hover', 'elementor'),
            )
		);
		$this->add_control(
			'button_text_hover_color',
			array(
				'label'     => __( 'Button Hover Text Color', 'elementor' ),
				'separator' => 'before',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .content_block_5 .content-box:hover .btn-box a' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'button_hover_bg_color',
			array(
				'label'     => __( 'Button Hover BG Color', 'elementor' ),
				'separator' => 'before',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .content_block_5 .content-box:hover .btn-box a' => 'background-color: {{VALUE}}',
				),
			)
		);

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();


	}
	protected function render() {
		$settings             = $this->get_settings_for_display();
		$left_image           = ( $settings['left_image']['id'] != '' ) ? wp_get_attachment_image( $settings['left_image']['id'], 'full' ) : $settings['left_image']['url'];
		$left_image_alt       = get_post_meta( $settings['left_image']['id'], '_wp_attachment_image_alt', true );
		$caption_01_icon      = $settings['caption_01_icon'];
		$caption_01_number    = $settings['caption_01_number'];
		$caption_01_title     = $settings['caption_01_title'];
		$caption_02_icon      = $settings['caption_02_icon'];
		$caption_02_number    = $settings['caption_02_number'];
		$caption_02_title     = $settings['caption_02_title'];
		$certified_icon       = $settings['certified_icon'];
		$certified_rating     = $settings['certified_rating'];
		$certified_title      = $settings['certified_title'];
		$certified_number     = $settings['certified_number'];
		$sub_title            = $settings['sub_title'];
		$title                = $settings['title'];
		$title_html = sprintf( '<%1$s %2$s>%3$s</%1$s>', Utils::validate_html_tag( $settings['header_size'] ), $this->get_render_attribute_string( 'title' ), $title );
		$description          = $settings['description'];
		$list_content         = $settings['list_content'];
		$button_text          = $settings['button_text'];
		$button_link          = $settings['button_link']['url'];
		$button_link_external = $settings['button_link']['is_external'] ? 'target="_blank"' : '';
		$button_link_nofollow = $settings['button_link']['nofollow'] ? 'rel="nofollow"' : '';
		$bottom_text          = $settings['bottom_text'];
		?>
		<!-- about-style-two -->
		<section class="about-style-two">
			<div class="auto-container">
				<div class="row align-items-center clearfix">
					<div class="col-lg-6 col-md-12 col-sm-12 image-column">
						<div class="image_block_2">
							<div class="image-box">
								<figure class="image">
									<?php
									if ( wp_http_validate_url( $left_image ) ) {
										?>
										<img src="<?php echo esc_url( $left_image ); ?>" alt="<?php esc_url( $left_image_alt ); ?>">
										<?php
									} else {
										echo $left_image;
									}
									?>
								</figure>
								<div class="single-box content-one">
									<h2><?php \Elementor\Icons_Manager::render_icon( ( $caption_01_icon ), array( 'aria-hidden' => 'true' ) ); ?><?php echo $caption_01_number; ?></h2>
									<p><?php echo $caption_01_title; ?></p>
								</div>
								<div class="single-box content-two">
									<h2><?php \Elementor\Icons_Manager::render_icon( ( $caption_02_icon ), array( 'aria-hidden' => 'true' ) ); ?><?php echo $caption_02_number; ?></h2>
									<p><?php echo $caption_02_title; ?></p>
								</div>
								<div class="content-three">
									<div class="icon-box">
										<i class="icon <?php echo $certified_icon['value']; ?>"></i>
										<ul class="rating clearfix">
											<?php echo $certified_rating; ?>
										</ul>
									</div>
									<div class="text">
										<h3><?php echo $certified_title; ?></h3>
										<span><?php echo $certified_number; ?></span>
									</div>
								</div>
							</div>
						</div>
					</div>
					<div class="col-lg-6 col-md-12 col-sm-12 content-column">
						<div class="content_block_5">
							<div class="content-box">
								<div class="sec-title">
									<span><?php echo $sub_title; ?></span>
									<?php echo $title_html; ?>
								</div>
								<div class="text">
									<p><?php echo $description; ?></p>
									<ul class="list clearfix">
										<?php echo $list_content; ?>
									</ul>
								</div>
								<div class="btn-box">
									<a href="<?php echo esc_url( $button_link ); ?>" <?php echo $button_link_external; ?> <?php echo $button_link_nofollow; ?>><?php echo $button_text; ?></a>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</section>
		<!-- about-style-two end -->
		<?php
	}

	protected function content_template() {
	}
}
