(function($) {

    "use strict";

    var addons_js = function() {

        if ($('.two-column-carousel').length) {
            $('.two-column-carousel').owlCarousel({
                loop: true,
                margin: 90,
                nav: true,
                smartSpeed: 1000,
                autoplay: 500,
                navText: ['<span class="fas fa-algle-left"></span>', '<span class="fas fa-algle-left-right"></span>'],
                responsive: {
                    0: {
                        items: 1
                    },
                    480: {
                        items: 1
                    },
                    600: {
                        items: 1
                    },
                    800: {
                        items: 2
                    },
                    1024: {
                        items: 2
                    }
                }
            });
        }
       
        if ($('.three-item-carousel').length) {
            $('.three-item-carousel').owlCarousel({
                loop: true,
                margin: 30,
                nav: true,
                smartSpeed: 1000,
                autoplay: 500,
                navText: ['<span class="far fa-long-arrow-alt-left"></span>', '<span class="far fa-long-arrow-alt-right"></span>'],
                responsive: {
                    0: {
                        items: 1
                    },
                    480: {
                        items: 1
                    },
                    600: {
                        items: 2
                    },
                    800: {
                        items: 2
                    },
                    1024: {
                        items: 3
                    }
                }
            });
        }


        
        if ($('.four-item-carousel').length) {
            $('.four-item-carousel').owlCarousel({
                loop: true,
                margin: 30,
                nav: true,
                smartSpeed: 500,
                autoplay: 5000,
                navText: ['<span class="fas fa-angle-left"></span>', '<span class="fas fa-angle-right"></span>'],
                responsive: {
                    0: {
                        items: 1
                    },
                    600: {
                        items: 2
                    },
                    800: {
                        items: 2
                    },
                    1024: {
                        items: 3
                    },
                    1200: {
                        items: 4
                    }
                }
            });
        }
        
        if ($('.single-item-carousel').length) {
            $('.single-item-carousel').owlCarousel({
                loop: true,
                margin: 30,
                nav: false,
                smartSpeed: 3000,
                autoplay: true,
                navText: ['<span class="fas fa-angle-left"></span>', '<span class="fas fa-angle-right"></span>'],
                responsive: {
                    0: {
                        items: 1
                    },
                    480: {
                        items: 1
                    },
                    600: {
                        items: 1
                    },
                    800: {
                        items: 1
                    },
                    1200: {
                        items: 1
                    }

                }
            });
        }
    }


    $(window).on('elementor/frontend/init', function() {
        elementorFrontend.hooks.addAction('frontend/element_ready/dormatic_servces.default', addons_js);
        elementorFrontend.hooks.addAction('frontend/element_ready/dormatic_testimonial.default', addons_js);
        elementorFrontend.hooks.addAction('frontend/element_ready/dormatic_team.default', addons_js);
        elementorFrontend.hooks.addAction('frontend/element_ready/dormatic_feature.default', addons_js);
        elementorFrontend.hooks.addAction('frontend/element_ready/dormatic_blog.default', addons_js);
        elementorFrontend.hooks.addAction('frontend/element_ready/dormatic_funfact.default', addons_js);
        elementorFrontend.hooks.addAction('frontend/element_ready/dormatic_works.default', addons_js);
    });
})(window.jQuery);