<?php
namespace Dormatic\Helper\Elementor\Widgets;

use Elementor\Utils;
use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use Elementor\Plugin;
use Elementor\Repeater;

class Dormatic_Team extends Widget_Base {

	public function get_name() {
		return 'dormatic_team';
	}

	public function get_title() {
		return esc_html__( 'Dormatic Team', 'dormatic' );
	}

	public function get_icon() {
		return 'sds-widget-ico';
	}

	public function get_categories() {
		return array( 'Dormatic' );
	}

	protected function register_controls() {

		$this->start_controls_section(
			'general',
			array(
				'label' => esc_html__( 'general', 'dormatic' ),
			)
		);
		$this->add_control(
			'layout_type',
			array(
				'label'   => esc_html__( 'Layout Type', 'dormatic-core' ),
				'type'    => Controls_Manager::SELECT,
				'options' => array(
					'slider' => esc_html__( 'Slider', 'dormatic-core' ),
					'grid'   => esc_html__( 'Grid', 'dormatic-core' ),
				),
				'default' => 'slider',
			)
		);
		$this->add_control(
			'tagline',
			array(
				'label'   => esc_html__( 'Tagline', 'dormatic' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'Garage Door installation & Repair', 'dormatic' ),
			)
		);

		$this->add_control(
			'heading',
			array(
				'label'   => esc_html__( 'Heading', 'dormatic' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'Our Team Members', 'dormatic' ),
			)
		);

		$this->add_control(
			'header_size',
			[
				'label' => esc_html__( 'HTML Tag', 'elementor' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'h1' => 'H1',
					'h2' => 'H2',
					'h3' => 'H3',
					'h4' => 'H4',
					'h5' => 'H5',
					'h6' => 'H6',
				],
				'default' => 'h2',
			]
		);

		$this->add_control(
			'sub_heading',
			array(
				'label'       => esc_html__( 'Sub Heading', 'dormatic' ),
				'type'        => Controls_Manager::TEXTAREA,
				'rows'        => 6,
				'placeholder' => esc_html__( 'Type your description here', 'dormatic' ),

			)
		);
		$this->add_control(
			'extra_class',
			array(
				'label' => esc_html__( 'Extra Class', 'dormatic-core' ),
				'type'  => Controls_Manager::TEXT,
			)
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'item',
			array(
				'label' => esc_html__( 'item', 'dormatic' ),
			)
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'item_title',
			array(
				'label'   => esc_html__( 'Name', 'dormatic' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'Daniel Ricardo', 'dormatic' ),
			)
		);

		$repeater->add_control(
			'item_designation',
			array(
				'label'   => esc_html__( 'Designation', 'dormatic' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'Director & CEO', 'dormatic' ),
			)
		);

		$repeater->add_control(
			'item_image',
			array(
				'label'   => esc_html__( 'Image', 'dormatic' ),
				'type'    => Controls_Manager::MEDIA,
				'default' => array(
					'url' => Utils::get_placeholder_image_src(),
				),

			)
		);

		$repeater->add_control(
			'item_social_links',
			array(
				'label'       => esc_html__( 'Social Links', 'dormatic' ),
				'type'        => Controls_Manager::TEXTAREA,
				'rows'        => 6,
				'placeholder' => esc_html__( 'Type your description here', 'dormatic' ),

			)
		);

		$this->add_control(
			'items',
			array(
				'label'   => esc_html__( 'Repeater List', 'dormatic' ),
				'type'    => Controls_Manager::REPEATER,
				'fields'  => $repeater->get_controls(),
				'default' => array(
					array(
						'list_title'   => esc_html__( 'Title #1', 'dormatic' ),
						'list_content' => esc_html__( 'Item content. Click the edit button to change this text.', 'dormatic' ),
					),
					array(
						'list_title'   => esc_html__( 'Title #2', 'dormatic' ),
						'list_content' => esc_html__( 'Item content. Click the edit button to change this text.', 'dormatic' ),
					),
				),
			)
		);

		$this->end_controls_section();

		// Typography Section

		$this->start_controls_section(
			'typography_section',
			array(
				'label' => __( 'Typography Section', 'elementor' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'     => 'tagline_typography',
				'label'    => __( 'Tagline', 'elementor' ),
				'selector' => '{{WRAPPER}} .sec-title span',
			)
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'     => 'heading_typography',
				'label'    => __( 'Heading', 'elementor' ),
				'selector' => '{{WRAPPER}} .sec-title h2',
			)
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'     => 'subheading_typography',
				'label'    => __( 'Sub Heading', 'elementor' ),
				'selector' => '{{WRAPPER}} .sec-title p,{{WRAPPER}} .feature-block-four .inner-box h3',
			)
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'     => 'name_typography',
				'label'    => __( 'Name', 'elementor' ),
				'selector' => '{{WRAPPER}} .team-block-one .inner-box .lower-content h3',
			)
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'     => 'designation_typography',
				'label'    => __( 'Designation', 'prunelementorers' ),
				'selector' => '{{WRAPPER}} .team-block-one .inner-box .lower-content .designation',
			)
		);
		$this->end_controls_section();

		// color_section
		$this->start_controls_section(
			'color_section',
			array(
				'label' => __( 'Color Section', 'elementor' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);
		$this->start_controls_tabs( 'tabs_button_style' );
		$this->start_controls_tab(
			'tab_button_normal',
			array(
				'label' => __( 'Normal', 'elementor' ),
			)
		);

		$this->end_controls_tab();
		$this->start_controls_tab(
			'tab_button_hover',
			array(
				'label' => __( 'Hover', 'elementor' ),
			)
		);

		$this->add_control(
			'icon_hover_color',
			array(
				'label'     => __( 'Icon Hover Color', 'elementor' ),
				'separator' => 'before',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .team-block-one .inner-box .lower-content .social-links li a' => 'color: {{VALUE}}',
				),
			)
		);

		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();

	}
	protected function render() {
		$settings    = $this->get_settings_for_display();
		$layout_type = $settings['layout_type'];
		$tagline     = $settings['tagline'];
		$heading     = $settings['heading'];
		$heading_html = sprintf( '<%1$s %2$s>%3$s</%1$s>', Utils::validate_html_tag( $settings['header_size'] ), $this->get_render_attribute_string( 'heading' ), $heading );
		$sub_heading = $settings['sub_heading'];
		$extra_class = $settings['extra_class'];
		?>
		<?php if ( $layout_type == 'slider' ) { ?>
		<section class="team-section centred <?php echo $extra_class; ?>">
			<div class="auto-container">
				<?php if ( ! empty( $tagline ) || ! empty( $heading ) || ! empty( $sub_heading ) ) { ?>
				<div class="sec-title">
					<span><?php echo $tagline; ?></span>
					<?php echo $heading_html; ?>
					<p><?php echo $sub_heading; ?></p>
				</div>
				<?php } ?>
				<div class="four-item-carousel owl-carousel owl-theme owl-nav-none dots-style-one">
				<?php
					$i = 1;
				foreach ( $settings['items'] as $item ) {
					$item_title        = $item['item_title'];
					$item_designation  = $item['item_designation'];
					$item_image        = ( $item['item_image']['id'] != '' ) ? wp_get_attachment_image( $item['item_image']['id'], 'full' ) : $item['item_image']['url'];
					$item_image_alt    = get_post_meta( $item['item_image']['id'], '_wp_attachment_image_alt', true );
					$item_social_links = $item['item_social_links'];
					?>
				<div class="team-block-one">
			<div class="inner-box">
				<figure class="image-box">
					<?php
					if ( wp_http_validate_url( $item_image ) ) {
						?>
					<img src="<?php echo esc_url( $item_image ); ?>" alt="<?php esc_attr( $item_image_alt ); ?>">
						<?php
					} else {
						echo $item_image;
					}
					?>
				</figure>
				<div class="lower-content">
					<h3><?php echo $item_title; ?></h3>
					<span class="designation"><?php echo $item_designation; ?></span>
					<ul class="social-links clearfix">
												<?php echo $item_social_links; ?>
					</ul>
					</div>
				</div>
			</div> 
			<?php $i++; } ?> 						
				</div>
			</div>
		</section> 
	<?php } elseif ( $layout_type == 'grid' ) { ?>
		<section class="team-section centred <?php echo $extra_class; ?>">
			<div class="auto-container">
			<?php if ( ! empty( $tagline ) || ! empty( $heading ) || ! empty( $sub_heading ) ) { ?>
				<div class="sec-title">
					<span><?php echo $tagline; ?></span>
					<?php echo $heading_html; ?>
					<p><?php echo $sub_heading; ?></p>
				</div>
			<?php } ?>
				<div class="row clearfix">
				<?php
					$i = 1;
				foreach ( $settings['items'] as $item ) {
					$item_title        = $item['item_title'];
					$item_designation  = $item['item_designation'];
					$item_image        = ( $item['item_image']['id'] != '' ) ? wp_get_attachment_image( $item['item_image']['id'], 'full' ) : $item['item_image']['url'];
					$item_image_alt    = get_post_meta( $item['item_image']['id'], '_wp_attachment_image_alt', true );
					$item_social_links = $item['item_social_links'];
					?>
					<div class="col-lg-3 col-md-6 col-sm-12 team-block">
						<div class="team-block-one">
							<div class="inner-box">
								<figure class="image-box">
									<?php
									if ( wp_http_validate_url( $item_image ) ) {
										?>
									<img src="<?php echo esc_url( $item_image ); ?>" alt="<?php esc_attr( $item_image_alt ); ?>">
										<?php
									} else {
										echo $item_image;
									}
									?>
								</figure>
								<div class="lower-content">
									<h3><?php echo $item_title; ?></h3>
									<span class="designation"><?php echo $item_designation; ?></span>
									<ul class="social-links clearfix">
												<?php echo $item_social_links; ?>
									</ul>
								</div>
							</div>
						</div> 
					</div> 
			<?php $i++; } ?> 						
				</div>
			</div>
		</section> 
			<?php
	}
	}

	protected function content_template() {
	}
}
