<?php
namespace Dormatic\Helper\Elementor\Widgets;

use Elementor\Utils;
use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use Elementor\Plugin;
use \Elementor\Repeater;

class Dormatic_Service_Thumb_With_Title extends Widget_Base {

	public function get_name() {
		return 'dormatic_service_thumb_with_title';
	}

	public function get_title() {
		return esc_html__( 'Dormatic Service Thumb With Title', 'dormatic' );
	}

	public function get_icon() {
		return 'sds-widget-ico';
	}

	public function get_categories() {
		return array( 'Dormatic' );
	}

	protected function register_controls() {

		$this->start_controls_section(
			'general',
			array(
				'label' => esc_html__( 'general', 'dormatic' ),
			)
		);

		$this->add_control(
			'title',
			array(
				'label'   => esc_html__( 'Title', 'dormatic' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'Garage Door Repair', 'dormatic' ),
			)
		);

		$this->add_control(
			'header_size',
			[
				'label' => esc_html__( 'HTML Tag', 'elementor' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'h1' => 'H1',
					'h2' => 'H2',
					'h3' => 'H3',
					'h4' => 'H4',
					'h5' => 'H5',
					'h6' => 'H6',
				],
				'default' => 'h2',
			]
		);

		$this->add_control(
			'subtitle',
			array(
				'label'       => esc_html__( 'Subtitle', 'dormatic' ),
				'type'        => Controls_Manager::TEXTAREA,
				'rows'        => 6,
				'default'     => __( 'At Dormetic, We fix the garage doors of many residential homes & commercial spaces of customers each year.', 'dormatic' ),
				'placeholder' => esc_html__( 'Type your description here', 'dormatic' ),

			)
		);

		$this->add_control(
			'image',
			array(
				'label'   => esc_html__( 'Image', 'dormatic' ),
				'type'    => Controls_Manager::MEDIA,
				'default' => array(
					'url' => Utils::get_placeholder_image_src(),
				),

			)
		);

		$this->add_control(
			'content',
			array(
				'label'       => esc_html__( 'Content', 'dormatic' ),
				'type'        => Controls_Manager::TEXTAREA,
				'rows'        => 6,
				'placeholder' => esc_html__( 'Type your description here', 'dormatic' ),
			)
		);

		$this->end_controls_section();

	}
	protected function render() {
		$settings          = $this->get_settings_for_display();
		$title             = $settings['title'];
		$heading_html = sprintf( '<%1$s %2$s>%3$s</%1$s>', Utils::validate_html_tag( $settings['header_size'] ), $this->get_render_attribute_string( 'title' ), $title );
				$subtitle  = $settings['subtitle'];
				$image     = ( $settings['image']['id'] != '' ) ? wp_get_attachment_image( $settings['image']['id'], 'full' ) : $settings['image']['url'];
				$image_alt = get_post_meta( $settings['image']['id'], '_wp_attachment_image_alt', true );
				$content   = $settings['content'];
		?> 
		<div class="content-one">
			<?php if ( ! empty( $title ) || ! empty( $subtitle ) ) { ?>
			<div class="text">
				<?php echo $heading_html; ?>
				<h3><?php echo $subtitle; ?></h3>
			</div>
			<?php } ?>
			<figure class="image-box">
				<?php
				if ( wp_http_validate_url( $image ) ) {
					?>
									<img src="<?php echo esc_url( $image ); ?>" alt="<?php esc_url( $image_alt ); ?>">
					<?php
				} else {
					echo $image;
				}
				?>
			</figure>
			<div class="text">
				<?php echo $content; ?>
			</div>
		</div> 
		<?php
	}

	protected function content_template() {
	}
}
