<?php
namespace Dormatic\Helper\Elementor\Widgets;

use Elementor\Utils;
use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use Elementor\Plugin;
use \Elementor\Repeater;

class Dormatic_Service_Form extends Widget_Base {

	public function get_name() {
		return 'dormatic_service_form';
	}

	public function get_title() {
		return esc_html__( 'Dormatic Service Form', 'dormatic' );
	}

	public function get_icon() {
		return 'sds-widget-ico';
	}

	public function get_categories() {
		return array( 'Dormatic' );
	}

	protected function register_controls() {

		$this->start_controls_section(
			'general',
			array(
				'label' => esc_html__( 'general', 'dormatic' ),
			)
		);
		$this->add_control(
			'bg_text',
			array(
				'label'   => esc_html__( 'BG Text', 'dormatic' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'Dormatic', 'dormatic' ),
			)
		);
		$this->add_control(
			'heading',
			array(
				'label'   => esc_html__( 'Heading', 'dormatic' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'Any Questions? Drop Us A Line', 'dormatic' ),
			)
		);

		$this->add_control(
			'header_size',
			[
				'label' => esc_html__( 'HTML Tag', 'elementor' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'h1' => 'H1',
					'h2' => 'H2',
					'h3' => 'H3',
					'h4' => 'H4',
					'h5' => 'H5',
					'h6' => 'H6',
				],
				'default' => 'h2',
			]
		);

		$this->add_control(
			'sub_heading',
			array(
				'label'       => esc_html__( 'Sub Heading', 'dormatic' ),
				'type'        => Controls_Manager::TEXTAREA,
				'rows'        => 6,
				'default'     => __( 'Get in touch with us today for any service. (*) Indicates required fields.', 'dormatic' ),
				'placeholder' => esc_html__( 'Type your description here', 'dormatic' ),

			)
		);

		$this->add_control(
			'right_button_text',
			array(
				'label'   => esc_html__( 'Right Button Text', 'dormatic' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'find a service center near you', 'dormatic' ),
			)
		);

		$this->add_control(
			'right_button_link',
			array(
				'label'         => esc_html__( 'Right Button Link', 'dormatic' ),
				'type'          => Controls_Manager::URL,
				'placeholder'   => esc_html__( 'https://your-link.com', 'dormatic' ),
				'show_external' => true,
				'default'       => array(
					'url'         => '',
					'is_external' => false,
					'nofollow'    => false,
				),

			)
		);

		$this->add_control(
			'right_button_icon',
			array(
				'label' => esc_html__( 'Right Button Icon', 'dormatic' ),
				'type'  => Controls_Manager::ICONS,
			)
		);
		$this->add_control(
			'contact_form',
			array(
				'label'   => esc_html__( 'Contact Form', 'dormatic' ),
				'type'    => Controls_Manager::SELECT,
				'options' => getContactForm7Posts(),
			)
		);

		$this->end_controls_section();


		// Typography Section
        $this->start_controls_section(
            'typography_section',
            array(
                'label' => __('Typography Section', 'elementor'),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            )
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            array(
                'name'     => 'title_typography',
                'label'    => __('Title', 'elementor'),
                'selector' => '{{WRAPPER}} .service-form-section .service-form .title-inner .text h2',
            )
		);
		
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            array(
                'name'     => 'subtitle_typography',
                'label'    => __('Subtitle', 'elementor'),
                'selector' => '{{WRAPPER}} .service-form-section .service-form .title-inner .text p',
            )
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            array(
                'name'     => 'location_desc_typography',
                'label'    => __('Location Desc', 'pruners'),
                'selector' => '{{WRAPPER}} .service-form-section .service-form .title-inner .link a',
            )
        );
        $this->end_controls_section();

        // color_section
        $this->start_controls_section(
            'color_section',
            array(
                'label' => __('Color Section', 'elementor'),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            )
        );
        $this->start_controls_tabs('tabs_button_style');
        $this->start_controls_tab(
            'tab_button_normal',
            array(
                'label' => __('Normal', 'elementor'),
            )
        );

        $this->add_control(
            'button_bg_color',
            array(
                'label'     => __('Button BG color', 'elementor'),
                'separator' => 'before',
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => array(
                    '{{WRAPPER}} .theme-btn-one ' => 'background-color: {{VALUE}}',
                ),
            )
        );

        $this->end_controls_tab();
        $this->start_controls_tab(
            'tab_button_hover',
            array(
                'label' => __('Hover', 'elementor'),
            )
		);
		$this->add_control(
            'button_hover_color',
            array(
                'label'     => __('Button BG color', 'elementor'),
                'separator' => 'before',
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => array(
                    '{{WRAPPER}} .theme-btn-one ' => 'color: {{VALUE}}',
                ),
            )
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();


	}
	protected function render() {
		$settings = $this->get_settings_for_display();

			$bg_text                    = $settings['bg_text'];
			$heading                    = $settings['heading'];
			$heading_html = sprintf( '<%1$s %2$s>%3$s</%1$s>', Utils::validate_html_tag( $settings['header_size'] ), $this->get_render_attribute_string( 'heading' ), $heading );
			$sub_heading                = $settings['sub_heading'];
			$right_button_text          = $settings['right_button_text'];
			$right_button_link          = $settings['right_button_link']['url'];
			$right_button_link_external = $settings['right_button_link']['is_external'] ? 'target="_blank"' : '';
			$right_button_link_nofollow = $settings['right_button_link']['nofollow'] ? 'rel="nofollow"' : '';
			$right_button_icon          = $settings['right_button_icon'];
			$contact_form               = $settings['contact_form'];
		?> 
					<section class="service-form-section">
						<span class="title-text"><?php echo $bg_text; ?></span>
						<div class="auto-container">
							<div class="service-form">
								<div class="title-inner">
									<div class="text">
										<?php echo $heading_html; ?>
										<p><?php echo $sub_heading; ?></p>
									</div>
									<div class="link">
										<a href="<?php echo esc_url( $right_button_link ); ?>" <?php echo $right_button_link_external; ?>  <?php echo $right_button_link_nofollow; ?>><?php \Elementor\Icons_Manager::render_icon( ( $right_button_icon ), array( 'aria-hidden' => 'true' ) ); ?><?php echo $right_button_text; ?></a>
									</div>
								</div>
								<div class="form-inner">
									<?php
									if ( $contact_form ) :
										echo do_shortcode( '[contact-form-7 id="' . $contact_form . '"]' );
									endif;
									?>
								</div>
							</div>
						</div>
					</section>
			<?php

	}

	protected function content_template() {
	}
}
