<?php
namespace Dormatic\Helper\Elementor\Widgets;

use Elementor\Utils;
use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use Elementor\Plugin;
use \Elementor\Repeater;

class Dormatic_Footer_Logo extends Widget_Base {

	public function get_name() {
		return 'dormatic_footer_logo';
	}

	public function get_title() {
		return esc_html__( 'Dormatic Footer Logo', 'dormatic' );
	}

	public function get_icon() {
		return 'sds-widget-ico';
	}

	public function get_categories() {
		return array( 'Dormatic' );
	}

	protected function register_controls() {

		$this->start_controls_section(
			'general',
			array(
				'label' => esc_html__( 'general', 'dormatic' ),
			)
		);

		$this->add_control(
			'logo',
			array(
				'label'   => esc_html__( 'Logo', 'dormatic' ),
				'type'    => Controls_Manager::MEDIA,
				'default' => array(
					'url' => Utils::get_placeholder_image_src(),
				),

			)
		);

		$this->add_control(
			'short_desc',
			array(
				'label'       => esc_html__( 'Short Desc', 'dormatic' ),
				'type'        => Controls_Manager::TEXTAREA,
				'rows'        => 6,
				'default'     => __( 'Sunt culpa qui officia deslys mollit ipsum est dolor se laborum. Sed perspiciatis un iste natus error sit voluptatem.', 'dormatic' ),
				'placeholder' => esc_html__( 'Type your description here', 'dormatic' ),

			)
		);

		$this->add_control(
			'logo_link',
			array(
				'label'         => esc_html__( 'Logo Link', 'dormatic' ),
				'type'          => Controls_Manager::URL,
				'placeholder'   => esc_html__( 'https://your-link.com', 'dormatic' ),
				'show_external' => true,
				'default'       => array(
					'url'         => '',
					'is_external' => false,
					'nofollow'    => false,
				),

			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'item',
			array(
				'label' => esc_html__( 'item', 'dormatic' ),
			)
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'item_social_icon',
			array(
				'label' => esc_html__( 'Social Icon', 'dormatic' ),
				'type'  => Controls_Manager::ICONS,
			)
		);

		$repeater->add_control(
			'item_social_link',
			array(
				'label'         => esc_html__( 'Social Link', 'dormatic' ),
				'type'          => Controls_Manager::URL,
				'placeholder'   => esc_html__( 'https://your-link.com', 'dormatic' ),
				'show_external' => true,
				'default'       => array(
					'url'         => '',
					'is_external' => false,
					'nofollow'    => false,
				),

			)
		);

		$this->add_control(
			'items',
			array(
				'label'   => esc_html__( 'Repeater List', 'dormatic' ),
				'type'    => Controls_Manager::REPEATER,
				'fields'  => $repeater->get_controls(),
				'default' => array(
					array(
						'list_title'   => esc_html__( 'Title #1', 'dormatic' ),
						'list_content' => esc_html__( 'Item content. Click the edit button to change this text.', 'dormatic' ),
					),
				),
			)
		);

		$this->end_controls_section();

	}
	protected function render() {
		$settings                   = $this->get_settings_for_display();
				$logo               = ( $settings['logo']['id'] != '' ) ? wp_get_attachment_image( $settings['logo']['id'], 'full' ) : $settings['logo']['url'];
				$logo_alt           = get_post_meta( $settings['logo']['id'], '_wp_attachment_image_alt', true );
				$short_desc         = $settings['short_desc'];
				$logo_link          = $settings['logo_link']['url'];
				$logo_link_external = $settings['logo_link']['is_external'] ? 'target="_blank"' : '';
				$logo_link_nofollow = $settings['logo_link']['nofollow'] ? 'rel="nofollow"' : '';
		?> 
			<div class="footer-widget logo-widget">
				<figure class="footer-logo">
					<a href="<?php echo esc_url( $logo_link ); ?>" <?php echo $logo_link_external; ?>  <?php echo $logo_link_nofollow; ?>>
							<?php
							if ( wp_http_validate_url( $logo ) ) {
								?>
							<img src="<?php echo esc_url( $logo ); ?>" alt="<?php esc_url( $logo_alt ); ?>">
								<?php
							} else {
								echo $logo;
							}
							?>
					</a>
				</figure>
				<div class="text">
					<p><?php echo $short_desc; ?></p>
				</div>
				<ul class="social-links clearfix">
					<?php
					$i = 1;
					foreach ( $settings['items'] as $item ) {
						$item_social_icon          = $item['item_social_icon'];
						$item_social_link          = $item['item_social_link']['url'];
						$item_social_link_external = $item['item_social_link']['is_external'] ? 'target="_blank"' : '';
						$item_social_link_nofollow = $item['item_social_link']['nofollow'] ? 'rel="nofollow"' : '';
						if(!empty($item_social_link)){
						?>
						<li><a href="<?php echo esc_url( $item_social_link ); ?>" <?php echo $item_social_link_external; ?>  <?php echo $item_social_link_nofollow; ?>><?php \Elementor\Icons_Manager::render_icon( ( $item_social_icon ), array( 'aria-hidden' => 'true' ) ); ?></a></li> 
						<?php $i++; } } ?> 
				</ul>
			</div> 
		<?php
	}

	protected function content_template() {
	}
}
