<?php
namespace Dormatic\Helper\Elementor\Widgets;

use Elementor\Utils;
use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use Elementor\Plugin;
use Elementor\Repeater;
use Elementor\Group_Control_Typography;

class Dormatic_Banner_Slider extends Widget_Base {


	public function get_name() {
		return 'dormatic_banner_slider';
	}

	public function get_title() {
		return esc_html__( 'Dormatic Banner Slider', 'dormatic-core' );
	}

	public function get_icon() {
		return 'sds-widget-ico';
	}

	public function get_categories() {
		return array( 'Dormatic' );
	}

	protected function register_controls() {

		$this->start_controls_section(
			'item',
			array(
				'label' => esc_html__( 'item', 'dormatic-core' ),
			)
		);

		$this->add_control(
			'layout_style',
			array(
				'label'   => esc_html__( 'Layout Style', 'dormatic-core' ),
				'type'    => Controls_Manager::SELECT,
				'options' => array(
					'style_1' => esc_html__( 'Style One', 'dormatic-core' ),
					'style_2' => esc_html__( 'Style Two', 'dormatic-core' ),
					'style_3' => esc_html__( 'Style Three', 'dormatic-core' ),
				),
				'default' => 'style_1',
			)
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'item_title',
			array(
				'label'   => esc_html__( 'Title', 'dormatic-core' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'Quality Garage Door Installations & Repairs', 'dormatic-core' ),
			)
		);				

		$repeater->add_control(
			'header_size',
			[
				'label' => esc_html__( 'Title Tag', 'elementor' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'h1' => 'H1',
					'h2' => 'H2',
					'h3' => 'H3',
					'h4' => 'H4',
					'h5' => 'H5',
					'h6' => 'H6',
				],
				'default' => 'h1',
			]
		);

		$repeater->add_control(
			'item_subtitle',
			array(
				'label'   => esc_html__( 'Subtitle', 'dormatic-core' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'Welcome To Dormatic Service', 'dormatic-core' ),
			)
		);

		$repeater->add_control(
			'item_short_desc',
			array(
				'label'       => esc_html__( 'Short Desc', 'dormatic-core' ),
				'type'        => Controls_Manager::TEXTAREA,
				'rows'        => 6,
				'default'     => __( 'Mod tempor incididunt ut laboret dolore magna aliqua tenim adnim veniam quis nostrud exercitation ullamco.', 'dormatic-core' ),
				'placeholder' => esc_html__( 'Type your description here', 'dormatic-core' ),

			)
		);

		$repeater->add_control(
			'item_button_01_text',
			array(
				'label'   => esc_html__( 'Button 01 Text', 'dormatic-core' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( '(+1) 201 719 3488 | Book an Appointment Today!', 'dormatic-core' ),
			)
		);

		$repeater->add_control(
			'item_button_01_url',
			array(
				'label'         => esc_html__( 'Button 01 URL', 'dormatic-core' ),
				'type'          => Controls_Manager::URL,
				'placeholder'   => esc_html__( 'https://your-link.com', 'dormatic-core' ),
				'show_external' => true,
				'default'       => array(
					'url'         => '',
					'is_external' => true,
					'nofollow'    => true,
				),

			)
		);

		$repeater->add_control(
			'item_button_02_text',
			array(
				'label'   => esc_html__( 'Button 02 Text', 'dormatic-core' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'learn more', 'dormatic-core' ),
			)
		);

		$repeater->add_control(
			'item_button_02_url',
			array(
				'label'         => esc_html__( 'Button 02 URL', 'dormatic-core' ),
				'type'          => Controls_Manager::URL,
				'placeholder'   => esc_html__( 'https://your-link.com', 'dormatic-core' ),
				'show_external' => true,
				'default'       => array(
					'url'         => '',
					'is_external' => true,
					'nofollow'    => true,
				),

			)
		);

		$repeater->add_control(
			'item_image',
			array(
				'label'   => esc_html__( 'Image', 'dormatic-core' ),
				'type'    => Controls_Manager::MEDIA,
				'default' => array(
					'url' => Utils::get_placeholder_image_src(),
				),

			)
		);

		$this->add_control(
			'items',
			array(
				'label'   => esc_html__( 'Repeater List', 'dormatic-core' ),
				'type'    => Controls_Manager::REPEATER,
				'fields'  => $repeater->get_controls(),
				'default' => array(
					array(
						'list_title'   => esc_html__( 'Title #1', 'dormatic-core' ),
						'list_content' => esc_html__( 'Item content. Click the edit button to change this text.', 'dormatic-core' ),
					),
					array(
						'list_title'   => esc_html__( 'Title #2', 'dormatic-core' ),
						'list_content' => esc_html__( 'Item content. Click the edit button to change this text.', 'dormatic-core' ),
					),
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'slider_settings',
			array(
				'label' => esc_html__( 'Slider Settings', 'dormatic' ),
			)
		);
		$this->add_control(
			'loop',
			array(
				'label'        => esc_html__( 'Enable Loop', 'dormatic' ),
				'type'         => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default'      => 'yes',
			)
		);
		$this->add_control(
			'mouseDrag',
			array(
				'label'        => esc_html__( 'Enable mouseDrag', 'dormatic' ),
				'type'         => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default'      => 'yes',
			)
		);
		$this->add_control(
			'autoplay',
			array(
				'label'        => esc_html__( 'Enable Autoplay', 'dormatic' ),
				'type'         => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default'      => 'yes',

			)
		);
		$this->add_control(
			'autoplay_speed',
			array(
				'label'   => esc_html__( 'Autoplay Speed', 'dormatic' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => '6000',
			)
		);
		$this->add_control(
			'arrows',
			array(
				'label'        => esc_html__( 'Enable Arrows', 'dormatic' ),
				'type'         => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default'      => 'false',

			)
		);
		$this->end_controls_section();

		// Typography Section

		$this->start_controls_section(
			'typography_section',
			array(
				'label' => __( 'Typography Section', 'elementor' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(), 
			array(
				'name'     => 'tagline_typography',
				'label'    => __( 'Tagline', 'elementor' ),
				'selector' => '{{WRAPPER}} .banner-section.style-two .banner-carousel .active .content-box h3,{{WRAPPER}} .banner-carousel .content-box h5',
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'title_typography',
				'label'    => __( 'Title', 'prunelementorers' ),
				'selector' => '{{WRAPPER}} .banner-carousel .content-box h1,{{WRAPPER}} .banner-section.style-two .banner-carousel .content-box h1',
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'short_desc_typography',
				'label'    => __( 'Short Desc', 'elementor' ),
				'selector' => '{{WRAPPER}} .banner-carousel .content-box p',
			)
		);
		$this->end_controls_section();

		// color_section
		$this->start_controls_section(
			'color_section',
			array(
				'label' => __( 'Color Section', 'elementor' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);
		$this->start_controls_tabs( 'tabs_button_style' );
		$this->start_controls_tab(
			'tab_button_normal',
			array(
				'label' => __( 'Normal', 'elementor' ),
			)
		);
		$this->add_control(
			'tagline_color',
			array(
				'label'     => __( 'Tagline Color', 'elementor' ),
				'separator' => 'before',
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .banner-carousel .content-box h5 ' => 'color: {{VALUE}}',
					'{{WRAPPER}} .banner-section.style-two .banner-carousel .active .content-box h3 ' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'button1_bg_color',
			array(
				'label'     => __( 'Button1 BG Color', 'elementor' ),
				'separator' => 'before',
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .banner-carousel .content-box .btn-box .call-now .inner ' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .banner-btn ' => 'background-color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'button2_bg_color',
			array(
				'label'     => __( 'Button2 BG Color', 'elementor' ),
				'separator' => 'before',
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .theme-btn-one ' => 'background-color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'icon_color',
			array(
				'label'     => __( 'Icon Color', 'elementor' ),
				'separator' => 'before',
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .banner-carousel .content-box .btn-box .call-now .inner i' => 'color: {{VALUE}}',
				),
			)
		);
		$this->add_control(
			'number_color',
			array(
				'label'     => __( 'Number Color', 'elementor' ),
				'separator' => 'before',
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .banner-carousel .content-box .btn-box .call-now .inner h3 a' => 'color: {{VALUE}}',
				),
			)
		);

		$this->end_controls_tab();
		$this->start_controls_tab(
			'tab_button_hover',
			array(
				'label' => __( 'Hover', 'elementor' ),
			)
		);

		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();

	}
	protected function render() {
		$settings     = $this->get_settings_for_display();
		$layout_style = $settings['layout_style'];
		$loop     = $settings['loop'];
		if ( $loop == 'yes' ) {
			$loop = 'true';
		} else {
			$loop = 'false';
		}

		$mouseDrag     = $settings['mouseDrag'];
		if ( $mouseDrag == 'yes' ) {
			$mouseDrag = 'true';
		} else {
			$mouseDrag = 'false';
		}


		$autoplay = $settings['autoplay'];
		if ( $autoplay == 'yes' ) {
			$autoplay = 'true';
		} else {
			$autoplay = 'false'; 
		}
		$autoplay_speed = $settings['autoplay_speed'];

		$arrows = $settings['arrows'];
		if ( $arrows == 'yes' ) {
			$arrows = 'true';
		} else {
			$arrows = 'false';
		}

		$sl_set = array(
			'loop'              => $loop,
			'autoplay'          => $autoplay,
			'autoplayTimeout'   => ! empty( $autoplay_speed ) ? $autoplay_speed : '8000',
			'nav'         		=> $arrows,
			'mouseDrag'         => $mouseDrag,
		);
		?>
		<!-- banner-section -->
		<?php if ( $layout_style == 'style_1' ) { ?>
		<section class="banner-section">
			<div class="banner-carousel owl-theme owl-carousel"  data-slider='<?php echo wp_json_encode( $sl_set ); ?>'>
				<?php
				$i = 1;
				foreach ( $settings['items'] as $item ) {
					$item_title                  = $item['item_title'];
					$title_html = sprintf( '<%1$s %2$s>%3$s</%1$s>', Utils::validate_html_tag( $item['header_size'] ), $this->get_render_attribute_string( 'item_title' ), $item_title );
					$item_subtitle               = $item['item_subtitle'];
					$item_short_desc             = $item['item_short_desc'];
					$item_button_01_text         = $item['item_button_01_text'];
					$item_button_01_url          = $item['item_button_01_url']['url'];
					$item_button_01_url_external = $item['item_button_01_url']['is_external'] ? 'target="_blank"' : '';
					$item_button_01_url_nofollow = $item['item_button_01_url']['nofollow'] ? 'rel="nofollow"' : '';
					$item_button_02_text         = $item['item_button_02_text'];
					$item_button_02_url          = $item['item_button_02_url']['url'];
					$item_button_02_url_external = $item['item_button_02_url']['is_external'] ? 'target="_blank"' : '';
					$item_button_02_url_nofollow = $item['item_button_02_url']['nofollow'] ? 'rel="nofollow"' : '';
					$item_image                  = ( $item['item_image']['id'] != '' ) ? wp_get_attachment_image_url( $item['item_image']['id'], 'full' ) : $item['item_image']['url'];

					$item_button_01_text = explode( '|', $item_button_01_text );

					?>
					<div class="slide-item">
						<div class="image-layer" style="background-image:url(<?php echo $item_image; ?>)"></div>
						<div class="auto-container">
							<div class="content-box">
								<h5><i class="icon-warehouse"></i><?php echo $item_subtitle; ?></h5>
								<?php echo $title_html; ?>
								<p><?php echo $item_short_desc; ?></p>
								<div class="btn-box clearfix">
									<div class="call-now">
										<div class="inner">
											<i class="icon-mob"></i>
											<?php if ( ! empty( $item_button_01_text[1] ) ) { ?>
											<span><?php echo $item_button_01_text[1]; ?></span>
											<?php } ?>
											<h3><a href="<?php echo $item_button_01_url; ?>"><?php echo $item_button_01_text[0]; ?></a></h3>
										</div>
									</div>
									<a href="<?php echo esc_attr( $item_button_02_url ); ?>" <?php echo $item_button_02_url_external; ?> <?php echo $item_button_02_url_nofollow; ?> class="theme-btn-one"><span class="btn-shape"></span><?php echo $item_button_02_text; ?></a>
								</div>
							</div>
						</div>
					</div> 
					<?php
					$i++;
				}
				?>

			</div>
		</section>
	<?php } elseif ( $layout_style == 'style_2' ) { ?>

	<section class="banner-section style-two centred">
		<div class="banner-carousel owl-theme owl-carousel" data-slider='<?php echo wp_json_encode( $sl_set ); ?>'>
			<?php
				$i = 1;
			foreach ( $settings['items'] as $item ) {
				$item_title                  = $item['item_title'];
				$title_html = sprintf( '<%1$s %2$s>%3$s</%1$s>', Utils::validate_html_tag( $item['header_size'] ), $this->get_render_attribute_string( 'item_title' ), $item_title );
				$item_subtitle               = $item['item_subtitle'];
				$item_short_desc             = $item['item_short_desc'];
				$item_button_01_text         = $item['item_button_01_text'];
				$item_button_01_url          = $item['item_button_01_url']['url'];
				$item_button_01_url_external = $item['item_button_01_url']['is_external'] ? 'target="_blank"' : '';
				$item_button_01_url_nofollow = $item['item_button_01_url']['nofollow'] ? 'rel="nofollow"' : '';
				$item_button_02_text         = $item['item_button_02_text'];
				$item_button_02_url          = $item['item_button_02_url']['url'];
				$item_button_02_url_external = $item['item_button_02_url']['is_external'] ? 'target="_blank"' : '';
				$item_button_02_url_nofollow = $item['item_button_02_url']['nofollow'] ? 'rel="nofollow"' : '';
				$item_image                  = ( $item['item_image']['id'] != '' ) ? wp_get_attachment_image_url( $item['item_image']['id'], 'full' ) : $item['item_image']['url'];
				?>
				<div class="slide-item">
					<div class="image-layer" style="background-image:url(<?php echo $item_image; ?>)"></div>
					<div class="auto-container">
						<div class="content-box">
							<div class="icon-box"><i class="icon-warehouse"></i></div>
							<h3><?php echo $item_subtitle; ?></h3>
							<?php echo $title_html; ?>
							<div class="btn-box clearfix">
								<a href="<?php echo $item_button_01_url; ?>" <?php echo $item_button_01_url_external; ?> <?php echo $item_button_01_url_nofollow; ?>  class="banner-btn"><span class="btn-shape"></span><?php echo $item_button_01_text; ?></a>
								<a href="<?php echo esc_attr( $item_button_02_url ); ?>" <?php echo $item_button_02_url_external; ?> <?php echo $item_button_02_url_nofollow; ?> class="theme-btn-one"><span class="btn-shape"></span><?php echo $item_button_02_text; ?></a>
							</div>
						</div> 
					</div>
				</div>
				<?php
				$i++;
			}
			?>
		</div>
	</section>
		<?php } elseif ( $layout_style == 'style_3' ) { ?>
			<section class="banner-section style-three">
				<div class="banner-carousel owl-theme owl-carousel"  data-slider='<?php echo wp_json_encode( $sl_set ); ?>'>
				<?php
				$i = 1;
				foreach ( $settings['items'] as $item ) {
					$item_title                  = $item['item_title'];
					$item_subtitle               = $item['item_subtitle'];
					$title_html = sprintf( '<%1$s %2$s>%3$s</%1$s>', Utils::validate_html_tag( $item['header_size'] ), $this->get_render_attribute_string( 'item_title' ), $item_title );
					$item_short_desc             = $item['item_short_desc'];
					$item_button_01_text         = $item['item_button_01_text'];
					$item_button_01_url          = $item['item_button_01_url']['url'];
					$item_button_01_url_external = $item['item_button_01_url']['is_external'] ? 'target="_blank"' : '';
					$item_button_01_url_nofollow = $item['item_button_01_url']['nofollow'] ? 'rel="nofollow"' : '';
					$item_button_02_text         = $item['item_button_02_text'];
					$item_button_02_url          = $item['item_button_02_url']['url'];
					$item_button_02_url_external = $item['item_button_02_url']['is_external'] ? 'target="_blank"' : '';
					$item_button_02_url_nofollow = $item['item_button_02_url']['nofollow'] ? 'rel="nofollow"' : '';
					$item_image                  = ( $item['item_image']['id'] != '' ) ? wp_get_attachment_image_url( $item['item_image']['id'], 'full' ) : $item['item_image']['url'];
					?>
					<div class="slide-item">
						<div class="image-layer" style="background-image:url(<?php echo $item_image; ?>)"></div>
						<div class="auto-container">
							<div class="content-box">
								<h5><i class="icon-warehouse"></i><?php echo $item_subtitle; ?></h5>
								<?php echo $title_html; ?>
								<p><?php echo $item_short_desc; ?></p>
								<div class="btn-box clearfix">
									<a href="<?php echo $item_button_01_url; ?>" <?php echo $item_button_01_url_external; ?> <?php echo $item_button_01_url_nofollow; ?>  class="banner-btn"><span class="btn-shape"></span><?php echo $item_button_01_text; ?></a>
									<a href="<?php echo esc_attr( $item_button_02_url ); ?>" <?php echo $item_button_02_url_external; ?> <?php echo $item_button_02_url_nofollow; ?> class="theme-btn-one"><span class="btn-shape"></span><?php echo $item_button_02_text; ?></a>
								</div>
							</div> 
						</div>
					</div>
					<?php
					$i++;
				}
				?>
				</div>
			</section>
			<?php
		}
	}

	protected function content_template() {
	}
}

