<?php
namespace Dormatic\Helper\Elementor\Widgets;

use Elementor\Utils;
use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use Elementor\Plugin;
use Elementor\Repeater;

class Dormatic_About_Section extends Widget_Base {


	public function get_name() {
		return 'dormatic_about_section';
	}

	public function get_title() {
		return esc_html__( 'Dormatic About Section', 'dormatic-core' );
	}

	public function get_icon() {
		return 'sds-widget-ico';
	}

	public function get_categories() {
		return array( 'Dormatic' );
	}

	protected function register_controls() {

		$this->start_controls_section(
			'general',
			array(
				'label' => esc_html__( 'general', 'dormatic-core' ),
			)
		);

		$this->add_control(
			'layout_style',
			array(
				'label'   => esc_html__( 'Layout Style', 'dormatic-core' ),
				'type'    => Controls_Manager::SELECT,
				'options' => array(
					'style_1' => esc_html__( 'Style One', 'dormatic-core' ),
					'style_2' => esc_html__( 'Style Two', 'dormatic-core' ),
				),
				'default' => 'style_1',
			)
		);

		$this->add_control(
			'image_01',
			array(
				'label'   => esc_html__( 'Image 01', 'dormatic-core' ),
				'type'    => Controls_Manager::MEDIA,
				'default' => array(
					'url' => Utils::get_placeholder_image_src(),
				),

			)
		);

		$this->add_control(
			'image_02',
			array(
				'label'   => esc_html__( 'Image 02', 'dormatic-core' ),
				'type'    => Controls_Manager::MEDIA,
				'default' => array(
					'url' => Utils::get_placeholder_image_src(),
				),

			)
		);

		$this->add_control(
			'caption_number',
			array(
				'label'      => esc_html__( 'Caption Number', 'dormatic-core' ),
				'type'       => Controls_Manager::TEXT,
				'default'    => __( '3.5k', 'dormatic-core' ),
				'conditions' => array(
					'relation' => 'or',
					'terms'    => array(
						array(
							'name'     => 'layout_style',
							'operator' => '==',
							'value'    => 'style_1',
						),
					),
				),
			)
		);

		$this->add_control(
			'caption_title',
			array(
				'label'       => esc_html__( 'Caption Title', 'dormatic-core' ),
				'type'        => Controls_Manager::TEXTAREA,
				'rows'        => 0,
				'default'     => __( 'Projects Done This Year', 'dormatic-core' ),
				'placeholder' => esc_html__( 'Type your description here', 'dormatic-core' ),
				'conditions'  => array(
					'relation' => 'or',
					'terms'    => array(
						array(
							'name'     => 'layout_style',
							'operator' => '==',
							'value'    => 'style_1',
						),
					),
				),
			)
		);

		$this->add_control(
			'sub_title',
			array(
				'label'   => esc_html__( 'Sub Title', 'dormatic-core' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'Garage Door Installation & Repair Company', 'dormatic-core' ),
			)
		);

		$this->add_control(
			'title',
			array(
				'label'       => esc_html__( 'Title', 'dormatic-core' ),
				'type'        => Controls_Manager::TEXTAREA,
				'rows'        => 0,
				'default'     => __( 'Garage Door Installation & Repair Company', 'dormatic-core' ),
				'placeholder' => esc_html__( 'Type your description here', 'dormatic-core' ),
			)
		);		

		$this->add_control(
			'header_size',
			[
				'label' => esc_html__( 'HTML Tag', 'elementor' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'h1' => 'H1',
					'h2' => 'H2',
					'h3' => 'H3',
					'h4' => 'H4',
					'h5' => 'H5',
					'h6' => 'H6',
				],
				'default' => 'h2',
			]
		);

		$this->add_control(
			'quotation_sign',
			array(
				'label'   => esc_html__( 'Quotation Sign Images', 'dormatic-core' ),
				'type'    => Controls_Manager::MEDIA,
				'default' => array(
					'url' => Utils::get_placeholder_image_src(),
				),

			)
		);

		$this->add_control(
			'quote_text',
			array(
				'label'       => esc_html__( 'Quote Text', 'dormatic-core' ),
				'type'        => Controls_Manager::TEXTAREA,
				'rows'        => 6,
				'default'     => __( 'We fixes the garage doors of many residential and commercial customers each year.', 'dormatic-core' ),
				'placeholder' => esc_html__( 'Type your description here', 'dormatic-core' ),
			)
		);

		$this->add_control(
			'description',
			array(
				'label'       => esc_html__( 'Description', 'dormatic-core' ),
				'type'        => Controls_Manager::TEXTAREA,
				'rows'        => 6,
				'default'     => __( 'Nunc quam arcu pretium quis quam sed, laoreet efficitur liquam volutpat.lobortis sem consequat consequat imperdiet. In nulla sed viverraut loremut etur diam nuc bibendum imperdiets. Lorem ipsum dolor sit amet.', 'dormatic' ),
				'placeholder' => esc_html__( 'Type your description here', 'dormatic-core' ),
			)
		);

		$this->add_control(
			'signature',
			array(
				'label'   => esc_html__( 'Signature', 'dormatic-core' ),
				'type'    => Controls_Manager::MEDIA,
				'default' => array(
					'url' => Utils::get_placeholder_image_src(),
				),

			)
		);

		$this->add_control(
			'author_name',
			array(
				'label'   => esc_html__( 'Author Name', 'dormatic-core' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'James Smith', 'dormatic-core' ),
			)
		);

		$this->add_control(
			'author_designation',
			array(
				'label'   => esc_html__( 'Author Designation', 'dormatic-core' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'Company Owner', 'dormatic-core' ),
			)
		);
		$this->add_control(
			'background_shape_left',
			array(
				'label'      => esc_html__( 'Background Shape Left', 'dormatic-core' ),
				'type'       => Controls_Manager::MEDIA,
				'default'    => array(
					'url' => Utils::get_placeholder_image_src(),
				),
				'conditions' => array(
					'relation' => 'or',
					'terms'    => array(
						array(
							'name'     => 'layout_style',
							'operator' => '==',
							'value'    => 'style_2',
						),
					),
				),

			)
		);
		$this->add_control(
			'background_shape_right',
			array(
				'label'      => esc_html__( 'Background Shape Right', 'dormatic-core' ),
				'type'       => Controls_Manager::MEDIA,
				'default'    => array(
					'url' => Utils::get_placeholder_image_src(),
				),
				'conditions' => array(
					'relation' => 'or',
					'terms'    => array(
						array(
							'name'     => 'layout_style',
							'operator' => '==',
							'value'    => 'style_2',
						),
					),
				),

			)
		);
		$this->add_control(
			'extra_class',
			array(
				'label' => esc_html__( 'Extra Class', 'dormatic-core' ),
				'type'  => Controls_Manager::TEXT,
			)
		);

		$this->end_controls_section();

		// Typography Section
        $this->start_controls_section(
            'typography_section',
            array(
                'label' => __('Typography Section', 'elementor'),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            )
        );
		$this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            array(
                'name'     => 'tagline_typography',
                'label'    => __('Tagline', 'elementor'),
                'selector' => '{{WRAPPER}} .sec-title span',
            )
		);
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            array(
                'name'     => 'title_typography',
                'label'    => __('Title', 'elementor'),
                'selector' => '{{WRAPPER}} .sec-title h2',
            )
		);
		$this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            array(
                'name'     => 'sub-title',
                'label'    => __('Sub Title', 'elementor'),
                'selector' => '{{WRAPPER}} .content_block_1 .content-box .text h3',
            )
        );
		
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            array(
                'name'     => 'text-content',
                'label'    => __('Text Content', 'elementor'),
                'selector' => '{{WRAPPER}} p',
            )
        );

        $this->end_controls_section();

        // color_section
        $this->start_controls_section(
            'color_section',
            array(
                'label' => __('Color Section', 'elementor'),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            )
        );
        $this->start_controls_tabs('tabs_button_style');
        $this->start_controls_tab(
            'tab_button_normal',
            array(
                'label' => __('Normal', 'elementor'),
            )
        );

		$this->add_control(
            'authorname_color',
            array(
                'label'     => __('Auther Name Color', 'elementor'),
                'separator' => 'before',
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => array(
					'{{WRAPPER}} .content_block_1 .content-box .author-box h3 ' => 'color: {{VALUE}}',
					'{{WRAPPER}} .about-style-three .content-box .author h3 ' => 'color: {{VALUE}}',
                ),
            )
        );

        $this->end_controls_tab();
        $this->start_controls_tab(
            'tab_button_hover',
            array(
                'label' => __('Hover', 'elementor'),
            )
        );


        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

	}
	protected function render() {
		$settings           = $this->get_settings_for_display();
		$image_01           = ( $settings['image_01']['id'] != '' ) ? wp_get_attachment_image( $settings['image_01']['id'], 'full' ) : $settings['image_01']['url'];
		$image_01_alt       = get_post_meta( $settings['image_01']['id'], '_wp_attachment_image_alt', true );
		$image_02           = ( $settings['image_02']['id'] != '' ) ? wp_get_attachment_image( $settings['image_02']['id'], 'full' ) : $settings['image_02']['url'];
		$image_02_alt       = get_post_meta( $settings['image_02']['id'], '_wp_attachment_image_alt', true );
		$caption_number     = $settings['caption_number'];
		$caption_title      = $settings['caption_title'];
		$sub_title          = $settings['sub_title'];
		$title              = $settings['title'];
		$title_html = sprintf( '<%1$s %2$s>%3$s</%1$s>', Utils::validate_html_tag( $settings['header_size'] ), $this->get_render_attribute_string( 'title' ), $title );
		$quote_text         = $settings['quote_text'];
		$quotation_sign     = ( $settings['quotation_sign']['id'] != '' ) ? wp_get_attachment_image( $settings['quotation_sign']['id'], 'full' ) : $settings['quotation_sign']['url'];
		$quotation_sign_alt = get_post_meta( $settings['quotation_sign']['id'], '_wp_attachment_image_alt', true );
		$description        = $settings['description'];
		$signature          = ( $settings['signature']['id'] != '' ) ? wp_get_attachment_image( $settings['signature']['id'], 'full' ) : $settings['signature']['url'];
		$signature_alt      = get_post_meta( $settings['signature']['id'], '_wp_attachment_image_alt', true );
		$author_name        = $settings['author_name'];
		$author_designation = $settings['author_designation'];
		$extra_class        = $settings['extra_class'];

		$layout_style = $settings['layout_style'];
		?>

		<?php if ( $layout_style == 'style_1' ) { ?>
			<!-- about-section -->
			<section class="about-section <?php echo $extra_class; ?>">
				<div class="auto-container">
					<div class="row clearfix">
						<div class="col-lg-6 col-md-12 col-sm-12 image-column">
							<div class="image_block_1">
								<div class="image-box">
									<figure class="image image-1">
										<?php
										if ( wp_http_validate_url( $image_01 ) ) {
											?>
											<img src="<?php echo esc_url( $image_01 ); ?>" alt="<?php esc_attr( $image_01_alt ); ?>">
											<?php
										} else {
											echo $image_01;
										}
										?>
									</figure>
									<figure class="image image-2">
										<?php
										if ( wp_http_validate_url( $image_02 ) ) {
											?>
											<img src="<?php echo esc_url( $image_02 ); ?>" alt="<?php esc_attr( $image_02_alt ); ?>">
											<?php
										} else {
											echo $image_02;
										}
										?>
									</figure>
									<div class="image-content">
										<h2><?php echo $caption_number; ?></h2>
										<h3><?php echo $caption_title; ?></h3>
									</div>
								</div>
							</div>
						</div>
						<div class="col-lg-6 col-md-12 col-sm-12 content-column">
							<div class="content_block_1">
								<div class="content-box">
									<div class="sec-title">
										<span><?php echo $sub_title; ?></span>
										<?php echo $title_html; ?>
									</div>
									<div class="text">
										<div class="quote" style="background-image: url(<?php echo $settings['quotation_sign']['url']; ?>);"></div>
										<h3><?php echo $quote_text; ?></h3>
										<p><?php echo $description; ?></p>
									</div>
									<div class="author-box clearfix">
										<figure class="signature">
											<?php
											if ( wp_http_validate_url( $signature ) ) {
												?>
												<img src="<?php echo esc_url( $signature ); ?>" alt="<?php esc_attr( $signature_alt ); ?>">
												<?php
											} else {
												echo $signature;
											}
											?>
										</figure>
										<h3><?php echo $author_name; ?></h3>
										<span class="designation"><?php echo $author_designation; ?></span>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</section>
			<!-- about-section end -->

			<?php
		} elseif ( $layout_style == 'style_2' ) {

			$background_shape_left = ( $settings['background_shape_left']['id'] != '' ) ? wp_get_attachment_image_url( $settings['background_shape_left']['id'], 'full' ) : $settings['background_shape_left']['url'];

			$background_shape_right     = ( $settings['background_shape_right']['id'] != '' ) ? wp_get_attachment_image( $settings['background_shape_right']['id'], 'full' ) : $settings['background_shape_right']['url'];
			$background_shape_right_alt = get_post_meta( $settings['background_shape_right']['id'], '_wp_attachment_image_alt', true );

			?>
			<!-- about-style-three -->
			<section class="about-style-three <?php echo $extra_class; ?>">
				<div class="image-box">
					<figure class="image image-1">
						<?php
						if ( wp_http_validate_url( $image_01 ) ) {
							?>
							<img src="<?php echo esc_url( $image_01 ); ?>" alt="<?php esc_attr( $image_01_alt ); ?>">
							<?php
						} else {
							echo $image_01;
						}
						?>
					</figure>
					<figure class="image image-2">
						<?php
						if ( wp_http_validate_url( $image_02 ) ) {
							?>
							<img src="<?php echo esc_url( $image_02 ); ?>" alt="<?php esc_attr( $image_02_alt ); ?>">
							<?php
						} else {
							echo $image_02;
						}
						?>
					</figure>
					<div class="image-pattern rotate-me" style="background-image: url(<?php echo $settings['background_shape_left']['url']; ?>);"></div>
				</div>
				<figure class="icon-shape">
					<?php
					if ( wp_http_validate_url( $background_shape_right ) ) {
						?>
						<img src="<?php echo esc_url( $background_shape_right ); ?>" alt="<?php esc_attr( $background_shape_right_alt ); ?>">
						<?php
					} else {
						echo $background_shape_right;
					}
					?>
				</figure>
				<div class="auto-container">
					<div class="row clearfix">
						<div class="col-lg-6 col-md-12 col-sm-12 offset-lg-6 content-block">
							<div class="content_block_1">
								<div class="content-box">
									<div class="sec-title">
										<span><?php echo $sub_title; ?></span>
										<?php echo $title_html; ?>
									</div>
									<div class="text">
										<div class="quote" style="background-image: url(<?php echo $settings['quotation_sign']['url']; ?>);"></div>
										<h3><?php echo $quote_text; ?></h3>
										<p><?php echo $description; ?></p>
									</div>
									<div class="author">
										<figure class="signature">
											<?php
											if ( wp_http_validate_url( $signature ) ) {
												?>
												<img src="<?php echo esc_url( $signature ); ?>" alt="<?php esc_attr( $signature_alt ); ?>">
												<?php
											} else {
												echo $signature;
											}
											?>
										</figure>
										<h3><?php echo $author_name; ?></h3>
										<span class="designation"><?php echo $author_designation; ?></span>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</section>
			<!-- about-style-three end -->
		<?php } ?>


		<?php
	}

	protected function content_template() {
	}
}
