<?php
/**
 * Template part for displaying posts.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package dormatic
 */

$blog_single_social      = dormatic_get_options( 'blog_single_social' );
$single_post_thumb_class = 'no-single-post-thumb';
if ( has_post_thumbnail() ) :
	$single_post_thumb_class = '';
endif;
?>
<?php
	$post_thumb_class = 'no-post-thumb';
if ( has_post_thumbnail() ) :
	$post_thumb_class = '';
endif;
	$is_sticky_class = '';
if ( is_sticky() ) :
	$is_sticky_class = 'sticky-post-class';
endif;
	$the_title_content    = get_the_title();
	$the_title_class_have = 'have-title-post';
if ( $the_title_content != '' ) :
	$the_title_class_have = '';
endif;
?>
<div class="news-block-one <?php echo esc_attr( $post_thumb_class . ' ' . $is_sticky_class ); ?>">
	<div class="inner-box">
		<?php if ( has_post_thumbnail() ) { ?>
		<figure class="image-box">
			<?php the_post_thumbnail(); ?>
		</figure>
		<?php } ?>
		<div class="lower-content">
			<div class="inner">
				<ul class="post-meta clearfix">
					<li class="cats-list"><?php dormatic_category_list(); ?></li>
					<li class="admin"><i class="far fa-user"></i><?php dormatic_posted_by(); ?></li>
					<li><i class="far fa-calendar-alt"></i><?php dormatic_posted_on(); ?></li>
					<li><i class="fal fa-comments"></i><?php dormatic_comments_count(); ?></li>
				</ul>
				<div class="text">
					<h2><?php echo the_title(); ?></h2>
					<?php
					the_content();
					wp_link_pages(
						array(
							'before' => '<div class="page-links">',
							'after'  => '</div>',
						)
					);
					?>
				</div>
			</div>
			<div class="post-info">
				<ul class="info clearfix">
				<?php if ( has_tag() != '' ) : ?>
					<li class="tags pull-left">
						<ul>
							<li><i class="fas fa-tags"></i><h5><?php esc_html_e( 'Tags:', 'dormatic' ); ?></h5></li>
							<?php dormatic_tag_list(); ?>
						</ul>
					</li>
				<?php endif; ?>
					<?php if ( $blog_single_social == '1' ) : ?>
					<li class="share pull-right">
						<i class="far fa-share"></i>
						<?php esc_html_e( 'Share', 'dormatic' ); ?>
						<?php do_action( 'dormatic_blog_social' ); ?>
					</li>
					<?php endif; ?>
				</ul>
			</div>
		</div>
	</div>
</div>


<?php
// If comments are open or we have at least one comment, load up the comment template.
if ( comments_open() || get_comments_number() ) :
	comments_template();
endif;
