<?php
$blog_single_social = dormatic_get_options( 'blog_single_social' );
$post_thumb_class   = 'no-post-thumb';
if ( has_post_thumbnail() ) :
	$post_thumb_class = '';
endif;
	$is_sticky_class = '';
if ( is_sticky() ) :
	$is_sticky_class = 'sticky-post-class';
endif;
	$the_title_content    = get_the_title();
	$the_title_class_have = 'have-title-post';
if ( $the_title_content != '' ) :
	$the_title_class_have = '';
endif;
?>



<div class="news-block-one <?php echo esc_attr( $the_title_class_have . ' ' . $post_thumb_class . ' ' . $is_sticky_class ); ?>">
<div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<div class="inner-box">
		<?php
		if ( is_sticky() ) {
			echo '<div class="sticky_post_icon " title="' . esc_attr__( 'Sticky Post', 'dormatic' ) . '"><i class="fas fa-map-pin"></i></div>';
		}
		?>
		<?php if ( has_post_thumbnail() ) { ?>
		<figure class="image-box">
			<?php the_post_thumbnail(); ?>
		</figure>
		<?php } ?>
		<div class="lower-content">
			<div class="inner">
				<ul class="post-meta clearfix">
					<li><?php dormatic_category_list(); ?></li>
					<li class="admin"><i class="far fa-user"></i> <?php dormatic_posted_by(); ?></li>
					<li><i class="far fa-calendar-alt"></i><?php dormatic_posted_on(); ?></li>
					<li><i class="fal fa-comments"></i><?php dormatic_comments_count(); ?></li>
				</ul>
				<?php
				the_title( '<h2><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
				?>
				<?php
				if ( ! empty( get_the_excerpt() ) ) :
					if ( get_option( 'rss_use_excerpt' ) ) {
						the_excerpt();
					} else {
						the_excerpt();
					}
					endif;
				?>
			<?php
				wp_link_pages(
					array(
						'before' => '<div class="page-links">',
						'after'  => '</div>',
					)
				);
				?>
			</div>
			<div class="post-info">
				<ul class="info clearfix">
					<li class="link pull-left"><a href="<?php echo esc_url( get_permalink() ); ?>"><?php esc_html_e( 'Read More', 'dormatic' ); ?></a></li>
					<?php if ( $blog_single_social == '1' ) : ?>
					<li class="share pull-right">
						<i class="far fa-share"></i>
						<?php esc_html_e( 'Share', 'dormatic' ); ?>
						<?php do_action( 'dormatic_blog_social' ); ?>
					</li>
					<?php endif; ?>
				</ul>
			</div>
		</div>
	</div>
</div>
</div>
