<?php
$blog_single_social = dormatic_get_options( 'blog_single_social' );
?>
<div class="col-lg-4 col-md-6 col-sm-12 news-block">
	<div class="news-block-one">
		<div class="inner-box">
			<?php if ( has_post_thumbnail() ) { ?>
			<figure class="image-box">
				<?php the_post_thumbnail( 'dormatic-blog-grid' ); ?>
				<a href="<?php echo esc_url( get_permalink() ); ?>"><?php esc_html_e( 'Read More', 'dormatic' ); ?></a>
			</figure>
			<?php } ?>
			<div class="lower-content">
				<div class="inner">
					<ul class="post-meta clearfix">
						<li><?php dormatic_category_list(); ?></li>
						<li><i class="far fa-calendar-alt"></i><?php dormatic_posted_by(); ?></li>
						<li><i class="fal fa-comments"></i><?php echo get_comments_number(); ?></li>
					</ul>
					<?php
					the_title( '<h3><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h3>' );
					?>
					<p>
				<?php
				$content = substr( get_the_excerpt(), 0, 60 );
				echo esc_html( $content . '.' );
				?>
				</p>
				</div>
				<div class="post-info">
					<ul class="info clearfix">
						<li><i class="far fa-user"></i><?php dormatic_posted_by(); ?></li>
						<?php if ( $blog_single_social == '1' ) : ?>
						<li class="share">
							<i class="far fa-share"></i>
							<?php esc_html_e( 'Share', 'dormatic' ); ?>
							<?php do_action( 'dormatic_blog_social' ); ?>
						</li>
						<?php endif; ?>
					</ul>
				</div>
			</div>
		</div>
	</div>
</div>
