<?php
/**
 * Functions which enhance the theme by hooking into WordPress
 *
 * @package dormatic
 */

/**
 * Adds custom classes to the array of body classes.
 *
 * @param  array $classes Classes for the body element.
 * @return array
 */
function dormatic_body_classes( $classes ) {

	$theme_base_css       = dormatic_get_options( 'theme_base_css' );
	$theme_base_css_class = 'base-theme';
	if ( $theme_base_css == 1 ) :
		$theme_base_css_class = '';
	endif;

	$classes[] = $theme_base_css_class;

	return $classes;
}
add_filter( 'body_class', 'dormatic_body_classes' );

/**
 * Add a pingback url auto-discovery header for single posts, pages, or attachments.
 */
function dormatic_pingback_header() {
	if ( is_singular() && pings_open() ) {
		printf( '<link rel="pingback" href="%s">', esc_url( get_bloginfo( 'pingback_url' ) ) );
	}
}
add_action( 'wp_head', 'dormatic_pingback_header' );
/**
 * Add kses wp.
 */
function dormatic_kses_allowed_html( $dormatic_tags, $dormatic_context ) {
	switch ( $dormatic_context ) {
		case 'dormatic_kses':
			$dormatic_tags = array(
				'div'    => array(
					'class' => array(),
				),
				'ul'     => array(
					'class' => array(),
				),
				'li'     => array(),
				'span'   => array(
					'class' => array(),
				),
				'a'      => array(
					'href'  => array(),
					'class' => array(),
					'target' => array(),
				),
				'i'      => array(
					'class' => array(),
				),
				'p'      => array(),
				'em'     => array(),
				'br'     => array(),
				'strong' => array(),
				'h1'     => array(),
				'h2'     => array(),
				'h3'     => array(),
				'h4'     => array(),
				'h5'     => array(),
				'h6'     => array(),
				'del'    => array(),
				'ins'    => array(),
			);
			return $dormatic_tags;
		case 'dormatic_img':
			$dormatic_tags = array(
				'img' => array(
					'class'  => array(),
					'height' => array(),
					'width'  => array(),
					'src'    => array(),
					'alt'    => array(),
				),
			);
			return $dormatic_tags;
		default:
			return $dormatic_tags;

	}
}

add_filter( 'wp_kses_allowed_html', 'dormatic_kses_allowed_html', 10, 2 );



