<?php
$header_button_text = dormatic_get_options( 'header_button_text' );
$header_button_url  = dormatic_get_options( 'header_button_url' );

$header_address   = dormatic_get_options( 'header_address' );
$header_hours     = dormatic_get_options( 'header_hours' );
$header_phone     = dormatic_get_options( 'header_phone' );
$header_social    = dormatic_get_options( 'header_social' );
$header_language  = dormatic_get_options( 'header_language' );
$header_currency  = dormatic_get_options( 'header_currency' );
$sticky_header_on = dormatic_get_options( 'sticky_header_on' );

?>

<header class="main-header style-one">
	<!-- header-top -->
	<div class="header-top">
		<div class="auto-container">
			<div class="top-inner clearfix">
				<ul class="info pull-left clearfix">
					<li><i class="fal fa-map-marker-alt"></i><?php echo esc_html( $header_address ); ?></li>
					<li><i class="far fa-clock"></i><?php echo esc_html( $header_hours ); ?></li>
				</ul>
				<div class="right-column pull-right clearfix">
					<?php if ( $header_social ) : ?>
					<ul class="social-links clearfix">
						<?php echo wp_kses( $header_social, 'dormatic_kses' ); ?>
					</ul>
					<?php endif; ?>
					<div class="dropdown-box clearfix">
						<?php if ( $header_language ) : ?>
						<div class="language">
							<?php echo wp_kses( $header_language, 'dormatic_kses' ); ?>
						</div>
						<?php endif; ?>
						<?php if ( $header_currency ) : ?>
						<div class="money-box">
							<?php echo wp_kses( $header_currency, 'dormatic_kses' ); ?>
						</div>
						<?php endif; ?>
					</div>
				</div>
			</div>
		</div>
	</div>

	<!-- header-lower -->
	<div class="auto-container">
		<div class="header-lower">
			<div class="outer-box clearfix">
				<?php do_action( 'dormatic_header_logo' ); ?>
				<div class="menu-area pull-right clearfix">
					<!--Mobile Navigation Toggler-->
					<div class="mobile-nav-toggler">
						<i class="icon-bar"></i>
						<i class="icon-bar"></i>
						<i class="icon-bar"></i>
					</div>
					<?php do_action( 'dormatic_header_menu' ); ?>
					<div class="menu-right-content clearfix">
						<?php do_action( 'dormatic_search_popup' ); ?>
						<?php if ( $header_button_text && $header_button_url ) : ?>
						<div class="btn-box">
							<a href="<?php echo esc_url( $header_button_url ); ?>" class="theme-btn-one"><span class="btn-shape"></span><?php echo esc_html( $header_button_text ); ?></a>
						</div>
						<?php endif; ?>
					</div>
				</div>
			</div>
		</div>
	</div>

	<!--sticky Header-->
	<?php if ( $sticky_header_on ) : ?>
	<div class="sticky-header">
		<div class="auto-container">
			<div class="outer-box clearfix">
				<?php do_action( 'dormatic_header_logo_sticky' ); ?>
				<div class="menu-area pull-right">
					<nav class="main-menu clearfix">
						<!--Keep This Empty / Menu will come through Javascript-->
					
					</nav>
					<div class="menu-right-content clearfix">
						<?php do_action( 'dormatic_search_popup_sticky' ); ?>
						<?php if ( $header_button_text && $header_button_url ) : ?>
						<div class="btn-box">
							<a href="<?php echo esc_url( $header_button_url ); ?>" class="theme-btn-one"><span class="btn-shape"></span><?php echo esc_html( $header_button_text ); ?></a>
						</div>
						<?php endif; ?>
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php endif; ?>
</header>
