<?php
$header_button_text = dormatic_get_options( 'header_button_text' );
$header_button_url  = dormatic_get_options( 'header_button_url' );

$header_address   = dormatic_get_options( 'header_address' );
$header_hours     = dormatic_get_options( 'header_hours' );
$header_phone     = dormatic_get_options( 'header_phone' );
$header_social    = dormatic_get_options( 'header_social' );
$sticky_header_on = dormatic_get_options( 'sticky_header_on' );

?>

<header class="main-header style-two">
	<!-- header-top -->
	<?php if ( $header_phone || $header_hours || $header_social ) { ?>
	<div class="header-top">
		<div class="auto-container">
			<div class="top-inner clearfix">
				<div class="phone-box pull-left">
					<p><i class="far fa-phone"></i><?php echo wp_kses( $header_phone, 'dormatic_kses' ); ?></p>
				</div>
				<div class="right-column pull-right clearfix">
					<div class="single-box">
						<p><i class="far fa-clock"></i><?php echo esc_html( $header_hours ); ?></p>
					</div>
					<?php if ( $header_social ) : ?>
					<div class="single-box">
						<ul class="social-links clearfix">
							<?php echo wp_kses( $header_social, 'dormatic_kses' ); ?>
						</ul>
					</div>
					<?php endif; ?>
					<div class="single-box">
					<?php do_action( 'dormatic_search_popup' ); ?>
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php } ?>
	<!-- header-lower -->
	<div class="auto-container">
		<div class="header-lower">
			<div class="outer-box clearfix">
				<?php do_action( 'dormatic_header_logo' ); ?>
				<div class="menu-area pull-right clearfix">
					<!--Mobile Navigation Toggler-->
					<div class="mobile-nav-toggler">
						<i class="icon-bar"></i>
						<i class="icon-bar"></i>
						<i class="icon-bar"></i>
					</div>
					<?php do_action( 'dormatic_header_menu' ); ?>
					<div class="menu-right-content clearfix">
						<?php if ( $header_button_text && $header_button_url ) : ?>
						<div class="btn-box">
							<i class="icon-icon11"></i>
							<a href="<?php echo esc_url( $header_button_url ); ?>" class="theme-btn-one"><span class="btn-shape"></span><?php echo esc_html( $header_button_text ); ?></a>
						</div>
						<?php endif; ?>
					</div>
				</div>
			</div>
		</div>
	</div>

	<!--sticky Header-->
	<?php if ( $sticky_header_on ) : ?>
	<div class="sticky-header">
		<div class="auto-container">
			<div class="outer-box clearfix">
				<?php do_action( 'dormatic_header_logo_sticky' ); ?>
				<div class="menu-area pull-right">
					<nav class="main-menu clearfix">
						<!--Keep This Empty / Menu will come through Javascript-->
					
					</nav>
					<div class="menu-right-content clearfix">
						<?php do_action( 'dormatic_search_popup_sticky' ); ?>
						<?php if ( $header_button_text && $header_button_url ) : ?>
						<div class="btn-box">
							<a href="<?php echo esc_url( $header_button_url ); ?>" class="theme-btn-one"><span class="btn-shape"></span><?php echo esc_html( $header_button_text ); ?></a>
						</div>
						<?php endif; ?>
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php endif; ?>
</header>
