<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package dormatic
 */

get_header();
?>

<section class="error-section centred">
	<div class="auto-container">
		<div class="inner-box">
			<h1><?php esc_html_e( '404', 'dormatic' ); ?></h1>
			<h2><?php esc_html_e( 'Oops! That page can’t be found.', 'dormatic' ); ?></h2>
			<a href="<?php echo get_home_url(); ?>" class="theme-btn-one"><?php esc_html_e( 'Go Back Home', 'dormatic' ); ?></a>
		</div>
	</div>
</section>

<?php
get_footer();
