<?php
namespace dormatic\Helper\Posttype;

class Service {

	/**
	 * Initialize the class
	 */
	function __construct() {
		// Register the post type
		add_action( 'init', array( $this, 'dormatic_services_post_type' ), 0 );
	}

	// Register Custom Post Type
	function dormatic_services_post_type() {

		$labels = array(
			'name'                  => _x( 'Services', 'Post Type General Name', 'dormatic-core' ),
			'singular_name'         => _x( 'Services', 'Post Type Singular Name', 'dormatic-core' ),
			'menu_name'             => __( 'Services', 'dormatic-core' ),
			'name_admin_bar'        => __( 'Services', 'dormatic-core' ),
			'archives'              => __( 'Item Archives', 'dormatic-core' ),
			'parent_item_colon'     => __( 'Parent Item:', 'dormatic-core' ),
			'all_items'             => __( 'All Service', 'dormatic-core' ),
			'add_new_item'          => __( 'Add New Service', 'dormatic-core' ),
			'add_new'               => __( 'Add New Service', 'dormatic-core' ),
			'new_item'              => __( 'New Service Item', 'dormatic-core' ),
			'edit_item'             => __( 'Edit Service Item', 'dormatic-core' ),
			'update_item'           => __( 'Update Service Item', 'dormatic-core' ),
			'view_item'             => __( 'View Service Item', 'dormatic-core' ),
			'search_items'          => __( 'Search Item', 'dormatic-core' ),
			'not_found'             => __( 'Not found', 'dormatic-core' ),
			'not_found_in_trash'    => __( 'Not found in Trash', 'dormatic-core' ),
			'featured_image'        => __( 'Featured Image', 'dormatic-core' ),
			'set_featured_image'    => __( 'Set featured image', 'dormatic-core' ),
			'remove_featured_image' => __( 'Remove featured image', 'dormatic-core' ),
			'use_featured_image'    => __( 'Use as featured image', 'dormatic-core' ),
			'insert_into_item'      => __( 'Insert into item', 'dormatic-core' ),
			'uploaded_to_this_item' => __( 'Uploaded to this item', 'dormatic-core' ),
			'items_list'            => __( 'Items list', 'dormatic-core' ),
			'items_list_navigation' => __( 'Items list navigation', 'dormatic-core' ),
			'filter_items_list'     => __( 'Filter items list', 'dormatic-core' ),
		);

		$args = array(
			'labels'             => $labels,
			'description'        => __( 'Description.', 'dormatic-core' ),
			'public'             => true,
			'publicly_queryable' => true,
			'taxonomies'         => array( 'taxonomy_service' ),
			'show_ui'            => true,
			'show_in_menu'       => true,
			'query_var'          => true,
			'rewrite'            => array( 'slug' => 'service' ),
			'capability_type'    => 'post',
			'has_archive'        => true,
			'hierarchical'       => false,
			'menu_position'      => null,
			'supports'           => array( 'title', 'editor', 'thumbnail' ),
		);

		register_post_type( 'service', $args );
	}
}
