<?php
namespace Dormatic\Helper\Elementor\Widgets;

use Elementor\Utils;
use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use Elementor\Plugin;
use \Elementor\Repeater;

class Dormatic_Works extends Widget_Base {

	public function get_name() {
		return 'dormatic_works';
	}

	public function get_title() {
		return esc_html__( 'Dormatic Works', 'dormatic' );
	}

	public function get_icon() {
		return 'sds-widget-ico';
	}

	public function get_categories() {
		return array( 'Dormatic' );
	}

	protected function register_controls() {

		$this->start_controls_section(
			'general',
			array(
				'label' => esc_html__( 'general', 'dormatic' ),
			)
		);
		$this->add_control(
			'layout_type',
			array(
				'label'   => esc_html__( 'Layout Type', 'dormatic-core' ),
				'type'    => Controls_Manager::SELECT,
				'options' => array(
					'grid'   => esc_html__( 'Grid', 'dormatic-core' ),
					'slider' => esc_html__( 'Slider', 'dormatic-core' ),
				),
				'default' => 'grid',
			)
		);
		$this->add_control(
			'tagline',
			array(
				'label'   => esc_html__( 'Tagline', 'dormatic' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'Garage Door installation & Repair', 'dormatic' ),
			)
		);

		$this->add_control(
			'heading',
			array(
				'label'   => esc_html__( 'Heading', 'dormatic' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'How Dormatic Works', 'dormatic' ),
			)
		);

		$this->add_control(
			'header_size',
			[
				'label' => esc_html__( 'HTML Tag', 'elementor' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'h1' => 'H1',
					'h2' => 'H2',
					'h3' => 'H3',
					'h4' => 'H4',
					'h5' => 'H5',
					'h6' => 'H6',
				],
				'default' => 'h2',
			]
		);

		$this->add_control(
			'sub_heading',
			array(
				'label'       => esc_html__( 'Sub Heading', 'dormatic' ),
				'type'        => Controls_Manager::TEXTAREA,
				'rows'        => 6,
				'default'     => __( 'Nunc quam ar pretium quis lobortis sequat consetetur diam bibend ipsum dolor ', 'dormatic' ),
				'placeholder' => esc_html__( 'Type your description here', 'dormatic' ),

			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'item',
			array(
				'label' => esc_html__( 'item', 'dormatic' ),
			)
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'item_title',
			array(
				'label'   => esc_html__( 'Title', 'dormatic' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'Book Your Appointment Online or Via Phone', 'dormatic' ),
			)
		);

		$repeater->add_control(
			'item_content',
			array(
				'label'       => esc_html__( 'Content', 'dormatic' ),
				'type'        => Controls_Manager::TEXTAREA,
				'rows'        => 6,
				'default'     => __( 'Quam pretium quis quam sed ipsum afficits liquam sed volutpat lobor tisem amet', 'dormatic' ),
				'placeholder' => esc_html__( 'Type your description here', 'dormatic' ),

			)
		);

		$repeater->add_control(
			'item_icon',
			array(
				'label' => esc_html__( 'Icon', 'dormatic' ),
				'type'  => Controls_Manager::ICONS,
			)
		);

		$this->add_control(
			'items',
			array(
				'label'   => esc_html__( 'Repeater List', 'dormatic' ),
				'type'    => Controls_Manager::REPEATER,
				'fields'  => $repeater->get_controls(),
				'default' => array(
					array(
						'list_title'   => esc_html__( 'Title #1', 'dormatic' ),
						'list_content' => esc_html__( 'Item content. Click the edit button to change this text.', 'dormatic' ),
					),
					array(
						'list_title'   => esc_html__( 'Title #2', 'dormatic' ),
						'list_content' => esc_html__( 'Item content. Click the edit button to change this text.', 'dormatic' ),
					),
				),
			)
		);

		$this->end_controls_section();

		// Typography Section

		$this->start_controls_section(
			'typography_section',
			array(
				'label' => __( 'Typography Section', 'elementor' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'     => 'tagline_typography',
				'label'    => __( 'Tagline', 'elementor' ),
				'selector' => '{{WRAPPER}} .sec-title span',
			)
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'     => 'heading_typography',
				'label'    => __( 'Heading', 'prunelementorers' ),
				'selector' => '{{WRAPPER}} .sec-title h2',
			)
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'     => 'short_desc_typography',
				'label'    => __( 'Short Description', 'elementor' ),
				'selector' => '{{WRAPPER}} .sec-title p',
			)
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'     => 'item_title_typography',
				'label'    => __( 'Item Title', 'elementor' ),
				'selector' => '{{WRAPPER}} .work-block-one .inner-box h3',
			)
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'     => 'item_subtitle_typography',
				'label'    => __( 'Item Subtitle', 'elementor' ),
				'selector' => '{{WRAPPER}} .work-block-one .inner-box p',
			)
		);
		$this->end_controls_section();

		// color_section
		$this->start_controls_section(
			'color_section',
			array(
				'label' => __( 'Color Section', 'elementor' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);
		$this->start_controls_tabs( 'tabs_button_style' );
		$this->start_controls_tab(
			'tab_button_normal',
			array(
				'label' => __( 'Normal', 'elementor' ),
			)
		);

		$this->add_control(
			'icon_color',
			array(
				'label'     => __( 'Icon Color', 'elementor' ),
				'separator' => 'before',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .work-block-one .inner-box .icon-box' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'icon_bg_color',
			array(
				'label'     => __( 'Icon BG Color', 'elementor' ),
				'separator' => 'before',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .work-block-one .inner-box .icon-box' => 'background-color: {{VALUE}}',
				),
			)
		);

		$this->end_controls_tab();
		$this->start_controls_tab(
			'tab_button_hover',
			array(
				'label' => __( 'Hover', 'elementor' ),
			)
		);

		$this->add_control(
			'icon_hover_color',
			array(
				'label'     => __( 'Icon Hover Color', 'elementor' ),
				'separator' => 'before',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .work-block-one .inner-box:hover .icon-box' => 'color: {{VALUE}}',
				),
			)
		);

		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();

	}
	protected function render() {
		$settings            = $this->get_settings_for_display();
		$layout_type         = $settings['layout_type'];
		$tagline             = $settings['tagline'];
				$heading     = $settings['heading'];
				$heading_html = sprintf( '<%1$s %2$s>%3$s</%1$s>', Utils::validate_html_tag( $settings['header_size'] ), $this->get_render_attribute_string( 'heading' ), $heading );
				$sub_heading = $settings['sub_heading'];
		?>
		<?php if ( $layout_type == 'grid' ) { ?>
		<section class="works-section centred">
			<div class="auto-container">
			<?php if ( ! empty( $tagline ) || ! empty( $heading ) || ! empty( $sub_heading ) ) { ?>
				<div class="sec-title">
					<span><?php echo $tagline; ?></span>
					<?php echo $heading_html; ?>
					<p><?php echo $sub_heading; ?></p>
				</div>
			<?php } ?>
				<div class="row clearfix">
							<?php
							$i = 1;
							foreach ( $settings['items'] as $item ) {
								$item_title   = $item['item_title'];
								$item_content = $item['item_content'];
								$item_icon    = $item['item_icon'];
								?>
							<div class="col-lg-4 col-md-6 col-sm-12 work-block">
								<div class="work-block-one">
									<div class="inner-box">
									<div class="arrow" style="background-image: url(<?php echo DORMATIC_IMG_URL; ?>/icons/arrow-1.png);"></div>
									<div class="icon-box">
										<div class="shape"></div>
																	<?php \Elementor\Icons_Manager::render_icon( ( $item_icon ), array( 'aria-hidden' => 'true' ) ); ?>
										<span>0<?php echo $i; ?></span>
									</div>
									<h3><?php echo $item_title; ?></h3>
									<p><?php echo $item_content; ?></p>
									</div>
								</div>
							</div> 
					<?php $i++; } ?> 			
				</div>
			</div>
		</section>
		<?php } elseif ( $layout_type == 'slider' ) { ?>
			<section class="works-section centred">
			<div class="auto-container">
			<?php if ( ! empty( $tagline ) || ! empty( $heading ) || ! empty( $sub_heading ) ) { ?>
				<div class="sec-title">
					<span><?php echo $tagline; ?></span>
					<?php echo $heading_html; ?>
					<p><?php echo $sub_heading; ?></p>
				</div>
			<?php } ?>
				<div class="three-item-carousel owl-carousel owl-theme owl-dots-none owl-nav-none">
							<?php
							$i = 1;
							foreach ( $settings['items'] as $item ) {
								$item_title   = $item['item_title'];
								$item_content = $item['item_content'];
								$item_icon    = $item['item_icon'];
								?>
								<div class="work-block-one">
									<div class="inner-box">
									<div class="arrow" style="background-image: url(<?php echo DORMATIC_IMG_URL; ?>/icons/arrow-1.png);"></div>
									<div class="icon-box">
										<div class="shape"></div>
																	<?php \Elementor\Icons_Manager::render_icon( ( $item_icon ), array( 'aria-hidden' => 'true' ) ); ?>
										<span>0<?php echo $i; ?></span>
									</div>
									<h3><?php echo $item_title; ?></h3>
									<p><?php echo $item_content; ?></p>
									</div>
								</div>
					<?php $i++; } ?> 			
				</div>
			</div>
		</section>
			<?php
		}
	}

	protected function content_template() {
	}
}
