<?php
namespace Dormatic\Helper\Elementor\Widgets;

use Elementor\Utils;
use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use Elementor\Plugin;
use \Elementor\Repeater;

class Dormatic_Why_Choose_Us extends Widget_Base {

	public function get_name() {
		return 'dormatic_why_choose_us';
	}

	public function get_title() {
		return esc_html__( 'Dormatic Why Choose Us', 'dormatic' );
	}

	public function get_icon() {
		return 'sds-widget-ico';
	}

	public function get_categories() {
		return array( 'Dormatic' );
	}

	protected function register_controls() {

		$this->start_controls_section(
			'general',
			array(
				'label' => esc_html__( 'general', 'dormatic' ),
			)
		);
		$this->add_control(
			'layout_style',
			array(
				'label'   => esc_html__( 'Layout Style', 'dormatic-core' ),
				'type'    => Controls_Manager::SELECT,
				'options' => array(
					'style_1' => esc_html__( 'Style One', 'dormatic-core' ),
					'style_2' => esc_html__( 'Style Two', 'dormatic-core' ),
				),
				'default' => 'style_1',
			)
		);
		$this->add_control(
			'tagline',
			array(
				'label'   => esc_html__( 'Tagline', 'dormatic' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'Garage Door installation & Repair', 'dormatic' ),
			)
		);

		$this->add_control(
			'heading',
			array(
				'label'   => esc_html__( 'Heading', 'dormatic' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'Why People Trust And <br>Choose Dormatic', 'dormatic' ),
			)
		);

		$this->add_control(
			'header_size',
			[
				'label' => esc_html__( 'HTML Tag', 'elementor' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'h1' => 'H1',
					'h2' => 'H2',
					'h3' => 'H3',
					'h4' => 'H4',
					'h5' => 'H5',
					'h6' => 'H6',
				],
				'default' => 'h2',
			]
		);

		$this->add_control(
			'image',
			array(
				'label'   => esc_html__( 'Image', 'dormatic' ),
				'type'    => Controls_Manager::MEDIA,
				'default' => array(
					'url' => Utils::get_placeholder_image_src(),
				),

			)
		);

		$this->add_control(
			'number',
			array(
				'label'   => esc_html__( 'Number', 'dormatic' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( '25', 'dormatic' ),
			)
		);

		$this->add_control(
			'image_text',
			array(
				'label'   => esc_html__( 'Image Text', 'dormatic' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'years of <br>Smart Working experience', 'dormatic' ),
			)
		);

		$this->add_control(
			'background_shape',
			array(
				'label'   => esc_html__( 'Background Shape', 'dormatic' ),
				'type'    => Controls_Manager::MEDIA,
				'default' => array(
					'url' => Utils::get_placeholder_image_src(),
				),

			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'item',
			array(
				'label' => esc_html__( 'item', 'dormatic' ),
			)
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'item_title',
			array(
				'label'   => esc_html__( 'Title', 'dormatic' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'Quality Services', 'dormatic' ),
			)
		);

		$repeater->add_control(
			'item_image',
			array(
				'label'   => esc_html__( 'Image', 'dormatic' ),
				'type'    => Controls_Manager::MEDIA,
				'default' => array(
					'url' => Utils::get_placeholder_image_src(),
				),

			)
		);

		$repeater->add_control(
			'item_content',
			array(
				'label'       => esc_html__( 'Content', 'dormatic' ),
				'type'        => Controls_Manager::TEXTAREA,
				'rows'        => 6,
				'default'     => __( 'Kaoreet efficitur aliquam volut consequat sed imperdiet', 'dormatic' ),
				'placeholder' => esc_html__( 'Type your description here', 'dormatic' ),

			)
		);

		$repeater->add_control(
			'item_url',
			array(
				'label'         => esc_html__( 'URL', 'dormatic' ),
				'type'          => Controls_Manager::URL,
				'placeholder'   => esc_html__( 'https://your-link.com', 'dormatic' ),
				'show_external' => true,
				'default'       => array(
					'url'         => '',
					'is_external' => true,
					'nofollow'    => true,
				),

			)
		);

		$this->add_control(
			'items',
			array(
				'label'   => esc_html__( 'Repeater List', 'dormatic' ),
				'type'    => Controls_Manager::REPEATER,
				'fields'  => $repeater->get_controls(),
				'default' => array(
					array(
						'list_title'   => esc_html__( 'Title #1', 'dormatic' ),
						'list_content' => esc_html__( 'Item content. Click the edit button to change this text.', 'dormatic' ),
					),
					array(
						'list_title'   => esc_html__( 'Title #2', 'dormatic' ),
						'list_content' => esc_html__( 'Item content. Click the edit button to change this text.', 'dormatic' ),
					),
				),
			)
		);

		$this->end_controls_section();

		// Typography Section

		$this->start_controls_section(
			'typography_section',
			array(
				'label' => __( 'Typography Section', 'elementor' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'     => 'tagline_typography',
				'label'    => __( 'Tagline', 'elementor' ),
				'selector' => '{{WRAPPER}} .sec-title span',
			)
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'     => 'heading_typography',
				'label'    => __( 'Heading', 'elementor' ),
				'selector' => '{{WRAPPER}} .sec-title h2',
			)
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'     => 'title_typography',
				'label'    => __( 'Item Title', 'elementor' ),
				'selector' => '{{WRAPPER}} .chooseus-block-one .inner-box h3,{{WRAPPER}} .feature-block-four .inner-box h3',
			)
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'     => 'subtitle_typography',
				'label'    => __( 'Item Sub Title', 'elementor' ),
				'selector' => '{{WRAPPER}} p',
			)
		);
		$this->end_controls_section();

		// color_section
		$this->start_controls_section(
			'color_section',
			array(
				'label' => __( 'Color Section', 'elementor' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);
		$this->start_controls_tabs( 'tabs_button_style' );
		$this->start_controls_tab(
			'tab_button_normal',
			array(
				'label' => __( 'Normal', 'elementor' ),
			)
		);
		$this->add_control(
			'number_color',
			array(
				'label'     => __( 'Number Color', 'elementor' ),
				'separator' => 'before',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .content_block_2 .content-box .inner-box .text h2 ' => 'color: {{VALUE}}',
					'{{WRAPPER}} .feature-style-four .image-box .image-content .inner h2 ' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'item_bg_color',
			array(
				'label'     => __( ' Item BG Color', 'elementor' ),
				'separator' => 'before',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .chooseus-block-one .inner-box .icon-box ' => 'background: {{VALUE}}',
					'{{WRAPPER}} .feature-block-four .inner-box .icon-box' => 'background: {{VALUE}}',
				),
			)
		);

		$this->end_controls_tab();
		$this->start_controls_tab(
			'tab_button_hover',
			array(
				'label' => __( 'Hover', 'elementor' ),
			)
		);

		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();
	}
	protected function render() {
		$settings      = $this->get_settings_for_display();
		$layout_style  = $settings['layout_style'];
		$tagline       = $settings['tagline'];
			$heading   = $settings['heading'];
			$heading_html = sprintf( '<%1$s %2$s>%3$s</%1$s>', Utils::validate_html_tag( $settings['header_size'] ), $this->get_render_attribute_string( 'heading' ), $heading );
			$image     = ( $settings['image']['id'] != '' ) ? wp_get_attachment_image( $settings['image']['id'], 'full' ) : $settings['image']['url'];
			$image_url = ( $settings['image']['id'] != '' ) ? wp_get_attachment_image_url( $settings['image']['id'], 'full' ) : $settings['image']['url'];
			$image_alt = get_post_meta( $settings['image']['id'], '_wp_attachment_image_alt', true );

			$number               = $settings['number'];
			$image_text           = $settings['image_text'];
			$background_shape     = ( $settings['background_shape']['id'] != '' ) ? wp_get_attachment_image( $settings['background_shape']['id'], 'full' ) : $settings['background_shape']['url'];
			$background_shape_url = ( $settings['background_shape']['id'] != '' ) ? wp_get_attachment_image_url( $settings['background_shape']['id'], 'full' ) : $settings['background_shape']['url'];
			$background_shape_alt = get_post_meta( $settings['background_shape']['id'], '_wp_attachment_image_alt', true );
		?>
		<?php if ( $layout_style == 'style_1' ) { ?>
	<section class="chooseus-section">
	<figure class="icon-layer">
			<?php
			if ( wp_http_validate_url( $background_shape ) ) {
				?>
							<img src="<?php echo esc_url( $background_shape ); ?>" alt="<?php esc_attr( $background_shape_alt ); ?>">
				<?php
			} else {
				echo $background_shape;
			}
			?>
	</figure>
	<div class="auto-container">
		<div class="sec-title">
			<span><?php echo $tagline; ?></span>
			<?php echo $heading_html; ?>
		</div>
		<div class="row clearfix">
			<div class="col-lg-4 col-md-12 col-sm-12 content-column">
				<div class="content_block_2">
					<div class="content-box">
						<div class="inner-box" style="background-image: url(<?php echo $image_url; ?>);">
							<div class="text">
								<h2><?php echo $number; ?></h2>
								<h5><?php echo $image_text; ?></h5>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="col-lg-8 col-md-12 col-sm-12 inner-column">
				<div class="inner-content">
					<div class="row clearfix">
			<?php
				$i = 1;
			foreach ( $settings['items'] as $item ) {
				$item_title        = $item['item_title'];
				$item_image        = ( $item['item_image']['id'] != '' ) ? wp_get_attachment_image( $item['item_image']['id'], 'full' ) : $item['item_image']['url'];
				$item_image_alt    = get_post_meta( $item['item_image']['id'], '_wp_attachment_image_alt', true );
				$item_content      = $item['item_content'];
				$item_url          = $item['item_url']['url'];
				$item_url_external = $item['item_url']['is_external'] ? 'target="_blank"' : '';
				$item_url_nofollow = $item['item_url']['nofollow'] ? 'rel="nofollow"' : '';
				?>
					  <div class="col-lg-4 col-md-6 col-sm-12 chooseus-block">
						<div class="chooseus-block-one">
							<div class="inner-box">
							<figure class="icon-box">
									<?php
									if ( wp_http_validate_url( $item_image ) ) {
										?>
									<img src="<?php echo esc_url( $item_image ); ?>" alt="<?php esc_attr( $item_image_alt ); ?>">
															<?php
									} else {
										echo $item_image;
									}
									?>
								<div class="icon-shape"></div>
							</figure>
							<h3><a href="<?php echo esc_attr( $item_url ); ?>" <?php echo $item_url_external; ?> <?php echo $item_url_nofollow; ?> ><?php echo $item_title; ?></a></h3>							
							<p><?php echo $item_content; ?></p>
							</div>
						</div>
					</div> 
					<?php $i++; } ?> 				
					</div>
				</div>
			</div>
		</div>
	</div>
</section> 
<?php } elseif ( $layout_style == 'style_2' ) { ?>

<section class="feature-style-four bg-color-1">
	<div class="pattern-layer" style="background-image: url(<?php echo $background_shape_url; ?>);"></div>
	<div class="image-box">
		<figure class="image">
			<?php
			if ( wp_http_validate_url( $image ) ) {
				?>
							<img src="<?php echo esc_url( $image ); ?>" alt="<?php esc_attr( $image_alt ); ?>">
				<?php
			} else {
				echo $image;
			}
			?>
		</figure>
		<div class="image-content">
			<div class="inner">
				<h2><?php echo $number; ?></h2>
				<h5><?php echo $image_text; ?></h5>
			</div>
		</div>
	</div>
	<div class="outer-container">
		<div class="row clearfix">
			<div class="col-xl-7 col-lg-12 col-md-12 content-column">
				<div class="content_block_7">
					<div class="content-box">
						<div class="sec-title light">
						<span><?php echo $tagline; ?></span>
						<?php echo $heading_html; ?>
						</div>
						<div class="row clearfix">
						<?php
						$i = 1;
						foreach ( $settings['items'] as $item ) {
							$item_title        = $item['item_title'];
							$item_image        = ( $item['item_image']['id'] != '' ) ? wp_get_attachment_image( $item['item_image']['id'], 'full' ) : $item['item_image']['url'];
							$item_image_alt    = get_post_meta( $item['item_image']['id'], '_wp_attachment_image_alt', true );
							$item_content      = $item['item_content'];
							$item_url          = $item['item_url']['url'];
							$item_url_external = $item['item_url']['is_external'] ? 'target="_blank"' : '';
							$item_url_nofollow = $item['item_url']['nofollow'] ? 'rel="nofollow"' : '';
							?>
							<div class="col-lg-6 col-md-6 col-sm-12 feature-block">
								<div class="feature-block-four">
									<div class="inner-box">
										<figure class="icon-box">
										<?php
										if ( wp_http_validate_url( $item_image ) ) {
											?>
															<img src="<?php echo esc_url( $item_image ); ?>" alt="<?php esc_attr( $item_image_alt ); ?>">
																<?php
										} else {
											echo $item_image;
										}
										?>
										</figure>
										<h3><?php echo $item_title; ?></h3>
										<p><?php echo $item_content; ?></p>
										<div class="link"><a href="<?php echo $item_url; ?>" <?php echo $item_url_external; ?>  <?php echo $item_url_nofollow; ?>><i class="far fa-long-arrow-alt-right"></i></a></div>
									</div>
								</div>
							</div>
							<?php $i++; } ?>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>
			<?php
}
	}

	protected function content_template() {
	}
}
