<?php
namespace Dormatic\Helper\Elementor\Widgets;

use Elementor\Utils;
use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use Elementor\Plugin;
use \Elementor\Repeater;

class Dormatic_Servces_Two extends Widget_Base {

	public function get_name() {
		return 'dormatic_servces_two';
	}

	public function get_title() {
		return esc_html__( 'Dormatic Servces Two', 'dormatic' );
	}

	public function get_icon() {
		return 'sds-widget-ico';
	}

	public function get_categories() {
		return array( 'Dormatic' );
	}

	protected function register_controls() {

		$this->start_controls_section(
			'general',
			array(
				'label' => esc_html__( 'general', 'dormatic' ),
			)
		);

		$this->add_control(
			'tagline',
			array(
				'label'   => esc_html__( 'Tagline', 'dormatic' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'Garage Door installation & Repair', 'dormatic' ),
			)
		);

		$this->add_control(
			'heading',
			array(
				'label'   => esc_html__( 'Heading', 'dormatic' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'Fast & Professional Services We Offer', 'dormatic' ),
			)
		);

		$this->add_control(
			'header_size',
			[
				'label' => esc_html__( 'HTML Tag', 'elementor' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'h1' => 'H1',
					'h2' => 'H2',
					'h3' => 'H3',
					'h4' => 'H4',
					'h5' => 'H5',
					'h6' => 'H6',
				],
				'default' => 'h2',
			]
		);

		$this->add_control(
			'sub_heading',
			array(
				'label'       => esc_html__( 'Sub Heading', 'dormatic' ),
				'type'        => Controls_Manager::TEXTAREA,
				'rows'        => 6,
				'default'     => __( 'Aute irure dolor reprehenderit cepteur ocaecat cupidatate sed ipsum non proident int sunt indys sint sed ipsum culpa quis.', 'dormatic' ),
				'placeholder' => esc_html__( 'Type your description here', 'dormatic' ),

			)
		);

		$this->add_control(
			'background_shape',
			array(
				'label'   => esc_html__( 'Background Shape', 'dormatic' ),
				'type'    => Controls_Manager::MEDIA,
				'default' => array(
					'url' => Utils::get_placeholder_image_src(),
				),

			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'item',
			array(
				'label' => esc_html__( 'item', 'dormatic' ),
			)
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'item_title',
			array(
				'label'   => esc_html__( 'Title', 'dormatic' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'New Door Installation', 'dormatic' ),
			)
		);

		$repeater->add_control(
			'item_icon',
			array(
				'label' => esc_html__( 'Icon', 'dormatic' ),
				'type'  => Controls_Manager::ICONS,
			)
		);

		$repeater->add_control(
			'item_image',
			array(
				'label'   => esc_html__( 'Image', 'dormatic' ),
				'type'    => Controls_Manager::MEDIA,
				'default' => array(
					'url' => Utils::get_placeholder_image_src(),
				),

			)
		);
		$repeater->add_control(
			'item_service_currency',
			array(
				'label'   => esc_html__( 'Price Currency', 'dormatic' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( '$', 'dormatic' ),
			)
		);
		$repeater->add_control(
			'item_service_price',
			array(
				'label'   => esc_html__( 'Service Price', 'dormatic' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( '$70', 'dormatic' ),
			)
		);
		$repeater->add_control(
			'item_content',
			array(
				'label'       => esc_html__( 'Content', 'dormatic' ),
				'type'        => Controls_Manager::TEXTAREA,
				'rows'        => 6,
				'default'     => __( 'Sunt culpa qui officia deslys mollit anim est laborum. Sed perspiciatis un omnis iste natus error sit voluptatem.', 'dormatic' ),
				'placeholder' => esc_html__( 'Type your description here', 'dormatic' ),
			)
		);
		$repeater->add_control(
			'item_content_list',
			array(
				'label'       => esc_html__( 'Content List', 'dormatic' ),
				'type'        => Controls_Manager::TEXTAREA,
				'rows'        => 6,
				'placeholder' => esc_html__( 'Type your description here', 'dormatic' ),
			)
		);
		$repeater->add_control(
			'item_button_text',
			array(
				'label'   => esc_html__( 'Button Text', 'dormatic' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'Read More', 'dormatic' ),
			)
		);

		$repeater->add_control(
			'item_button_url',
			array(
				'label'         => esc_html__( 'Button URL', 'dormatic' ),
				'type'          => Controls_Manager::URL,
				'placeholder'   => esc_html__( 'https://your-link.com', 'dormatic' ),
				'show_external' => true,
				'default'       => array(
					'url'         => '',
					'is_external' => true,
					'nofollow'    => true,
				),

			)
		);

		$this->add_control(
			'items',
			array(
				'label'   => esc_html__( 'Repeater List', 'dormatic' ),
				'type'    => Controls_Manager::REPEATER,
				'fields'  => $repeater->get_controls(),
				'default' => array(
					array(
						'list_title'   => esc_html__( 'Title #1', 'dormatic' ),
						'list_content' => esc_html__( 'Item content. Click the edit button to change this text.', 'dormatic' ),
					),
					array(
						'list_title'   => esc_html__( 'Title #2', 'dormatic' ),
						'list_content' => esc_html__( 'Item content. Click the edit button to change this text.', 'dormatic' ),
					),
				),
			)
		);

		$this->end_controls_section();

		// Typography Section
		
        $this->start_controls_section(
            'typography_section',
            array(
                'label' => __('Typography Section', 'elementor'),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            )
        );

		$this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            array(
                'name'     => 'tagline_typography',
                'label'    => __('Tagline', 'elementor'),
                'selector' => '{{WRAPPER}} .sec-title span',
            )
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            array(
                'name'     => 'heading_typography',
                'label'    => __('Heading', 'prunelementorers'),
                'selector' => '{{WRAPPER}} .sec-title h2',
            )
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            array(
                'name'     => 'short_desc_typography',
                'label'    => __('Short Description', 'elementor'),
                'selector' => '{{WRAPPER}} .sec-title p',
            )
		);

		$this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            array(
                'name'     => 'item_title_typography',
                'label'    => __('Item Title', 'elementor'),
                'selector' => '{{WRAPPER}} .service-block-two .inner-box .content-box h2 a',
            )
		);

		$this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            array(
                'name'     => 'item_subtitle_typography',
                'label'    => __('Item Subtitle', 'elementor'),
                'selector' => '{{WRAPPER}} .service-block-two .inner-box .content-box p',
            )
        );
        $this->end_controls_section();

        // color_section
        $this->start_controls_section(
            'color_section',
            array(
                'label' => __('Color Section', 'elementor'),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            )
        );
        $this->start_controls_tabs('tabs_button_style');
        $this->start_controls_tab(
            'tab_button_normal',
            array(
                'label' => __('Normal', 'elementor'),
            )
		);
	
	
		$this->add_control(
			'icon_color',
			array(
				'label'     => __( 'Icon Color', 'elementor' ),
				'separator' => 'before',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .service-block-two .inner-box .content-box .icon-box' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
            'icon_bg_color',
            array(
                'label'     => __('Icon BG Color', 'elementor'),
                'separator' => 'before',
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => array(
                    '{{WRAPPER}} .service-block-two .inner-box .content-box .icon-box' => 'background-color: {{VALUE}}',
                ),
            )
        );
		
		$this->add_control(
            'button_bg_color',
            array(
                'label'     => __('Button BG Color', 'elementor'),
                'separator' => 'before',
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => array(
                    '{{WRAPPER}} .service-block-two .inner-box .content-box .btn-box .theme-btn-one' => 'background-color: {{VALUE}}',
                ),
            )
        );

		
        $this->end_controls_tab();
        $this->start_controls_tab(
            'tab_button_hover',
            array(
                'label' => __('Hover', 'elementor'),
            )
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();


	}
	protected function render() {
		$settings = $this->get_settings_for_display();

		$tagline              = $settings['tagline'];
			$heading          = $settings['heading'];
			$heading_html = sprintf( '<%1$s %2$s>%3$s</%1$s>', Utils::validate_html_tag( $settings['header_size'] ), $this->get_render_attribute_string( 'heading' ), $heading );
			$sub_heading      = $settings['sub_heading'];
			$background_shape = ( $settings['background_shape']['id'] != '' ) ? wp_get_attachment_image_url( $settings['background_shape']['id'], 'full' ) : $settings['background_shape']['url'];

		?> 

<section class="service-style-two bg-color-2">
	<div class="pattern-layer" style="background-image: url(<?php echo $background_shape; ?>);"></div>
	<div class="auto-container">
		<div class="sec-title centred">
			<span><?php echo $tagline; ?></span>
			<?php echo $heading_html; ?>
			<p><?php echo $sub_heading; ?></p>
		</div>
		<?php
				$i   = 1;
				$len = count( $settings['items'] );
		foreach ( $settings['items'] as $item ) {
			$item_title               = $item['item_title'];
			$item_icon                = $item['item_icon'];
			$item_image               = ( $item['item_image']['id'] != '' ) ? wp_get_attachment_image( $item['item_image']['id'], 'full' ) : $item['item_image']['url'];
			$item_image_alt           = get_post_meta( $item['item_image']['id'], '_wp_attachment_image_alt', true );
			$item_service_currency    = $item['item_service_currency'];
			$item_service_price       = $item['item_service_price'];
			$item_content             = $item['item_content'];
			$item_content_list        = $item['item_content_list'];
			$item_button_text         = $item['item_button_text'];
			$item_button_url          = $item['item_button_url']['url'];
			$item_button_url_external = $item['item_button_url']['is_external'] ? 'target="_blank"' : '';
			$item_button_url_nofollow = $item['item_button_url']['nofollow'] ? 'rel="nofollow"' : '';
			$class = 'mb-80';
			?>

		<div class="service-block-two <?php echo $class; ?>">
			<div class="inner-box">
				<div class="content-box">
					<div class="icon-box"><?php \Elementor\Icons_Manager::render_icon( ( $item_icon ), array( 'aria-hidden' => 'true' ) ); ?></div>
					<h2><a href="<?php echo esc_attr( $item_button_url ); ?>" <?php echo $item_button_url_external; ?>  <?php echo $item_button_url_nofollow; ?>><?php echo $item_title; ?></a></h2>
					<p><?php echo $item_content; ?></p>
					<ul class="list clearfix">
						<?php echo $item_content_list; ?>
					</ul>
					<div class="btn-box"><a href="<?php echo esc_attr( $item_button_url ); ?>" <?php echo $item_button_url_external; ?>  <?php echo $item_button_url_nofollow; ?> class="theme-btn-one"><span class="btn-shape"></span><?php echo $item_button_text; ?></a></div>
				</div>
				<div class="image-box">
					<figure class="image">
					<?php
					if ( wp_http_validate_url( $item_image ) ) {
						?>
						<img src="<?php echo esc_url( $item_image ); ?>" alt="<?php esc_attr( $item_image_alt ); ?>">
							<?php
					} else {
						echo $item_image;
					}
					?>
					</figure>
					<div class="image-content">
						<span class="icon"><?php echo $item_service_currency; ?></span>
						<h5><?php echo $item_service_price; ?></h5>
					</div>
				</div>
			</div>
		</div>
		<?php $i++; } ?> 
	</div>
</section>
			<?php

	}

	protected function content_template() {
	}
}
