<?php
namespace Dormatic\Helper\Elementor\Widgets;

use Elementor\Utils;
use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use Elementor\Plugin;
use \Elementor\Repeater;

class Dormatic_Servces extends Widget_Base {

	public function get_name() {
		return 'dormatic_servces';
	}

	public function get_title() {
					return esc_html__( 'Dormatic Servces', 'dormatic' );
	}

	public function get_icon() {
		return 'sds-widget-ico';
	}

	public function get_categories() {
		return array( 'Dormatic' );
	}

	protected function register_controls() {

		$this->start_controls_section(
			'general',
			array(
				'label' => esc_html__( 'general', 'dormatic' ),
			)
		);
		$this->add_control(
			'layout_style',
			array(
				'label'   => esc_html__( 'Layout Style', 'dormatic-core' ),
				'type'    => Controls_Manager::SELECT,
				'options' => array(
					'style_1' => esc_html__( 'Style One', 'dormatic-core' ),
					'style_2' => esc_html__( 'Style Two', 'dormatic-core' ),
				),
				'default' => 'style_1',
			)
		);
		
		$this->add_control(
			'col_no',
			array(
				'label'   => esc_html__( 'Columns', 'dormatic-core' ),
				'type'    => Controls_Manager::SELECT,
				'options' => array(
					'6' => esc_html__( '2', 'dormatic-core' ),
					'4' => esc_html__( '3', 'dormatic-core' ),
					'3' => esc_html__( '4', 'dormatic-core' ),
					'2' => esc_html__( '6', 'dormatic-core' ),
				),
				'default' => '4',
				'condition' => array(
					'layout_style' => 'style_2',
				),
			)
		);

		$this->add_control(
			'tagline',
			array(
				'label'   => esc_html__( 'Tagline', 'dormatic' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'Garage Door installation & Repair', 'dormatic' ),
			)
		);

		$this->add_control(
			'heading',
			array(
				'label'   => esc_html__( 'Heading', 'dormatic' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'Fast & Professional Services We Offer', 'dormatic' ),
			)
		);

		$this->add_control(
			'header_size',
			array(
				'label' => esc_html__( 'HTML Tag', 'elementor' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'h1' => 'H1',
					'h2' => 'H2',
					'h3' => 'H3',
					'h4' => 'H4',
					'h5' => 'H5',
					'h6' => 'H6',
				],
				'default' => 'h2',
			)
		);

		$this->add_control(
			'sub_heading',
			array(
				'label'       => esc_html__( 'Sub Heading', 'dormatic' ),
				'type'        => Controls_Manager::TEXTAREA,
				'rows'        => 6,
				'default'     => __( 'Aute irure dolor reprehenderit cepteur ocaecat cupidatate sed ipsum non proident int sunt indys sint sed ipsum culpa quis.', 'dormatic' ),
				'placeholder' => esc_html__( 'Type your description here', 'dormatic' ),

			)
		);

		$this->add_control(
			'bottom_content',
			array(
				'label'       => esc_html__( 'Bottom Content', 'dormatic' ),
				'type'        => Controls_Manager::TEXTAREA,
				'rows'        => 6,
				'default'     => __( 'Want Your Garage Door Repair or Installation? We’re Ready To Start!', 'dormatic' ),
				'placeholder' => esc_html__( 'Type your description here', 'dormatic' ),

			)
		);

		$this->add_control(
			'bottom_content_02',
			array(
				'label'       => esc_html__( 'Bottom Content 02', 'dormatic' ),
				'type'        => Controls_Manager::TEXTAREA,
				'rows'        => 6,
				'placeholder' => esc_html__( 'Type your description here', 'dormatic' ),
			)
		);

		$this->add_control(
			'background_shape',
			array(
				'label'   => esc_html__( 'Background Shape', 'dormatic' ),
				'type'    => Controls_Manager::MEDIA,
				'default' => array(
					'url' => Utils::get_placeholder_image_src(),
				),

			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'item',
			array(
				'label' => esc_html__( 'item', 'dormatic' ),
			)
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'item_title',
			array(
				'label'   => esc_html__( 'Title', 'dormatic' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'New Door Installation', 'dormatic' ),
			)
		);

		$repeater->add_control(
			'item_icon',
			array(
				'label' => esc_html__( 'Icon', 'dormatic' ),
				'type'  => Controls_Manager::ICONS,
			)
		);

		$repeater->add_control(
			'item_image',
			array(
				'label'   => esc_html__( 'Image', 'dormatic' ),
				'type'    => Controls_Manager::MEDIA,
				'default' => array(
					'url' => Utils::get_placeholder_image_src(),
				),

			)
		);

		$repeater->add_control(
			'item_content',
			array(
				'label'       => esc_html__( 'Content', 'dormatic' ),
				'type'        => Controls_Manager::TEXTAREA,
				'rows'        => 6,
				'default'     => __( 'Sunt culpa qui officia deslys mollit anim est laborum. Sed perspiciatis un omnis iste natus error sit voluptatem.', 'dormatic' ),
				'placeholder' => esc_html__( 'Type your description here', 'dormatic' ),

			)
		);

		$repeater->add_control(
			'item_button_text',
			array(
				'label'   => esc_html__( 'Button Text', 'dormatic' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'Read More', 'dormatic' ),
			)
		);

		$repeater->add_control(
			'item_button_url',
			array(
				'label'         => esc_html__( 'Button URL', 'dormatic' ),
				'type'          => Controls_Manager::URL,
				'placeholder'   => esc_html__( 'https://your-link.com', 'dormatic' ),
				'show_external' => true,
				'default'       => array(
					'url'         => '',
					'is_external' => true,
					'nofollow'    => true,
				),

			)
		);

		$this->add_control(
			'items',
			array(
				'label'   => esc_html__( 'Repeater List', 'dormatic' ),
				'type'    => Controls_Manager::REPEATER,
				'fields'  => $repeater->get_controls(),
				'default' => array(
					array(
						'list_title'   => esc_html__( 'Title #1', 'dormatic' ),
						'list_content' => esc_html__( 'Item content. Click the edit button to change this text.', 'dormatic' ),
					),
					array(
						'list_title'   => esc_html__( 'Title #2', 'dormatic' ),
						'list_content' => esc_html__( 'Item content. Click the edit button to change this text.', 'dormatic' ),
					),
				),
			)
		);

		$this->end_controls_section();

		// Typography Section
		$this->start_controls_section(
			'typography_section',
			array(
				'label' => __( 'Typography Section', 'elementor' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'     => 'tagline_typography',
				'label'    => __( 'Tagline', 'elementor' ),
				'selector' => '{{WRAPPER}} .sec-title span',
			)
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'     => 'heading_typography',
				'label'    => __( 'Heading', 'elementor' ),
				'selector' => '{{WRAPPER}} .sec-title h2',
			)
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'     => 'subheading_typography',
				'label'    => __( 'Sub Heading', 'elementor' ),
				'selector' => '{{WRAPPER}} .service-section .title-inner .text p,{{WRAPPER}} .service-style-three .title-inner .text p',
			)
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'     => 'title_typography',
				'label'    => __( 'Item Title', 'elementor' ),
				'selector' => '{{WRAPPER}} .service-block-one .inner-box .lower-content .text h3 a',
			)
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'     => 'subtitle_typography',
				'label'    => __( 'Item Sub Title', 'elementor' ),
				'selector' => '{{WRAPPER}} .service-block-one .inner-box .lower-content .text p',
			)
		);
		$this->end_controls_section();

		// color_section
		$this->start_controls_section(
			'color_section',
			array(
				'label' => __( 'Color Section', 'elementor' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);
		$this->start_controls_tabs( 'tabs_button_style' );
		$this->start_controls_tab(
			'tab_button_normal',
			array(
				'label' => __( 'Normal', 'elementor' ),
			)
		);

		$this->add_control(
			'item_icon_color',
			array(
				'label'     => __( 'Item Icon Color', 'elementor' ),
				'separator' => 'before',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .service-block-one .inner-box .lower-content .icon-box .icon ' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'item_icon_bg_color',
			array(
				'label'     => __( 'Item Icon BG Color', 'elementor' ),
				'separator' => 'before',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .service-block-one .inner-box .lower-content .icon-box .icon ' => 'background: {{VALUE}}',
					'{{WRAPPER}} .service-block-one .inner-box .lower-content .icon-box .icon' => 'background-color: {{VALUE}}',
				),
			)
		);
		$this->add_control(
			'bottom_icon_color',
			array(
				'label'     => __( 'Bottom Icon Color', 'elementor' ),
				'separator' => 'before',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .cta-text h3 i' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'number_color',
			array(
				'label'     => __( 'Number Color', 'elementor' ),
				'separator' => 'before',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .cta-text h3 a' => 'color: {{VALUE}}',
				),
			)
		);
		
		$this->add_control(
			'text_color',
			array(
				'label'     => __( 'Text Color', 'elementor' ),
				'separator' => 'before',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .cta-text h3 a span' => 'color: {{VALUE}}',
				),
			)
		);

		$this->end_controls_tab();
		$this->start_controls_tab(
			'tab_button_hover',
			array(
				'label' => __( 'Hover', 'elementor' ),
			)
		);

		$this->add_control(
			'hover_color',
			array(
				'label'     => __( ' Item Hover Color', 'elementor' ),
				'separator' => 'before',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .service-block-one .inner-box .image-box ' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .service-block-one .inner-box .lower-content .icon-box:hover .icon' => 'background-color: {{VALUE}}',
				),
			)
		);

		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();

	}
	protected function render() {
		$settings              = $this->get_settings_for_display();
		$layout_style          = $settings['layout_style'];
		$col_no		           = $settings['col_no'];
		$tagline               = $settings['tagline'];
			$heading           = $settings['heading'];
			$heading_html = sprintf( '<%1$s %2$s>%3$s</%1$s>', Utils::validate_html_tag( $settings['header_size'] ), $this->get_render_attribute_string( 'heading' ), $heading );
			$sub_heading       = $settings['sub_heading'];
			$bottom_content    = $settings['bottom_content'];
			$bottom_content_02 = $settings['bottom_content_02'];
			$background_shape  = ( $settings['background_shape']['id'] != '' ) ? wp_get_attachment_image_url( $settings['background_shape']['id'], 'full' ) : $settings['background_shape']['url'];

		?> 
		<?php if ( $layout_style == 'style_1' ) { ?>  
<section class="service-section bg-color-1">
	<div class="pattern-layer" style="background-image: url(<?php echo $background_shape; ?>);"></div>
	<div class="auto-container">
		<div class="title-inner clearfix">
			<div class="sec-title light text-right">
				<span><?php echo $tagline; ?></span>
				<?php echo $heading_html; ?>
			</div>
			<div class="text">
				<p><?php echo $sub_heading; ?></p>
			</div>
		</div>
		<div class="three-item-carousel owl-carousel owl-theme owl-dots-none nav-style-one">
							<?php
							$i = 1;
							foreach ( $settings['items'] as $item ) {
								$item_title               = $item['item_title'];
								$item_icon                = $item['item_icon'];
								$item_image               = ( $item['item_image']['id'] != '' ) ? wp_get_attachment_image( $item['item_image']['id'], 'full' ) : $item['item_image']['url'];
								$item_image_alt           = get_post_meta( $item['item_image']['id'], '_wp_attachment_image_alt', true );
								$item_content             = $item['item_content'];
								$item_button_text         = $item['item_button_text'];
								$item_button_url          = $item['item_button_url']['url'];
								$item_button_url_external = $item['item_button_url']['is_external'] ? 'target="_blank"' : '';
								$item_button_url_nofollow = $item['item_button_url']['nofollow'] ? 'rel="nofollow"' : '';
								?>
					  <div class="service-block-one">
  <div class="inner-box">
	<figure class="image-box"><a href="<?php echo esc_attr( $item_button_url ); ?>" <?php echo $item_button_url_external; ?>  <?php echo $item_button_url_nofollow; ?>>
												  <?php
													if ( wp_http_validate_url( $item_image ) ) {
														?>
							<img src="<?php echo esc_url( $item_image ); ?>" alt="<?php esc_attr( $item_image_alt ); ?>">
														<?php
													} else {
														echo $item_image;
													}
													?>
					</a></figure>
	<div class="lower-content">
	  <div class="icon-box">
		<div class="icon"><?php \Elementor\Icons_Manager::render_icon( ( $item_icon ), array( 'aria-hidden' => 'true' ) ); ?></div>
	  </div>
	  <div class="text">
		<h3><a href="<?php echo esc_attr( $item_button_url ); ?>" <?php echo $item_button_url_external; ?>  <?php echo $item_button_url_nofollow; ?>><?php echo $item_title; ?></a></h3>
		<p><?php echo $item_content; ?></p>
	  </div>
	  <div class="link"><a href="<?php echo esc_attr( $item_button_url ); ?>" <?php echo $item_button_url_external; ?>  <?php echo $item_button_url_nofollow; ?>><?php echo $item_button_text; ?></a></div>
	</div>
  </div>
</div>
<?php $i++; } ?> 
									
		</div>
		<div class="cta-text centred">
			<p><?php echo $bottom_content; ?></p>
			<h3><?php echo $bottom_content_02; ?></h3>
		</div>
	</div>
</section>
<?php } elseif ( $layout_style == 'style_2' ) { ?>  
<section class="service-style-three">
	<div class="auto-container">
			<?php if ( ! empty( $heading ) || ! empty( $tagline ) || ! empty( $sub_heading ) ) { ?>
		<div class="title-inner clearfix">
			<div class="sec-title text-right">
				<span><?php echo $tagline; ?></span>
				<?php echo $heading_html; ?>
			</div>
			<div class="text">
				<p><?php echo $sub_heading; ?></p>
			</div>
		</div>
		<?php } ?>
		<div class="row clearfix">
			 <?php
				$i = 1;
				foreach ( $settings['items'] as $item ) {
					$item_title               = $item['item_title'];
					$item_icon                = $item['item_icon'];
					$item_image               = ( $item['item_image']['id'] != '' ) ? wp_get_attachment_image( $item['item_image']['id'], 'full' ) : $item['item_image']['url'];
					$item_image_alt           = get_post_meta( $item['item_image']['id'], '_wp_attachment_image_alt', true );
					$item_content             = $item['item_content'];
					$item_button_text         = $item['item_button_text'];
					$item_button_url          = $item['item_button_url']['url'];
					$item_button_url_external = $item['item_button_url']['is_external'] ? 'target="_blank"' : '';
					$item_button_url_nofollow = $item['item_button_url']['nofollow'] ? 'rel="nofollow"' : '';
					?>

<div class="col-lg-<?php echo $col_no; ?> col-md-6 col-sm-12 service-block">
	<div class="service-block-one">
		<div class="inner-box">
			<figure class="image-box"><a href="<?php echo esc_attr( $item_button_url ); ?>" <?php echo $item_button_url_external; ?>  <?php echo $item_button_url_nofollow; ?>>
						<?php
						if ( wp_http_validate_url( $item_image ) ) {
							?>
			<img src="<?php echo esc_url( $item_image ); ?>" alt="<?php esc_attr( $item_image_alt ); ?>">
							<?php
						} else {
							echo $item_image;
						}
						?>
					</a></figure>
			<div class="lower-content">
				<div class="icon-box">
					<div class="icon"><?php \Elementor\Icons_Manager::render_icon( ( $item_icon ), array( 'aria-hidden' => 'true' ) ); ?></div>
				</div>
				<div class="text">
					<h3><a href="<?php echo esc_attr( $item_button_url ); ?>" <?php echo $item_button_url_external; ?>  <?php echo $item_button_url_nofollow; ?>><?php echo $item_title; ?></a></h3>
					<p><?php echo $item_content; ?></p>
				</div>
				<div class="link"><a href="<?php echo esc_attr( $item_button_url ); ?>" <?php echo $item_button_url_external; ?>  <?php echo $item_button_url_nofollow; ?>><?php echo $item_button_text; ?></a></div>
			</div>
		</div>
	</div>
</div> <?php $i++; } ?> 
									
		</div>
	</div>
</section> 

			<?php
}
	}

	protected function content_template() {
	}
}
