<?php
namespace Dormatic\Helper\Elementor\Widgets;

use Elementor\Utils;
use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use Elementor\Plugin;
use \Elementor\Repeater;

class Dormatic_Pricing extends Widget_Base {

	public function get_name() {
		return 'dormatic_pricing';
	}

	public function get_title() {
		return esc_html__( 'Dormatic Pricing', 'dormatic' );
	}

	public function get_icon() {
		return 'sds-widget-ico';
	}

	public function get_categories() {
		return array( 'Dormatic' );
	}

	protected function register_controls() {

		$this->start_controls_section(
			'general',
			array(
				'label' => esc_html__( 'general', 'dormatic' ),
			)
		);

		$this->add_control(
			'tagline',
			array(
				'label'   => esc_html__( 'Tagline', 'dormatic' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'Garage Door installation & Repair', 'dormatic' ),
			)
		);

		$this->add_control(
			'heading',
			array(
				'label'   => esc_html__( 'Heading', 'dormatic' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'Our Flexible Pricing <br />Structure For Garage', 'dormatic' ),
			)
		);

		$this->add_control(
			'header_size',
			[
				'label' => esc_html__( 'HTML Tag', 'elementor' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'h1' => 'H1',
					'h2' => 'H2',
					'h3' => 'H3',
					'h4' => 'H4',
					'h5' => 'H5',
					'h6' => 'H6',
				],
				'default' => 'h2',
			]
		);

		$this->add_control(
			'sub_heading',
			array(
				'label'       => esc_html__( 'Sub Heading', 'dormatic' ),
				'type'        => Controls_Manager::TEXTAREA,
				'rows'        => 6,
				'default'     => __( 'Aute irure dolor reprehenderit cepteur ocaecat cupidatate sed ipsum non proident int sunt indys sint sed ipsum culpa quis.', 'dormatic' ),
				'placeholder' => esc_html__( 'Type your description here', 'dormatic' ),

			)
		);
		$this->add_control(
			'extra_class',
			array(
				'label' => esc_html__( 'Extra Class', 'dormatic-core' ),
				'type'  => Controls_Manager::TEXT,
			)
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'item',
			array(
				'label' => esc_html__( 'item', 'dormatic' ),
			)
		);

		$repeater = new Repeater();
		$repeater->add_control(
			'item_icon',
			array(
				'label' => esc_html__( 'Icon', 'dormatic' ),
				'type'  => Controls_Manager::ICONS,
			)
		);
		$repeater->add_control(
			'item_title',
			array(
				'label'   => esc_html__( 'Title', 'dormatic' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'Basic Plan', 'dormatic' ),
			)
		);

		$repeater->add_control(
			'item_price',
			array(
				'label'   => esc_html__( 'Price', 'dormatic' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( '45.00', 'dormatic' ),
			)
		);

		$repeater->add_control(
			'item_price_text',
			array(
				'label'   => esc_html__( 'Price Text', 'dormatic' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'charge Per visit', 'dormatic' ),
			)
		);

		$repeater->add_control(
			'item_services_list',
			array(
				'label'       => esc_html__( 'Services List', 'dormatic' ),
				'type'        => Controls_Manager::TEXTAREA,
				'rows'        => 6,
				'placeholder' => esc_html__( 'Type your description here', 'dormatic' ),

			)
		);

		$repeater->add_control(
			'item_button_text',
			array(
				'label'   => esc_html__( 'Button Text', 'dormatic' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'get this package', 'dormatic' ),
			)
		);

		$repeater->add_control(
			'item_button_url',
			array(
				'label'         => esc_html__( 'Button URL', 'dormatic' ),
				'type'          => Controls_Manager::URL,
				'placeholder'   => esc_html__( 'https://your-link.com', 'dormatic' ),
				'show_external' => true,
				'default'       => array(
					'url'         => '',
					'is_external' => false,
					'nofollow'    => false,
				),

			)
		);
		$repeater->add_control(
			'item_featured',
			array(
				'label' => esc_html__( 'Featured', 'dormatic' ),
				'type'  => Controls_Manager::SWITCHER,
			)
		);
		$this->add_control(
			'items',
			array(
				'label'   => esc_html__( 'Repeater List', 'dormatic' ),
				'type'    => Controls_Manager::REPEATER,
				'fields'  => $repeater->get_controls(),
				'default' => array(
					array(
						'list_title'   => esc_html__( 'Title #1', 'dormatic' ),
						'list_content' => esc_html__( 'Item content. Click the edit button to change this text.', 'dormatic' ),
					),
					array(
						'list_title'   => esc_html__( 'Title #2', 'dormatic' ),
						'list_content' => esc_html__( 'Item content. Click the edit button to change this text.', 'dormatic' ),
					),
				),
			)
		);

		$this->end_controls_section();

		// Typography Section
		
		$this->start_controls_section(
			'typography_section',
			array(
				'label' => __( 'Typography Section', 'elementor' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'     => 'tagline_typography',
				'label'    => __( 'Tagline', 'elementor' ),
				'selector' => '{{WRAPPER}} .sec-title span',
			)
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'     => 'heading_typography',
				'label'    => __( 'Heading', 'elementor' ),
				'selector' => '{{WRAPPER}} .sec-title h2',
			)
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'     => 'subheading_typography',
				'label'    => __( 'Sub Heading', 'elementor'),
				'selector' => '{{WRAPPER}} .pricing-section .title-inner .text p,{{WRAPPER}} .pricing-section .upper-text h3',
			)
		);
		
		$this->end_controls_section();

		// color_section
		$this->start_controls_section(
			'color_section',
			array(
				'label' => __( 'Color Section', 'elementor' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);
		$this->start_controls_tabs( 'tabs_button_style' );
		$this->start_controls_tab(
			'tab_button_normal',
			array(
				'label' => __( 'Normal', 'elementor' ),
			)
		);

		$this->add_control(
			'text_color',
			array(
				'label'     => __( 'Text Color', 'elementor' ),
				'separator' => 'before',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .pricing-block-one .pricing-table .table-content h3' => 'color: {{VALUE}}',
				),
			)
		);

		
		$this->add_control(
            'button_text_color',
            array(
                'label'     => __('Button Text Color', 'elementor'),
                'separator' => 'before',
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => array(
                    '{{WRAPPER}} .pricing-block-one .pricing-table .table-footer a' => 'color: {{VALUE}}',
                ),
            )
		);
		
		$this->add_control(
			'button_bg_color',
			array(
				'label'     => __( 'Button BG Color', 'elementor' ),
				'separator' => 'before',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .pricing-block-one .pricing-table .table-footer a' => 'background-color: {{VALUE}}',
				),
			)
		);

		$this->end_controls_tab();
		$this->start_controls_tab(
			'tab_button_hover',
			array(
				'label' => __( 'Hover', 'elementor' ),
			)
		);

		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();

	}
	protected function render() {
		$settings            = $this->get_settings_for_display();
		$tagline             = $settings['tagline'];
				$heading     = $settings['heading'];
				$heading_html = sprintf( '<%1$s %2$s>%3$s</%1$s>', Utils::validate_html_tag( $settings['header_size'] ), $this->get_render_attribute_string( 'heading' ), $heading );
				$sub_heading = $settings['sub_heading'];
				$extra_class = $settings['extra_class'];
		?> 
	<section class="pricing-section <?php echo $extra_class; ?>">
	<div class="auto-container">
		<?php if ( ! empty( $heading ) ) { ?>
		<div class="title-inner clearfix">
			<div class="sec-title text-right">
				<span><?php echo $tagline; ?></span>
				<?php echo $heading_html; ?>
			</div>
			<div class="text">
				<p><?php echo $sub_heading; ?></p>
			</div>
		</div>
		<?php } else { ?>
		<div class="upper-text centred">
			<h3><?php echo $sub_heading; ?></h3>
		</div>
		<?php } ?>
		<div class="row clearfix">
							 <?php
								$i = 1;
								foreach ( $settings['items'] as $item ) {
									$item_featured            = $item['item_featured'];
									$item_title               = $item['item_title'];
									$item_price               = $item['item_price'];
									$item_price_text          = $item['item_price_text'];
									$item_services_list       = $item['item_services_list'];
									$item_button_text         = $item['item_button_text'];
									$item_icon                = $item['item_icon'];
									$item_button_url          = $item['item_button_url']['url'];
									$item_button_url_external = $item['item_button_url']['is_external'] ? 'target="_blank"' : '';
									$item_button_url_nofollow = $item['item_button_url']['nofollow'] ? 'rel="nofollow"' : '';
									if ( $item_featured ) {
										$item_featured = 'active';
									} else {
										$item_featured = '';
									}
									?>
					  <div class="col-lg-4 col-md-6 col-sm-12 pricing-block">
  <div class="pricing-block-one <?php echo $item_featured; ?>">
	<div class="pricing-table">
	  <div class="table-header">
		<div class="icon-box"><?php \Elementor\Icons_Manager::render_icon( ( $item_icon ), array( 'aria-hidden' => 'true' ) ); ?></div>
		<h2><?php echo $item_price; ?></h2>
		<p><?php echo $item_price_text; ?></p>
	  </div>
	  <div class="table-content">
		<h3><?php echo $item_title; ?></h3>
		<ul class="list clearfix">
									<?php echo $item_services_list; ?>
		</ul>
	  </div>
	  <div class="table-footer">
		<a href="<?php echo esc_attr( $item_button_url ); ?>" <?php echo $item_button_url_external; ?>  <?php echo $item_button_url_nofollow; ?>><?php echo $item_button_text; ?></a>
	  </div>
	</div>
  </div>
</div> <?php $i++; } ?> 
									
		</div>
	</div>
</section> 
		<?php
	}

	protected function content_template() {
	}
}

