<?php
namespace Dormatic\Helper\Elementor\Widgets;

use Elementor\Utils;
use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use Elementor\Plugin;
use \Elementor\Repeater;

class Dormatic_Installation_Section extends Widget_Base {

	public function get_name() {
		return 'dormatic_installation_section';
	}

	public function get_title() {
		return esc_html__( 'Dormatic Installation Section', 'dormatic-core' );
	}

	public function get_icon() {
		return 'sds-widget-ico';
	}

	public function get_categories() {
		return array( 'Dormatic' );
	}

	protected function register_controls() {

		$this->start_controls_section(
			'general',
			array(
				'label' => esc_html__( 'general', 'dormatic-core' ),
			)
		);

		$this->add_control(
			'tagline',
			array(
				'label'   => esc_html__( 'Tagline', 'dormatic-core' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'Garage Door installation & Repair', 'dormatic-core' ),
			)
		);

		$this->add_control(
			'heading',
			array(
				'label'   => esc_html__( 'Heading', 'dormatic-core' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'We Provide Full Service While Having The Highest Level Of Quality & Professionalism', 'dormatic-core' ),
			)
		);

		$this->add_control(
			'header_size',
			[
				'label' => esc_html__( 'HTML Tag', 'elementor' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'h1' => 'H1',
					'h2' => 'H2',
					'h3' => 'H3',
					'h4' => 'H4',
					'h5' => 'H5',
					'h6' => 'H6',
				],
				'default' => 'h2',
			]
		);

		$this->add_control(
			'background_shape',
			array(
				'label'   => esc_html__( 'Background Shape', 'dormatic-core' ),
				'type'    => Controls_Manager::MEDIA,
				'default' => array(
					'url' => Utils::get_placeholder_image_src(),
				),

			)
		);

		$this->add_control(
			'video_image',
			array(
				'label'   => esc_html__( 'Video Image', 'dormatic-core' ),
				'type'    => Controls_Manager::MEDIA,
				'default' => array(
					'url' => Utils::get_placeholder_image_src(),
				),

			)
		);

		$this->add_control(
			'video_link',
			array(
				'label'         => esc_html__( 'Video Link', 'dormatic-core' ),
				'type'          => Controls_Manager::URL,
				'placeholder'   => esc_html__( 'https://your-link.com', 'dormatic-core' ),
				'show_external' => true,
				'default'       => array(
					'url'         => '',
					'is_external' => true,
					'nofollow'    => true,
				),

			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'item',
			array(
				'label' => esc_html__( 'item', 'dormatic-core' ),
			)
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'item_title',
			array(
				'label'   => esc_html__( 'Tab Title', 'dormatic-core' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'Mission & Vision', 'dormatic-core' ),
			)
		);
		$repeater->add_control(
			'item_tab_title_icon',
			array(
				'label' => esc_html__( 'Tab Title Icon', 'dormatic-core' ),
				'type'  => Controls_Manager::ICONS,
			)
		);

		$repeater->add_control(
			'item_tab_content',
			array(
				'label'       => esc_html__( 'Tab Content', 'dormatic-core' ),
				'type'        => Controls_Manager::WYSIWYG,
				'default'     => esc_html__( 'Default description', 'dormatic-core' ),
				'placeholder' => esc_html__( 'Type your description here', 'dormatic-core' ),

			)
		);

		$repeater->add_control(
			'item_tab_content_button',
			array(
				'label'   => esc_html__( 'Tab Content Button', 'dormatic-core' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'Read More', 'dormatic-core' ),
			)
		);

		$repeater->add_control(
			'item_tab_content_button_url',
			array(
				'label'         => esc_html__( 'Tab Content Button URL', 'dormatic-core' ),
				'type'          => Controls_Manager::URL,
				'placeholder'   => esc_html__( 'https://your-link.com', 'dormatic-core' ),
				'show_external' => true,
				'default'       => array(
					'url'         => '',
					'is_external' => true,
					'nofollow'    => true,
				),

			)
		);

		$this->add_control(
			'items',
			array(
				'label'   => esc_html__( 'Repeater List', 'dormatic-core' ),
				'type'    => Controls_Manager::REPEATER,
				'fields'  => $repeater->get_controls(),
				'default' => array(
					array(
						'list_title'   => esc_html__( 'Title #1', 'dormatic-core' ),
						'list_content' => esc_html__( 'Item content. Click the edit button to change this text.', 'dormatic-core' ),
					),
					array(
						'list_title'   => esc_html__( 'Title #2', 'dormatic-core' ),
						'list_content' => esc_html__( 'Item content. Click the edit button to change this text.', 'dormatic-core' ),
					),
				),
			)
		);

		$this->end_controls_section();

		// Typography Section
		
        $this->start_controls_section(
            'typography_section',
            array(
                'label' => __('Typography Section', 'elementor'),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            )
        );

		$this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            array(
                'name'     => 'tagline_typography',
                'label'    => __('Tagline', 'elementor'),
                'selector' => '{{WRAPPER}} .sec-title span',
            )
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            array(
                'name'     => 'heading_typography',
                'label'    => __('Heading', 'prunelementorers'),
                'selector' => '{{WRAPPER}} .sec-title h2',
            )
        );


		$this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            array(
                'name'     => 'item_title_typography',
                'label'    => __('Item Title', 'elementor'),
                'selector' => '{{WRAPPER}} .tabs-box .tab-btn-box .tab-btns li h5',
            )
		);

		$this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            array(
                'name'     => 'item_description_typography',
                'label'    => __('Item Description', 'elementor'),
                'selector' => '{{WRAPPER}} .tabs-box .tabs-content .text p',
            )
        );
        $this->end_controls_section();

        // color_section
        $this->start_controls_section(
            'color_section',
            array(
                'label' => __('Color Section', 'elementor'),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            )
        );
        $this->start_controls_tabs('tabs_button_style');
        $this->start_controls_tab(
            'tab_button_normal',
            array(
                'label' => __('Normal', 'elementor'),
            )
		);
	
	
		$this->add_control(
			'icon_color',
			array(
				'label'     => __( 'Icon Color', 'elementor' ),
				'separator' => 'before',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .tabs-box .tab-btn-box .tab-btns li .icon-box' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
            'button_text_color',
            array(
                'label'     => __('Button Text Color', 'elementor'),
                'separator' => 'before',
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => array(
                    '{{WRAPPER}} .tabs-box .tabs-content .text a' => 'color: {{VALUE}}',
                ),
            )
		);

		$this->add_control(
			'button_bg_color',
			array(
				'label'     => __( 'Button BG Color', 'elementor' ),
				'separator' => 'before',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .tabs-box .tabs-content .text a' => 'background-color: {{VALUE}}',
				),
			)
		);

        $this->end_controls_tab();
        $this->start_controls_tab(
            'tab_button_hover',
            array(
                'label' => __('Hover', 'elementor'),
            )
		);
		
		$this->add_control(
			'icon_hover_color',
			array(
				'label'     => __( 'Icon Hover Color', 'elementor' ),
				'separator' => 'before',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .tabs-box .tab-btn-box .tab-btns li:hover .icon-box, .tabs-box .tab-btn-box .tab-btns li.active-btn .icon-box' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'button_text_hover_color',
			array(
				'label'     => __( 'Button Hover Text Color', 'elementor' ),
				'separator' => 'before',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .tabs-box .tabs-content:hover .text a' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'button_hover_bg_color',
			array(
				'label'     => __( 'Button Hover BG Color', 'elementor' ),
				'separator' => 'before',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .tabs-box .tabs-content:hover .text a' => 'background-color: {{VALUE}}',
				),
			)
		);
		

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();


	}
	protected function render() {
		$settings         = $this->get_settings_for_display();
		$tagline          = $settings['tagline'];
		$heading          = $settings['heading'];
		$heading_html = sprintf( '<%1$s %2$s>%3$s</%1$s>', Utils::validate_html_tag( $settings['header_size'] ), $this->get_render_attribute_string( 'heading' ), $heading );
		$background_shape = ( $settings['background_shape']['id'] != '' ) ? wp_get_attachment_image_url( $settings['background_shape']['id'], 'full' ) : $settings['background_shape']['url'];
		$video_image      = ( $settings['video_image']['id'] != '' ) ? wp_get_attachment_image_url( $settings['video_image']['id'], 'full' ) : $settings['video_image']['url'];
		$video_link       = $settings['video_link']['url'];
		?> 
<section class="installation-section bg-color-1">
	<div class="pattern-layer" style="background-image: url(<?php echo $background_shape; ?>);"></div>
	<div class="auto-container">
		<div class="row clearfix">
			<div class="col-lg-7 col-md-12 col-sm-12 content-column">
				<div class="content_block_6">
					<div class="content-box">
						<div class="sec-title light">
							<span><?php echo $tagline; ?></span>
							<?php echo $heading_html; ?>
						</div>
						<div class="tabs-box">
							<div class="tab-btn-box">
								<ul class="tab-btns tab-buttons clearfix">
									 <?php
										$i = 1;
										foreach ( $settings['items'] as $item ) {
											$item_title          = $item['item_title'];
											$item_tab_title_icon = $item['item_tab_title_icon'];
											if ( $i == 1 ) {
												$active_class = 'active-btn';
											} else {
												$active_class = '';
											}
											?>
									<li class="tab-btn <?php echo $active_class; ?>" data-tab="#tab-<?php echo $i; ?>">
										<div class="icon-box"><?php \Elementor\Icons_Manager::render_icon( ( $item_tab_title_icon ), array( 'aria-hidden' => 'true' ) ); ?></div>
										<h5><?php echo $item_title; ?></h5>
									</li>
									<?php $i++; } ?> 
								</ul>
							</div>
							<div class="tabs-content">
								 <?php
									$i = 1;
									foreach ( $settings['items'] as $item ) {
										$item_title                           = $item['item_title'];
										$item_tab_content                     = $item['item_tab_content'];
										$item_tab_content_button              = $item['item_tab_content_button'];
										$item_tab_content_button_url          = $item['item_tab_content_button_url']['url'];
										$item_tab_content_button_url_external = $item['item_tab_content_button_url']['is_external'] ? 'target="_blank"' : '';
										$item_tab_content_button_url_nofollow = $item['item_tab_content_button_url']['nofollow'] ? 'rel="nofollow"' : '';
										$item_tab_title_icon                  = $item['item_tab_title_icon'];
										if ( $i == 1 ) {
											$active_class = 'active-tab';
										} else {
											$active_class = '';
										}
										?>
								<div class="tab <?php echo $active_class; ?>" id="tab-<?php echo $i; ?>">
									<div class="text">
										<?php echo $item_tab_content; ?>
										<div class="btn-box">
											<a href="<?php echo esc_attr( $item_tab_content_button_url ); ?>" <?php echo $item_tab_content_button_url_external; ?>  <?php echo $item_tab_content_button_url_nofollow; ?>><?php echo $item_tab_content_button; ?></a>
										</div>
									</div>
								</div> 
								<?php $i++; } ?> 
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="col-lg-5 col-md-12 col-sm-12 video-column">
				<div class="video_block_1">
					<div class="video-content">
						<div class="video-inner" style="background-image: url(<?php echo $video_image; ?>);">
							<div class="video-btn">
								<a href="<?php echo esc_attr( $video_link ); ?>" class="lightbox-image" data-caption=""><i class="fas fa-play"></i></a>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</section> 
		<?php
	}

	protected function content_template() {
	}
}
