<?php
namespace Dormatic\Helper\Elementor\Widgets;

use Elementor\Utils;
use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use Elementor\Plugin;
use \Elementor\Repeater;

class Dormatic_Funfact extends Widget_Base {

	public function get_name() {
		return 'dormatic_funfact';
	}

	public function get_title() {
		return esc_html__( 'Dormatic Funfact', 'dormatic' );
	}

	public function get_icon() {
		return 'sds-widget-ico';
	}

	public function get_categories() {
		return array( 'Dormatic' );
	}

	protected function register_controls() {

		$this->start_controls_section(
			'general',
			array(
				'label' => esc_html__( 'general', 'dormatic' ),
			)
		);
		$this->add_control(
			'layout_style',
			array(
				'label'   => esc_html__( 'Layout Style', 'dormatic-core' ),
				'type'    => Controls_Manager::SELECT,
				'options' => array(
					'style_1' => esc_html__( 'Style One', 'dormatic-core' ),
					'style_2' => esc_html__( 'Style Two', 'dormatic-core' ),
				),
				'default' => 'style_1',
			)
		);
		$this->add_control(
			'layout_type',
			array(
				'label'      => esc_html__( 'Layout Type', 'dormatic-core' ),
				'type'       => Controls_Manager::SELECT,
				'options'    => array(
					'grid'   => esc_html__( 'Grid', 'dormatic-core' ),
					'slider' => esc_html__( 'Slider', 'dormatic-core' ),
				),
				'default'    => 'grid',
				'conditions' => array(
					'relation' => 'and',
					'terms'    => array(
						array(
							'name'     => 'layout_style',
							'operator' => '==',
							'value'    => 'style_1',
						),
					),
				),
			)
		);
		$this->add_control(
			'background_shape',
			array(
				'label'   => esc_html__( 'Background Shape', 'dormatic' ),
				'type'    => Controls_Manager::MEDIA,
				'default' => array(
					'url' => Utils::get_placeholder_image_src(),
				),

			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'item',
			array(
				'label' => esc_html__( 'item', 'dormatic' ),
			)
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'item_title',
			array(
				'label'   => esc_html__( 'Title', 'dormatic' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'Doors Repaired Weekly', 'dormatic' ),
			)
		);

		$repeater->add_control(
			'item_count_number',
			array(
				'label'   => esc_html__( 'Count Number', 'dormatic' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( '260', 'dormatic' ),
			)
		);

		$repeater->add_control(
			'item_after_count_symbol',
			array(
				'label'   => esc_html__( 'After Count Symbol', 'dormatic' ),
				'type'    => Controls_Manager::TEXT,
			)
		);

		$repeater->add_control(
			'item_icon',
			array(
				'label' => esc_html__( 'Icon', 'dormatic' ),
				'type'  => Controls_Manager::ICONS,
			)
		);

		$this->add_control(
			'items',
			array(
				'label'   => esc_html__( 'Repeater List', 'dormatic' ),
				'type'    => Controls_Manager::REPEATER,
				'fields'  => $repeater->get_controls(),
				'default' => array(
					array(
						'list_title'   => esc_html__( 'Title #1', 'dormatic' ),
						'list_content' => esc_html__( 'Item content. Click the edit button to change this text.', 'dormatic' ),
					),
					array(
						'list_title'   => esc_html__( 'Title #2', 'dormatic' ),
						'list_content' => esc_html__( 'Item content. Click the edit button to change this text.', 'dormatic' ),
					),
				),
			)
		);

		$this->end_controls_section();

		// Typography Section
		$this->start_controls_section(
			'typography_section',
			array(
				'label' => __( 'Typography Section', 'elementor' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);

		$this->end_controls_section();

		// color_section
		$this->start_controls_section(
			'color_section',
			array(
				'label' => __( 'Color Section', 'elementor' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);
		$this->start_controls_tabs( 'tabs_button_style' );
		$this->start_controls_tab(
			'tab_button_normal',
			array(
				'label' => __( 'Normal', 'elementor' ),
			)
		);

		$this->add_control(
			'icon_color',
			array(
				'label'     => __( 'Icon Color', 'elementor' ),
				'separator' => 'before',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .counter-block-one .inner-box .icon-box' => 'color: {{VALUE}}',
					'{{WRAPPER}} .counter-block-two .inner-box .icon-box' => 'color: {{VALUE}}',
				),
			)
		);

		$this->end_controls_tab();
		$this->start_controls_tab(
			'tab_button_hover',
			array(
				'label' => __( 'Hover', 'elementor' ),
			)
		);

		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();

	}
	protected function render() {
		$settings         = $this->get_settings_for_display();
		$layout_style     = $settings['layout_style'];
		$background_shape = ( $settings['background_shape']['id'] != '' ) ? wp_get_attachment_image_url( $settings['background_shape']['id'], 'full' ) : $settings['background_shape']['url'];
		?>
		<?php
		if ( $layout_style == 'style_1' ) {
			$layout_type = $settings['layout_type'];
			?>
			<?php if ( $layout_type == 'grid' ) { ?>
			<section class="funfact-section centred">
				<div class="map-layer" style="background-image: url(<?php echo $background_shape; ?>);"></div>
				<div class="large-container">
					<div class="row clearfix">
						<?php
							$i = 1;
						foreach ( $settings['items'] as $item ) {
							$item_title              = $item['item_title'];
							$item_count_number       = $item['item_count_number'];
							$item_after_count_symbol = $item['item_after_count_symbol'];
							$item_icon               = $item['item_icon'];
							?>
								<div class="col-lg-3 col-md-6 col-sm-12 counter-block">
										<div class="counter-block-one">
											<div class="inner-box">
											<div class="icon-box"><?php \Elementor\Icons_Manager::render_icon( ( $item_icon ), array( 'aria-hidden' => 'true' ) ); ?></div>
											<div class="count-outer count-box">
												<span class="count-text" data-speed="1500" data-stop="<?php echo $item_count_number; ?>">0</span><span><?php echo $item_after_count_symbol; ?></span>
											</div>
											<p><?php echo $item_title; ?></p>
											</div>
										</div>
									</div> 
						<?php $i++; } ?> 									
					</div>
				</div>
			</section>
			<?php } elseif ( $layout_type == 'slider' ) { ?>
			<section class="funfact-section centred">
				<div class="map-layer" style="background-image: url(<?php echo $background_shape; ?>);"></div>
				<div class="large-container">
					<div class="four-item-carousel owl-carousel owl-theme owl-dots-none owl-nav-none">
						<?php
							$i = 1;
						foreach ( $settings['items'] as $item ) {
							$item_title              = $item['item_title'];
							$item_count_number       = $item['item_count_number'];
							$item_after_count_symbol = $item['item_after_count_symbol'];
							$item_icon               = $item['item_icon'];
							?>
								<div class="counter-block-one">
									<div class="inner-box">
									<div class="icon-box"><?php \Elementor\Icons_Manager::render_icon( ( $item_icon ), array( 'aria-hidden' => 'true' ) ); ?></div>
									<div class="count-outer count-box">
										<span class="count-text" data-speed="1500" data-stop="<?php echo $item_count_number; ?>">0</span><span><?php echo $item_after_count_symbol; ?></span>
									</div>
									<p><?php echo $item_title; ?></p>
									</div>
								</div>
								
						<?php $i++; } ?> 									
					</div>
				</div>
			</section>
			<?php } ?>
		<?php } elseif ( $layout_style == 'style_2' ) { ?>
			<section class="funfact-style-two bg-color-1">
				<div class="container-fluid">
					<div class="row clearfix">
					<?php
					$i = 1;
					foreach ( $settings['items'] as $item ) {
						$item_title              = $item['item_title'];
						$item_count_number       = $item['item_count_number'];
						$item_after_count_symbol = $item['item_after_count_symbol'];
						$item_icon               = $item['item_icon'];
						?>
						<div class="col-lg-3 col-md-6 col-sm-12 counter-block">
							<div class="counter-block-two">
								<div class="inner-box">
									<div class="icon-box"><?php \Elementor\Icons_Manager::render_icon( ( $item_icon ), array( 'aria-hidden' => 'true' ) ); ?></div>
									<div class="count-outer count-box">
										<span class="count-text" data-speed="1500" data-stop="<?php echo $item_count_number; ?>">0</span><span><?php echo $item_after_count_symbol; ?></span>
									</div>
									<p><?php echo $item_title; ?></p>
								</div>
							</div>
						</div>
							<?php $i++; } ?> 
					</div>
				</div>
			</section>
		
			<?php
		}
	}

	protected function content_template() {
	}
}
