<?php
namespace Dormatic\Helper\Elementor\Widgets;

use Elementor\Utils;
use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use Elementor\Plugin;
use Elementor\Repeater;

class Dormatic_Footer_Links extends Widget_Base {

	public function get_name() {
		return 'dormatic_footer_links';
	}

	public function get_title() {
		return esc_html__( 'Dormatic Footer Links', 'dormatic' );
	}

	public function get_icon() {
		return 'sds-widget-ico';
	}

	public function get_categories() {
		return array( 'Dormatic' );
	}

	protected function register_controls() {

		$this->start_controls_section(
			'general',
			array(
				'label' => esc_html__( 'general', 'dormatic' ),
			)
		);

		$this->add_control(
			'title',
			array(
				'label'   => esc_html__( 'Title', 'dormatic' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'What We Offers', 'dormatic' ),
			)
		);

		$this->add_control(
			'header_size',
			[
				'label' => esc_html__( 'HTML Tag', 'elementor' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'h1' => 'H1',
					'h2' => 'H2',
					'h3' => 'H3',
					'h4' => 'H4',
					'h5' => 'H5',
					'h6' => 'H6',
				],
				'default' => 'h2',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'item',
			array(
				'label' => esc_html__( 'item', 'dormatic' ),
			)
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'item_item_title',
			array(
				'label'   => esc_html__( 'Item Title', 'dormatic' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'Garage Door Repair', 'dormatic' ),
			)
		);

		$repeater->add_control(
			'item_item_url',
			array(
				'label'         => esc_html__( 'Item URL', 'dormatic' ),
				'type'          => Controls_Manager::URL,
				'placeholder'   => esc_html__( 'https://your-link.com', 'dormatic' ),
				'show_external' => true,
				'default'       => array(
					'url'         => '',
					'is_external' => false,
					'nofollow'    => false,
				),

			)
		);

		$this->add_control(
			'items',
			array(
				'label'   => esc_html__( 'Repeater List', 'dormatic' ),
				'type'    => Controls_Manager::REPEATER,
				'fields'  => $repeater->get_controls(),
				'default' => array(
					array(
						'list_title'   => esc_html__( 'Title #1', 'dormatic' ),
						'list_content' => esc_html__( 'Item content. Click the edit button to change this text.', 'dormatic' ),
					),
				),
			)
		);

		$this->end_controls_section();

	}
	protected function render() {
		$settings = $this->get_settings_for_display();
		$title    = $settings['title'];
		$heading_html = sprintf( '<%1$s %2$s>%3$s</%1$s>', Utils::validate_html_tag( $settings['header_size'] ), $this->get_render_attribute_string( 'title' ), $title );
		?> 
			<div class="footer-widget links-widget">
				<div class="widget-title">
					<?php echo $heading_html; ?>
				</div>
				<div class="widget-content">
					<ul class="links-list clearfix">
						<?php
						$i = 1;
						foreach ( $settings['items'] as $item ) {
							$item_item_title        = $item['item_item_title'];
							$item_item_url          = $item['item_item_url']['url'];
							$item_item_url_external = $item['item_item_url']['is_external'] ? 'target="_blank"' : '';
							$item_item_url_nofollow = $item['item_item_url']['nofollow'] ? 'rel="nofollow"' : '';
							?>
							<li><a href="<?php echo esc_url( $item_item_url ); ?>" <?php echo $item_item_url_external; ?>  <?php echo $item_item_url_nofollow; ?>><?php echo $item_item_title; ?></a></li> 
						<?php $i++; } ?>					
					</ul>
				</div>
			</div> 
		<?php
	}

	protected function content_template() {
	}
}
