<?php
namespace Dormatic\Helper\Elementor\Widgets;

use Elementor\Utils;
use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use Elementor\Plugin;
use \Elementor\Repeater;

class Dormatic_Contact_Info_Two extends Widget_Base {

	public function get_name() {
		return 'dormatic_contact_info_two';
	}

	public function get_title() {
		return esc_html__( 'Dormatic Contact Info Two', 'dormatic' );
	}

	public function get_icon() {
		return 'sds-widget-ico';
	}

	public function get_categories() {
		return array( 'Dormatic' );
	}

	protected function register_controls() {

		$this->start_controls_section(
			'general',
			array(
				'label' => esc_html__( 'general', 'dormatic' ),
			)
		);

		$this->add_control(
			'tagline',
			array(
				'label'   => esc_html__( 'Tagline', 'dormatic' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'Garage Door installation & Repair', 'dormatic' ),
			)
		);

		$this->add_control(
			'heading',
			array(
				'label'   => esc_html__( 'Heading', 'dormatic' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'Areas We Cover', 'dormatic' ),
			)
		);

		$this->add_control(
			'header_size',
			[
				'label' => esc_html__( 'HTML Tag', 'elementor' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'h1' => 'H1',
					'h2' => 'H2',
					'h3' => 'H3',
					'h4' => 'H4',
					'h5' => 'H5',
					'h6' => 'H6',
				],
				'default' => 'h2',
			]
		);

		$this->add_control(
			'sub_heading',
			array(
				'label'       => esc_html__( 'Sub Heading', 'dormatic' ),
				'type'        => Controls_Manager::TEXTAREA,
				'rows'        => 6,
				'default'     => __( 'Sunt culpa qui officia deslys mollit anim est laborum. Sed perspiciatis omnis iste natus error sit voluptatem enim ad mini veniam quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea comodo consequat.', 'dormatic' ),
				'placeholder' => esc_html__( 'Type your description here', 'dormatic' ),

			)
		);

		$this->add_control(
			'location_list',
			array(
				'label'       => esc_html__( 'Location List', 'dormatic' ),
				'type'        => Controls_Manager::TEXTAREA,
				'rows'        => 6,
				'placeholder' => esc_html__( 'Type your description here', 'dormatic' ),

			)
		);
		$this->add_control(
			'bg_shape',
			array(
				'label'   => esc_html__( 'Background Shape', 'dormatic' ),
				'type'    => Controls_Manager::MEDIA,
				'default' => array(
					'url' => Utils::get_placeholder_image_src(),
				),

			)
		);
		$this->add_control(
			'image',
			array(
				'label'   => esc_html__( 'Right Image', 'dormatic' ),
				'type'    => Controls_Manager::MEDIA,
				'default' => array(
					'url' => Utils::get_placeholder_image_src(),
				),

			)
		);

		$this->add_control(
			'image_caption',
			array(
				'label'   => esc_html__( 'Image Caption', 'dormatic' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'Installation & Repair Starts From $70', 'dormatic' ),
			)
		);

		$this->add_control(
			'appointment_text',
			array(
				'label'   => esc_html__( 'Appointment Text', 'dormatic' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'Book an Appointment Today!', 'dormatic' ),
			)
		);

		$this->add_control(
			'appointment_title',
			array(
				'label'   => esc_html__( 'Appointment Title', 'dormatic' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( '<a href="tel:12017193488">(+1) 201 719 3488</a>', 'dormatic' ),
			)
		);

		$this->add_control(
			'appointment_icon',
			array(
				'label' => esc_html__( 'Appointment Icon', 'dormatic' ),
				'type'  => Controls_Manager::ICONS,
			)
		);

		$this->add_control(
			'map_embed',
			array(
				'label'       => esc_html__( 'Map Embed', 'dormatic' ),
				'type'        => Controls_Manager::TEXTAREA,
				'rows'        => 6,
				'placeholder' => esc_html__( 'Type your description here', 'dormatic' ),

			)
		);

		$this->end_controls_section();

		// Typography Section
		$this->start_controls_section(
			'typography_section',
			array(
				'label' => __( 'Typography Section', 'elementor' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'     => 'tagline_typography',
				'label'    => __( 'Tagline', 'elementor' ),
				'selector' => '{{WRAPPER}} .sec-title span',
			)
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'     => 'heading_typography',
				'label'    => __( 'Heading', 'elementor' ),
				'selector' => '{{WRAPPER}} .sec-title h2',
			)
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'     => 'subheading_typography',
				'label'    => __( 'Sub Heading', 'elementor' ),
				'selector' => '{{WRAPPER}}  .content_block_3 .content-box .text p',
			)
		);

		$this->end_controls_section();

		// color_section
		$this->start_controls_section(
			'color_section',
			array(
				'label' => __( 'Color Section', 'elementor' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);
		$this->start_controls_tabs( 'tabs_button_style' );
		$this->start_controls_tab(
			'tab_button_normal',
			array(
				'label' => __( 'Normal', 'elementor' ),
			)
		);

		$this->add_control(
			'icon_color',
			array(
				'label'     => __( 'Icon Color', 'elementor' ),
				'separator' => 'before',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .content_block_4 .content-box .support-box .icon-box' => 'color: {{VALUE}}',
				),
			)
		);
		$this->add_control(
			'number_color',
			array(
				'label'     => __( 'Number Color', 'elementor' ),
				'separator' => 'before',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .content_block_4 .content-box .support-box h3 a' => 'color: {{VALUE}}',
				),
			)
		);

		$this->end_controls_tab();
		$this->start_controls_tab(
			'tab_button_hover',
			array(
				'label' => __( 'Hover', 'elementor' ),
			)
		);

		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();

	}
	protected function render() {
		$settings                  = $this->get_settings_for_display();
		$tagline                   = $settings['tagline'];
				$heading           = $settings['heading'];
				$heading_html = sprintf( '<%1$s %2$s>%3$s</%1$s>', Utils::validate_html_tag( $settings['header_size'] ), $this->get_render_attribute_string( 'heading' ), $heading );
				$sub_heading       = $settings['sub_heading'];
				$location_list     = $settings['location_list'];
				$bg_shape          = ( $settings['bg_shape']['id'] != '' ) ? wp_get_attachment_image( $settings['bg_shape']['id'], 'full' ) : $settings['bg_shape']['url'];
				$bg_shape_alt      = get_post_meta( $settings['bg_shape']['id'], '_wp_attachment_image_alt', true );
				$image             = ( $settings['image']['id'] != '' ) ? wp_get_attachment_image_url( $settings['image']['id'], 'full' ) : $settings['image']['url'];
				$image_caption     = $settings['image_caption'];
				$appointment_text  = $settings['appointment_text'];
				$appointment_title = $settings['appointment_title'];
				$appointment_icon  = $settings['appointment_icon'];
					$map_embed     = $settings['map_embed'];
		?> 
<section class="contact-info-section">
	<div class="contact-map">
		<?php echo $map_embed; ?>
	</div>
	<div class="auto-container">
		<div class="info-inner">
			<div class="row clearfix">
				<div class="col-lg-7 col-md-12 col-sm-12 content-column">
					<div class="content_block_3">
						<div class="content-box">
							<figure class="icon-layer">
							<?php
							if ( wp_http_validate_url( $bg_shape ) ) {
								?>
								<img src="<?php echo esc_url( $bg_shape ); ?>" alt="<?php esc_attr( $bg_shape_alt ); ?>">
									<?php
							} else {
								echo $bg_shape;
							}
							?>
							</figure>
							<div class="sec-title">
								<span><?php echo $tagline; ?></span>
								<?php echo $heading_html; ?>
							</div>
							<div class="text">
								<p><?php echo $sub_heading; ?></p>
								<ul class="location-list clearfix">
									<?php echo $location_list; ?>
								</ul>
							</div>
						</div>
					</div>
				</div>
				<div class="col-lg-5 col-md-12 col-sm-12 content-column">
					<div class="content_block_4">
						<div class="content-box" style="background-image: url(<?php echo $image; ?>);">
							<div class="text">
								<p><?php echo $image_caption; ?></p>
								<div class="support-box">
									<div class="icon-box"><?php \Elementor\Icons_Manager::render_icon( ( $appointment_icon ), array( 'aria-hidden' => 'true' ) ); ?></div>
									<span><?php echo $appointment_text; ?></span>
									<h3><?php echo $appointment_title; ?></h3>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</section> 
		<?php
	}

	protected function content_template() {
	}
}
