<?php
namespace Dormatic\Helper\Elementor\Widgets;

use Elementor\Utils;
use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use Elementor\Plugin;
use \Elementor\Repeater;

class Dormatic_Contact_Info extends Widget_Base {

	public function get_name() {
		return 'dormatic_contact_info';
	}

	public function get_title() {
		return esc_html__( 'Dormatic Contact Info', 'dormatic' );
	}

	public function get_icon() {
		return 'sds-widget-ico';
	}

	public function get_categories() {
		return array( 'Dormatic' );
	}

	protected function register_controls() {

		$this->start_controls_section(
			'general',
			array(
				'label' => esc_html__( 'general', 'dormatic' ),
			)
		);

		$this->add_control(
			'bottom_text',
			array(
				'label'       => esc_html__( 'Bottom Text', 'dormatic' ),
				'type'        => Controls_Manager::TEXTAREA,
				'rows'        => 6,
				'default'     => __( '<span>Our Showroom Hours Are:</span> Monday - Friday: 7:00 AM - 5:00 PM  (Sat & Sun: Closed)', 'dormatic' ),
				'placeholder' => esc_html__( 'Type your description here', 'dormatic' ),

			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'item',
			array(
				'label' => esc_html__( 'item', 'dormatic' ),
			)
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'item_title',
			array(
				'label'   => esc_html__( 'Title', 'dormatic' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'Office Location', 'dormatic' ),
			)
		);

		$this->add_control(
			'header_size',
			[
				'label' => esc_html__( 'HTML Tag', 'elementor' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'h1' => 'H1',
					'h2' => 'H2',
					'h3' => 'H3',
					'h4' => 'H4',
					'h5' => 'H5',
					'h6' => 'H6',
				],
				'default' => 'h3',
			]
		);

		$repeater->add_control(
			'item_icon',
			array(
				'label' => esc_html__( 'Icon', 'dormatic' ),
				'type'  => Controls_Manager::ICONS,
			)
		);

		$repeater->add_control(
			'item_content',
			array(
				'label'       => esc_html__( 'Content', 'dormatic' ),
				'type'        => Controls_Manager::TEXTAREA,
				'rows'        => 6,
				'default'     => __( '72 MainSail Drive, St. 12/B Calibry, Florida 25502  -  USA', 'dormatic' ),
				'placeholder' => esc_html__( 'Type your description here', 'dormatic' ),

			)
		);

		$this->add_control(
			'items',
			array(
				'label'   => esc_html__( 'Repeater List', 'dormatic' ),
				'type'    => Controls_Manager::REPEATER,
				'fields'  => $repeater->get_controls(),
				'default' => array(
					array(
						'list_title'   => esc_html__( 'Title #1', 'dormatic' ),
						'list_content' => esc_html__( 'Item content. Click the edit button to change this text.', 'dormatic' ),
					),
					array(
						'list_title'   => esc_html__( 'Title #2', 'dormatic' ),
						'list_content' => esc_html__( 'Item content. Click the edit button to change this text.', 'dormatic' ),
					),
				),
			)
		);

		$this->end_controls_section();
		
		// Typography Section
		
        $this->start_controls_section(
            'typography_section',
            array(
                'label' => __('Typography Section', 'elementor'),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            )
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'     => 'item_location_typography',
				'label'    => __( 'Item Location', 'elementor' ),
				'selector' => '{{WRAPPER}} .contact-info-two .single-info-box h3',
			)
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'     => 'item_address_typography',
				'label'    => __( 'Item Address', 'elementor' ),
				'selector' => '{{WRAPPER}} .contact-info-two .single-info-box p',
			)
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'     => 'bottom_text_typography',
				'label'    => __( 'Bottom Text', 'elementor' ),
				'selector' => '{{WRAPPER}} .contact-info-two .other-text h3',
			)
		);

        $this->end_controls_section();

        // color_section
        $this->start_controls_section(
            'color_section',
            array(
                'label' => __('Color Section', 'elementor'),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            )
        );
        $this->start_controls_tabs('tabs_button_style');
        $this->start_controls_tab(
            'tab_button_normal',
            array(
                'label' => __('Normal', 'elementor'),
            )
		);

		$this->add_control(
			'icon_color',
			array(
				'label'     => __( 'Icon Color', 'elementor' ),
				'separator' => 'before',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .contact-info-two .single-info-box .icon-box .icon' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'icon_bg_color',
			array(
				'label'     => __( 'Icon BG Color', 'elementor' ),
				'separator' => 'before',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .contact-info-two .single-info-box .icon-box .icon' => 'background: {{VALUE}}',
				),
			)
		);
		
        $this->end_controls_tab();
        $this->start_controls_tab(
            'tab_button_hover',
            array(
                'label' => __('Hover', 'elementor'),
            )
		);

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();


	}
	protected function render() {
		$settings    = $this->get_settings_for_display();
		$bottom_text = $settings['bottom_text'];
		?> 
			<section class="contact-info-two centred">
				<div class="auto-container">
					<div class="row clearfix">
						<?php
						$i = 1;
						foreach ( $settings['items'] as $item ) {
							$item_title   = $item['item_title'];
							$item_icon    = $item['item_icon'];
							$item_content = $item['item_content'];
							?>
						<div class="col-lg-4 col-md-6 col-sm-12 info-column">
							<div class="single-info-box">
								<div class="icon-bg"><?php \Elementor\Icons_Manager::render_icon( ( $item_icon ), array( 'aria-hidden' => 'true' ) ); ?></div>
								<div class="icon-box">
								<div class="icon"><?php \Elementor\Icons_Manager::render_icon( ( $item_icon ), array( 'aria-hidden' => 'true' ) ); ?></div>
								</div>
								<h3><?php echo $item_title; ?></h3>
								<p><?php echo $item_content; ?></p>
							</div>
						</div> 
						<?php $i++; } ?> 					
					</div>
					<div class="other-text"><h3><?php echo $bottom_text; ?></h3></div>
				</div>
			</section> 
		<?php
	}

	protected function content_template() {
	}
}
