<?php
namespace Dormatic\Helper\Elementor\Widgets;

use Elementor\Utils;
use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use Elementor\Plugin;
use \Elementor\Repeater;

class Dormatic_Clients extends Widget_Base {

	public function get_name() {
		return 'dormatic_clients';
	}

	public function get_title() {
		return esc_html__( 'Dormatic Clients', 'dormatic' );
	}

	public function get_icon() {
		return 'sds-widget-ico';
	}

	public function get_categories() {
		return array( 'Dormatic' );
	}

	protected function register_controls() {

		$this->start_controls_section(
			'general',
			array(
				'label' => esc_html__( 'general', 'dormatic' ),
			)
		);
		$this->add_control(
			'heading',
			array(
				'label'       => esc_html__( 'Heading', 'dormatic' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'default'     => __( 'Trusted By Millions Of Residential & Commercial Customers', 'dormatic' ),
			)
		);

		$this->add_control(
			'header_size',
			[
				'label' => esc_html__( 'HTML Tag', 'elementor' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'h1' => 'H1',
					'h2' => 'H2',
					'h3' => 'H3',
					'h4' => 'H4',
					'h5' => 'H5',
					'h6' => 'H6',
				],
				'default' => 'h3',
			]
		);

		$this->add_control(
			'extra_class',
			array(
				'label' => esc_html__( 'Extra Class', 'dormatic' ),
				'type'  => Controls_Manager::TEXT,
			)
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'item',
			array(
				'label' => esc_html__( 'item', 'dormatic' ),
			)
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'item_image',
			array(
				'label'   => esc_html__( 'Image', 'dormatic' ),
				'type'    => Controls_Manager::MEDIA,
				'default' => array(
					'url' => Utils::get_placeholder_image_src(),
				),

			)
		);

		$repeater->add_control(
			'item_url',
			array(
				'label'         => esc_html__( 'URL', 'dormatic' ),
				'type'          => Controls_Manager::URL,
				'placeholder'   => esc_html__( 'https://your-link.com', 'dormatic' ),
				'show_external' => true,
				'default'       => array(
					'url'         => '',
					'is_external' => false,
					'nofollow'    => false,
				),

			)
		);

		$this->add_control(
			'items',
			array(
				'label'   => esc_html__( 'Repeater List', 'dormatic' ),
				'type'    => Controls_Manager::REPEATER,
				'fields'  => $repeater->get_controls(),
				'default' => array(
					array(
						'list_title'   => esc_html__( 'Title #1', 'dormatic' ),
						'list_content' => esc_html__( 'Item content. Click the edit button to change this text.', 'dormatic' ),
					),
					array(
						'list_title'   => esc_html__( 'Title #2', 'dormatic' ),
						'list_content' => esc_html__( 'Item content. Click the edit button to change this text.', 'dormatic' ),
					),
				),
			)
		);

		$this->end_controls_section();

		// Typography Section

		$this->start_controls_section(
			'typography_section',
			array(
				'label' => __( 'Typography Section', 'elementor' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);
		$this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            array(
                'name'     => 'heading_typography',
                'label'    => __('Heading', 'elementor'),
                'selector' => '{{WRAPPER}} .clients-section .other-text h3',
            )
		);

		$this->end_controls_section();


	}
	protected function render() {
		$settings    = $this->get_settings_for_display();
		$heading     = $settings['heading'];
		$heading_html = sprintf( '<%1$s %2$s>%3$s</%1$s>', Utils::validate_html_tag( $settings['header_size'] ), $this->get_render_attribute_string( 'heading' ), $heading );
		$extra_class = $settings['extra_class'];
		?> 
<section class="clients-section <?php echo $extra_class; ?>">
	<div class="auto-container">
		<?php if ( ! empty( $heading ) ) { ?>
				<div class="other-text centred">
					<?php echo $heading_html; ?>
				</div>
		<?php } ?>
		<div class="four-item-carousel owl-carousel owl-theme owl-dots-none owl-nav-none">
							<?php
							$i = 1;
							foreach ( $settings['items'] as $item ) {
								$item_image        = ( $item['item_image']['id'] != '' ) ? wp_get_attachment_image( $item['item_image']['id'], 'full' ) : $item['item_image']['url'];
								$item_image_alt    = get_post_meta( $item['item_image']['id'], '_wp_attachment_image_alt', true );
								$item_url          = $item['item_url']['url'];
								$item_url_external = $item['item_url']['is_external'] ? 'target="_blank"' : '';
								$item_url_nofollow = $item['item_url']['nofollow'] ? 'rel="nofollow"' : '';
								?>
					  <figure class="clients-logo"><a href="<?php echo esc_attr( $item_url ); ?>" <?php echo $item_url_external; ?>  <?php echo $item_url_nofollow; ?>>
								<?php
								if ( wp_http_validate_url( $item_image ) ) {
									?>
							<img src="<?php echo esc_url( $item_image ); ?>" alt="<?php esc_attr( $item_image_alt ); ?>">
									<?php
								} else {
										echo $item_image;
								}
								?>
					</a></figure> 
					<?php $i++; } ?> 									
		</div>
	</div>
</section> 
		<?php
	}

	protected function content_template() {
	}
}
