<?php
namespace Dormatic\Helper\Elementor\Widgets;

use Elementor\Utils;
use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use Elementor\Plugin;
use \Elementor\Repeater;

class Dormatic_CTA extends Widget_Base {

	public function get_name() {
		return 'dormatic_cta';
	}

	public function get_title() {
		return esc_html__( 'Dormatic CTA', 'dormatic' );
	}

	public function get_icon() {
		return 'sds-widget-ico';
	}

	public function get_categories() {
		return array( 'Dormatic' );
	}

	protected function register_controls() {

		$this->start_controls_section(
			'general',
			array(
				'label' => esc_html__( 'general', 'dormatic' ),
			)
		);

		$this->add_control(
			'background_shape',
			array(
				'label'   => esc_html__( 'Background Shape', 'dormatic' ),
				'type'    => Controls_Manager::MEDIA,
				'default' => array(
					'url' => Utils::get_placeholder_image_src(),
				),

			)
		);

		$this->add_control(
			'title',
			array(
				'label'       => esc_html__( 'Title', 'dormatic' ),
				'type'        => Controls_Manager::TEXTAREA,
				'rows'        => 6,
				'default'     => __( 'Urgent 24/7 Garage Door Repair, <br>Installation & Replacement Services', 'dormatic' ),
				'placeholder' => esc_html__( 'Type your description here', 'dormatic' ),

			)
		);

		$this->add_control(
			'header_size',
			[
				'label' => esc_html__( 'HTML Tag', 'elementor' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'h1' => 'H1',
					'h2' => 'H2',
					'h3' => 'H3',
					'h4' => 'H4',
					'h5' => 'H5',
					'h6' => 'H6',
				],
				'default' => 'h2',
			]
		);

		$this->add_control(
			'button_1_text',
			array(
				'label'   => esc_html__( 'Button 01 Text', 'dormatic' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( '(+1) 201 719 3488', 'dormatic' ),
			)
		);

		$this->add_control(
			'button_1_url',
			array(
				'label'         => esc_html__( 'Button 01 URL', 'dormatic' ),
				'type'          => Controls_Manager::URL,
				'placeholder'   => esc_html__( 'https://your-link.com', 'dormatic' ),
				'show_external' => true,
				'default'       => array(
					'url'         => '',
					'is_external' => false,
					'nofollow'    => false,
				),

			)
		);

		$this->add_control(
			'button_01_icon',
			array(
				'label' => esc_html__( 'Button 01 Icon', 'dormatic' ),
				'type'  => Controls_Manager::ICONS,
			)
		);

		$this->add_control(
			'button_02_text',
			array(
				'label'   => esc_html__( 'Button 02 Text', 'dormatic' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'Get A quote', 'dormatic' ),
			)
		);

		$this->add_control(
			'button_2_url',
			array(
				'label'         => esc_html__( 'Button 02 URL', 'dormatic' ),
				'type'          => Controls_Manager::URL,
				'placeholder'   => esc_html__( 'https://your-link.com', 'dormatic' ),
				'show_external' => true,
				'default'       => array(
					'url'         => '',
					'is_external' => false,
					'nofollow'    => false,
				),

			)
		);

		$this->end_controls_section();

		// Typography Section

		$this->start_controls_section(
			'typography_section',
			array(
				'label' => __('Typography Section', 'elementor'),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'     => 'heading_typography',
				'label'    => __('Heading', 'elementor'),
				'selector' => '{{WRAPPER}} .cta-section .inner-box .text h2',
			)
		);

		$this->end_controls_section();

		// color_section
		$this->start_controls_section(
			'color_section',
			array(
				'label' => __('Color Section', 'elementor'),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);
		$this->start_controls_tabs('tabs_button_style');
		$this->start_controls_tab(
			'tab_button_normal',
			array(
				'label' => __('Normal', 'elementor'),
			)
		);

		$this->add_control(
			'icon_color',
			array(
				'label'     => __( 'Icon Color', 'elementor' ),
				'separator' => 'before',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .cta-section .inner-box .btn-box a.call i' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'number_color',
			array(
				'label'     => __( 'Number Color', 'elementor' ),
				'separator' => 'before',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .cta-section .inner-box .btn-box a.call' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'button_bg_color',
			array(
				'label'     => __( 'Button BG Color', 'elementor' ),
				'separator' => 'before',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .theme-btn-one' => 'background-color: {{VALUE}}',
				),
			)
		);
	
		$this->end_controls_tab();
		$this->start_controls_tab(
			'tab_button_hover',
			array(
				'label' => __('Hover', 'elementor'),
			)
		);

		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();


	}
	protected function render() {
		$settings = $this->get_settings_for_display();

		$background_shape          = ( $settings['background_shape']['id'] != '' ) ? wp_get_attachment_image_url( $settings['background_shape']['id'], 'full' ) : $settings['background_shape']['url'];
			$title                 = $settings['title'];
			$heading_html = sprintf( '<%1$s %2$s>%3$s</%1$s>', Utils::validate_html_tag( $settings['header_size'] ), $this->get_render_attribute_string( 'title' ), $title );
			$button_1_text         = $settings['button_1_text'];
			$button_1_url          = $settings['button_1_url']['url'];
			$button_1_url_external = $settings['button_1_url']['is_external'] ? 'target="_blank"' : '';
			$button_1_url_nofollow = $settings['button_1_url']['nofollow'] ? 'rel="nofollow"' : '';
			$button_01_icon        = $settings['button_01_icon'];
				$button_02_text    = $settings['button_02_text'];
			$button_2_url          = $settings['button_2_url']['url'];
			$button_2_url_external = $settings['button_2_url']['is_external'] ? 'target="_blank"' : '';
			$button_2_url_nofollow = $settings['button_2_url']['nofollow'] ? 'rel="nofollow"' : '';
		?>
	
		<section class="cta-section">
			<div class="pattern-layer" style="background-image: url(<?php echo $background_shape; ?>);"></div>
			<div class="auto-container">
				<div class="inner-box clearfix">
				<div class="text pull-left">
					<?php echo $title; ?>
				</div>
				<div class="btn-box pull-right clearfix">
					<a href="<?php echo $button_1_url; ?>" <?php echo $button_1_url_external; ?>  <?php echo $button_1_url_nofollow; ?> class="call"><?php \Elementor\Icons_Manager::render_icon( ( $button_01_icon ), array( 'aria-hidden' => 'true' ) ); ?><?php echo $button_1_text; ?></a>
					<a href="<?php echo esc_attr( $button_2_url ); ?>" <?php echo $button_2_url_external; ?>  <?php echo $button_2_url_nofollow; ?> class="theme-btn-one"><span class="btn-shape"></span><?php echo $button_02_text; ?></a>
				</div>
				</div>
			</div>
		</section>

			<?php

	}

	protected function content_template() {
	}
}
