<?php
namespace Dormatic\Helper\Elementor\Widgets;

use Elementor\Utils;
use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use Elementor\Plugin;
use \Elementor\Repeater;



class Dormatic_Blog extends Widget_Base {



	public function get_name() {
		return 'dormatic_blog';
	}

	public function get_title() {
		return esc_html__( 'Dormatic Blog', 'dormatic-core' );
	}

	public function get_icon() {
		return 'sds-widget-ico';
	}

	public function get_categories() {
		return array( 'Dormatic' );
	}

	private function get_blog_categories() {
		$options  = array();
		$taxonomy = 'category';
		if ( ! empty( $taxonomy ) ) {
			$terms = get_terms(
				array(
					'parent'     => 0,
					'taxonomy'   => $taxonomy,
					'hide_empty' => false,
				)
			);
			if ( ! empty( $terms ) ) {
				foreach ( $terms as $term ) {
					if ( isset( $term ) ) {
						$options[''] = 'Select';
						if ( isset( $term->slug ) && isset( $term->name ) ) {
							$options[ $term->slug ] = $term->name;
						}
					}
				}
			}
		}
		return $options;
	}


	protected function register_controls() {
		$this->start_controls_section(
			'general',
			array(
				'label' => esc_html__( 'General', 'dormatic-core' ),
			)
		);

		$this->add_control(
			'layout_style',
			array(
				'label'   => esc_html__( 'Layout Style', 'dormatic-core' ),
				'type'    => Controls_Manager::SELECT,
				'options' => array(
					'style_1' => esc_html__( 'Style One', 'dormatic-core' ),
					'style_2' => esc_html__( 'Style Two', 'dormatic-core' ),
					'style_3' => esc_html__( 'Style Three', 'dormatic-core' ),
				),
				'default' => 'style_1',
			)
		);

		$this->add_control(
			'tagline',
			array(
				'label'   => esc_html__( 'Tag Line', 'dormatic-core' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'Garage Door installation & Repair', 'dormatic-core' ),
			)
		);

		$this->add_control(
			'title',
			array(
				'label'       => esc_html__( 'Title', 'dormatic-core' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'default'     => __( 'Garage Door Repair <br>News &amp; Updates', 'dormatic-core' ),
			)
		);
		$this->add_control(
			'html_tag',
			array(
				'label'   => esc_html__( 'Html Tag', 'dormatic-core' ),
				'type'    => Controls_Manager::SELECT,
				'options' => array(
					'h1'   => esc_html__( 'H1', 'dormatic-core' ),
					'h2'   => esc_html__( 'H2', 'dormatic-core' ),
					'h3'   => esc_html__( 'H3', 'dormatic-core' ),
					'h4'   => esc_html__( 'H4', 'dormatic-core' ),
					'h5'   => esc_html__( 'H5', 'dormatic-core' ),
					'h6'   => esc_html__( 'H6', 'dormatic-core' ),
					'div'  => esc_html__( 'div', 'dormatic-core' ),
					'span' => esc_html__( 'span', 'dormatic-core' ),
					'p'    => esc_html__( 'p', 'dormatic-core' ),
				),
				'default' => 'h2',

			)
		);
		$this->add_control(
			'subtitle',
			array(
				'label'       => esc_html__( 'Subtitle', 'dormatic-core' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXTAREA,
			)
		);
		$this->add_control(
			'category_id',
			array(
				'type'        => Controls_Manager::SELECT2,
				'label'       => esc_html__( 'Category', 'dormatic-core' ),
				'options'     => $this->get_blog_categories(),
				'multiple'    => true,
				'label_block' => true,
			)
		);

		$this->add_control(
			'posts_per_page',
			array(
				'label'   => esc_html__( 'Number of Post', 'dormatic-core' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 3,
			)
		);

		$this->add_control(
			'order_by',
			array(
				'label'   => esc_html__( 'Order By', 'dormatic-core' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'date',
				'options' => array(
					'date'          => esc_html__( 'Date', 'dormatic-core' ),
					'ID'            => esc_html__( 'ID', 'dormatic-core' ),
					'author'        => esc_html__( 'Author', 'dormatic-core' ),
					'title'         => esc_html__( 'Title', 'dormatic-core' ),
					'modified'      => esc_html__( 'Modified', 'dormatic-core' ),
					'rand'          => esc_html__( 'Random', 'dormatic-core' ),
					'comment_count' => esc_html__( 'Comment count', 'dormatic-core' ),
					'menu_order'    => esc_html__( 'Menu order', 'dormatic-core' ),
				),
			)
		);
		$this->add_control(
			'order',
			array(
				'label'   => esc_html__( 'Order', 'dormatic-core' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'desc',
				'options' => array(
					'desc' => esc_html__( 'DESC', 'dormatic-core' ),
					'asc'  => esc_html__( 'ASC', 'dormatic-core' ),
				),
			)
		);
		$this->add_control(
			'button_text',
			array(
				'label'   => esc_html__( 'Button Text', 'dormatic-core' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'Read More', 'dormatic-core' ),
			)
		);
		$this->end_controls_section();

		// Typography Section
		$this->start_controls_section(
			'typography_section',
			array(
				'label' => __( 'Typography Section', 'elementor' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'     => 'tagline_typography',
				'label'    => __( 'Tagline', 'elementor' ),
				'selector' => '{{WRAPPER}} .sec-title span',
			)
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'     => 'heading_typography',
				'label'    => __( 'Heading', 'elementor' ),
				'selector' => '{{WRAPPER}} .sec-title h2',
			)
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'     => 'subheading_typography',
				'label'    => __( 'Sub Heading', 'elementor' ),
				'selector' => '{{WRAPPER}}  p',
			)
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'     => 'title_typography',
				'label'    => __( 'Title', 'elementor' ),
				'selector' => '{{WRAPPER}}  .news-block-one .inner-box .lower-content .inner h3',
			)
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'     => 'short_description_typography',
				'label'    => __( 'Short Description', 'elementor' ),
				'selector' => '{{WRAPPER}} .news-block-one .inner-box .lower-content .inner p',
			)
		);

		$this->end_controls_section();

		// color_section
		$this->start_controls_section(
			'color_section',
			array(
				'label' => __( 'Color Section', 'elementor' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);
		$this->start_controls_tabs( 'tabs_button_style' );
		$this->start_controls_tab(
			'tab_button_normal',
			array(
				'label' => __( 'Normal', 'elementor' ),
			)
		);

		$this->add_control(
			'icon_color',
			array(
				'label'     => __( 'Icon Color', 'elementor' ),
				'separator' => 'before',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .news-block-one .inner-box .lower-content .inner .post-meta li i' => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'button_bg_color',
			array(
				'label'     => __( 'Button BG Color', 'elementor' ),
				'separator' => 'before',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .news-block-one .inner-box .lower-content .inner .post-meta li span.cat-list a' => 'background-color: {{VALUE}}',
				),
			)
		);

		$this->end_controls_tab();
		$this->start_controls_tab(
			'tab_button_hover',
			array(
				'label' => __( 'Hover', 'elementor' ),
			)
		);

		$this->add_control(
			'button_hover_bg_color',
			array(
				'label'     => __( 'Button Hover BG Color', 'elementor' ),
				'separator' => 'before',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .news-block-one .inner-box .lower-content .inner .post-meta li:hover span.cat-list a' => 'background-color: {{VALUE}}',
				),
			)
		);

		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();

	}
	protected function render() {
		$settings     = $this->get_settings_for_display();
		$layout_style = $settings['layout_style'];

		$title       = $settings['title'];
		$html_tag    = $settings['html_tag'];
		$tagline     = $settings['tagline'];
		$subtitle    = $settings['subtitle'];
		$button_text = $settings['button_text'];

		if ( $settings['category_id'] ) {
			$category_arr = implode( ', ', $settings['category_id'] );
		} else {
			$category_arr = array();
		}

		$posts_per_page = $settings['posts_per_page'];
		$order_by       = $settings['order_by'];
		$order          = $settings['order'];
		$pg_num         = get_query_var( 'paged' ) ? get_query_var( 'paged' ) : 1;
		$args           = array(
			'post_type'      => array( 'post' ),
			'post_status'    => array( 'publish' ),
			'nopaging'       => false,
			'paged'          => $pg_num,
			'posts_per_page' => $posts_per_page,
			'category_name'  => $category_arr,
			'orderby'        => $order_by,
			'order'          => $order,
		);
		$query          = new \WP_Query( $args );

		?>
	
		<?php if ( $layout_style == 'style_1' ) { ?>
			<section class="news-section">
				<div class="auto-container">
				<?php if ( ! empty( $tagline ) || ! empty( $title ) || ! empty( $subtitle ) ) { ?>
					<div class="title-inner clearfix">
						<div class="sec-title text-right">
							<span><?php echo $tagline; ?></span>
							<<?php echo $html_tag; ?>><?php echo $title; ?></<?php echo $html_tag; ?>>
						</div>
						<div class="text">
							<p><?php echo $subtitle; ?></p>
						</div>
					</div>
				<?php } ?>
					<div class="row clearfix">
						<?php
						$i = 0;
						if ( $query->have_posts() ) {
							while ( $query->have_posts() ) {
								$i++;
								$query->the_post();
								global $post;
								$tags = wp_get_post_categories( get_the_ID() );

								?>
									<div class="col-lg-4 col-md-6 col-sm-12 news-block">
										<div class="news-block-one">
											<div class="inner-box">
												<figure class="image-box">
												<?php the_post_thumbnail( 'dormatic-blog-grid' ); ?>
													<a href="<?php esc_url( the_permalink() ); ?>"><?php echo $button_text; ?></a>
												</figure>
												<div class="lower-content">
													<div class="inner">
														<ul class="post-meta clearfix">
															<li><?php dormatic_category_list(); ?></li>
															<li><i class="far fa-calendar-alt"></i><?php echo get_the_date( 'M d,Y' ); ?></li>
															<li><i class="fal fa-comments"></i><a href="<?php esc_url( the_permalink() ); ?>"><?php echo get_comments_number(); ?></a></li>
														</ul>
														<h3><a href="<?php esc_url( the_permalink() ); ?>"><?php the_title(); ?></a></h3>
														<p><?php echo substr( get_the_excerpt(), 0, 90 ) . '...'; ?></p>
													</div>
													<div class="post-info">
														<ul class="info clearfix">
															<li><i class="far fa-user"></i><?php dormatic_posted_by(); ?></li>
															<li class="share">
																<i class="far fa-share"></i>
																<?php esc_html_e( 'Share', 'dormatic' ); ?>
																<?php do_action( 'dormatic_blog_social' ); ?>
															</li>
														</ul>
													</div>
												</div>
											</div>
										</div>
									</div>
								<?php
							}
							wp_reset_postdata();
						}
						?>
					</div>
				</div>
			</section>
<?php } elseif ( $layout_style == 'style_2' ) { ?>
<section class="news-section">
	<div class="auto-container">
			<?php if ( ! empty( $tagline ) || ! empty( $title ) || ! empty( $subtitle ) ) { ?>
		<div class="sec-title centred">
			<span><?php echo $tagline; ?></span>
			<<?php echo $html_tag; ?>><?php echo $title; ?></<?php echo $html_tag; ?>>
			<p><?php echo $subtitle; ?></p>
		</div>
	<?php } ?>
		<div class="row clearfix">
			<?php
			$i = 0;
			if ( $query->have_posts() ) {
				while ( $query->have_posts() ) {
					$i++;
					$query->the_post();
					global $post;
					$tags = wp_get_post_categories( get_the_ID() );

					?>
			<div class="col-lg-4 col-md-6 col-sm-12 news-block">
				<div class="news-block-one">
					<div class="inner-box">
						<figure class="image-box">
						<?php the_post_thumbnail( 'dormatic-blog-grid' ); ?>
							<a href="<?php esc_url( the_permalink() ); ?>"><?php echo $button_text; ?></a>
						</figure>
						<div class="lower-content">
							<div class="inner">
								<ul class="post-meta clearfix">
									<li><?php dormatic_category_list(); ?></li>
									<li><i class="far fa-calendar-alt"></i><?php dormatic_posted_by(); ?></li>
									<li><i class="fal fa-comments"></i><a href="<?php esc_url( the_permalink() ); ?>"><?php echo get_comments_number(); ?></a></li>
								</ul>
								<h3><a href="<?php esc_url( the_permalink() ); ?>"><?php the_title(); ?></a></h3>
								<p><?php echo substr( get_the_excerpt(), 0, 90 ) . '...'; ?></p>
							</div>
							<div class="post-info">
								<ul class="info clearfix">
									<li><i class="far fa-user"></i><?php dormatic_posted_by(); ?></li>
									<li class="share">
										<i class="far fa-share"></i>
										<?php esc_html_e( 'Share', 'dormatic' ); ?>
										<?php do_action( 'dormatic_blog_social' ); ?>
									</li>
								</ul>
							</div>
						</div>
					</div>
				</div>
			</div>
					<?php
				}
				wp_reset_postdata();
			}
			?>
		</div>
	</div>
</section>
<?php } elseif ( $layout_style == 'style_3' ) { ?>
	<section class="news-section">
		<div class="auto-container">
			<?php if ( ! empty( $tagline ) || ! empty( $title ) || ! empty( $subtitle ) ) { ?>
			<div class="sec-title centred">
				<span><?php echo $tagline; ?></span>
				<<?php echo $html_tag; ?>><?php echo $title; ?></<?php echo $html_tag; ?>>
				<p><?php echo $subtitle; ?></p>
			</div>
			<?php } ?>
			<div class="three-item-carousel owl-carousel owl-theme owl-dots-none owl-nav-none">
				<?php
				$i = 0;
				if ( $query->have_posts() ) {
					while ( $query->have_posts() ) {
						$i++;
						$query->the_post();
						global $post;
						$tags = wp_get_post_categories( get_the_ID() );

						?>
					<div class="news-block-one">
						<div class="inner-box">
							<figure class="image-box">
							<?php the_post_thumbnail( 'dormatic-blog-grid' ); ?>
								<a href="<?php esc_url( the_permalink() ); ?>"><?php echo $button_text; ?></a>
							</figure>
							<div class="lower-content">
								<div class="inner">
									<ul class="post-meta clearfix">
										<li><?php dormatic_category_list(); ?></li>
										<li><i class="far fa-calendar-alt"></i><?php dormatic_posted_by(); ?></li>
										<li><i class="fal fa-comments"></i><a href="<?php esc_url( the_permalink() ); ?>"><?php echo get_comments_number(); ?></a></li>
									</ul>
									<h3><a href="<?php esc_url( the_permalink() ); ?>"><?php the_title(); ?></a></h3>
									<p><?php echo substr( get_the_excerpt(), 0, 90 ) . '...'; ?></p>
								</div>
								<div class="post-info">
									<ul class="info clearfix">
										<li><i class="far fa-user"></i><?php dormatic_posted_by(); ?></li>
										<li class="share">
											<i class="far fa-share"></i>
											<?php esc_html_e( 'Share', 'dormatic' ); ?>
											<?php do_action( 'dormatic_blog_social' ); ?>
										</li>
									</ul>
								</div>
							</div>
						</div>
					</div>
						<?php
					}
					wp_reset_postdata();
				}
				?>
			</div>
		</div>
	</section>
			<?php
}
	}

	protected function content_template() {
	}
}
