<?php
namespace Dormatic\Helper\Elementor\Widgets;

use Elementor\Utils;
use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use Elementor\Plugin;
use \Elementor\Repeater;

class Dormatic_Appointment_Section extends Widget_Base {

	public function get_name() {
		return 'dormatic_appointment_section';
	}

	public function get_title() {
		return esc_html__( 'Dormatic Appointment Section', 'dormatic' );
	}

	public function get_icon() {
		return 'sds-widget-ico';
	}

	public function get_categories() {
		return array( 'Dormatic' );
	}

	protected function register_controls() {

		$this->start_controls_section(
			'general',
			array(
				'label' => esc_html__( 'general', 'dormatic' ),
			)
		);
		$this->add_control(
			'background_shape',
			array(
				'label'   => esc_html__( 'Background Shape', 'dormatic' ),
				'type'    => Controls_Manager::MEDIA,
				'default' => array(
					'url' => Utils::get_placeholder_image_src(),
				),

			)
		);

		$this->add_control(
			'tagline',
			array(
				'label'   => esc_html__( 'Tagline', 'dormatic' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'Garage Door installation & Repair', 'dormatic' ),
			)
		);

		$this->add_control(
			'heading',
			array(
				'label'   => esc_html__( 'Heading', 'dormatic' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'Make An Appointment', 'dormatic' ),
			)
		);	

		$this->add_control(
			'header_size',
			[
				'label' => esc_html__( 'HTML Tag', 'elementor' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'h1' => 'H1',
					'h2' => 'H2',
					'h3' => 'H3',
					'h4' => 'H4',
					'h5' => 'H5',
					'h6' => 'H6',
				],
				'default' => 'h3',
			]
		);

		$this->add_control(
			'sub_heading',
			array(
				'label'       => esc_html__( 'Sub Heading', 'dormatic' ),
				'type'        => Controls_Manager::TEXTAREA,
				'rows'        => 6,
				'default'     => __( 'Nunc quam ar pretium quis lobortis sequat consetetur diam bibend ipsum dolor <br />sit amet consecty nunc voluptatem enim veniam quis nostrud', 'dormatic' ),
				'placeholder' => esc_html__( 'Type your description here', 'dormatic' ),

			)
		);

		$this->add_control(
			'map_embed',
			array(
				'label'       => esc_html__( 'Map Embed', 'dormatic' ),
				'type'        => Controls_Manager::TEXTAREA,
				'rows'        => 6,
				'placeholder' => esc_html__( 'Type your description here', 'dormatic' ),

			)
		);
		$this->add_control(
			'address_on_map',
			array(
				'label'   => esc_html__( 'Address On Map', 'dormatic' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( '72 Main Drive, Calibry Forida, 890012 US', 'dormatic' ),
			)
		);

		$this->add_control(
			'phone_on_map',
			array(
				'label'   => esc_html__( 'Phone On Map', 'dormatic' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'Phone: <a href="tel:2017193488">201-719-3488</a>', 'dormatic' ),
			)
		);
		$this->add_control(
			'form_title',
			array(
				'label'   => esc_html__( 'Form Title', 'dormatic' ),
				'type'    => Controls_Manager::TEXT,
				'default' => __( 'A Premium Garage Door Service For Secure & Loving Garage. Any Questions? Send Us A Message.', 'dormatic' ),
			)
		);

		$this->add_control(
			'form_header_size',
			[
				'label' => esc_html__( 'HTML Tag', 'elementor' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'h1' => 'H1',
					'h2' => 'H2',
					'h3' => 'H3',
					'h4' => 'H4',
					'h5' => 'H5',
					'h6' => 'H6',
				],
				'default' => 'h2',
			]
		);

		$this->add_control(
			'contact_form',
			array(
				'label'   => esc_html__( 'Contact Form', 'dormatic' ),
				'type'    => Controls_Manager::SELECT,
				'options' => getContactForm7Posts(),
			)
		);

		$this->add_control(
			'cta_content',
			array(
				'label'       => esc_html__( 'CTA Content', 'dormatic' ),
				'type'        => Controls_Manager::TEXTAREA,
				'rows'        => 6,
				'placeholder' => esc_html__( 'Type your description here', 'dormatic' ),

			)
		);

		$this->end_controls_section();

		// Typography Section
		
		$this->start_controls_section(
			'typography_section',
			array(
				'label' => __( 'Typography Section', 'elementor' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'     => 'tagline_typography',
				'label'    => __( 'Tagline', 'elementor' ),
				'selector' => '{{WRAPPER}} .sec-title span',
			)
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'     => 'heading_typography',
				'label'    => __( 'Heading', 'elementor' ),
				'selector' => '{{WRAPPER}} .sec-title h2',
			)
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'     => 'subheading_typography',
				'label'    => __( 'Sub Heading', 'elementor'),
				'selector' => '{{WRAPPER}} .sec-title p',
			)
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'     => 'form_title_typography',
				'label'    => __( 'Form title', 'elementor'),
				'selector' => '{{WRAPPER}} .appointment-section .form-inner h3',
			)
		);
		
		$this->end_controls_section();

		// color_section
		$this->start_controls_section(
			'color_section',
			array(
				'label' => __( 'Color Section', 'elementor' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);
		$this->start_controls_tabs( 'tabs_button_style' );
		$this->start_controls_tab(
			'tab_button_normal',
			array(
				'label' => __( 'Normal', 'elementor' ),
			)
		);
		
		$this->add_control(
			'button_bg_color',
			array(
				'label'     => __( 'Button BG Color', 'elementor' ),
				'separator' => 'before',
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .theme-btn-one' => 'background: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'bottom_icon_color',
			array(
				'label'     => __( 'Bottom Icon Color', 'elementor' ),
				'separator' => 'before',
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .cta-text h3 i' => 'color: {{VALUE}}',
				),
			)
		);


		$this->add_control(
			'text_color',
			array(
				'label'     => __( 'Text & Text Color', 'elementor' ),
				'separator' => 'before',
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .cta-text h3 a span' => 'color: {{VALUE}}',
				),
			)
		);

		$this->end_controls_tab();
		$this->start_controls_tab(
			'tab_button_hover',
			array(
				'label' => __( 'Hover', 'elementor' ),
			)
		);

		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();

	}
	protected function render() {
		$settings                     = $this->get_settings_for_display();
		$tagline                      = $settings['tagline'];
				$heading              = $settings['heading'];
				$heading_html = sprintf( '<%1$s %2$s>%3$s</%1$s>', Utils::validate_html_tag( $settings['header_size'] ), $this->get_render_attribute_string( 'heading' ), $heading );
				$sub_heading          = $settings['sub_heading'];
				$map_embed            = $settings['map_embed'];
				$form_title           = $settings['form_title'];
				$form_title_html = sprintf( '<%1$s %2$s>%3$s</%1$s>', Utils::validate_html_tag( $settings['form_header_size'] ), $this->get_render_attribute_string( 'form_title' ), $form_title );
				$contact_form         = $settings['contact_form'];
				$background_shape = ( $settings['background_shape']['id'] != '' ) ? wp_get_attachment_image_url( $settings['background_shape']['id'], 'full' ) : $settings['background_shape']['url'];
				$cta_content    = $settings['cta_content'];
				$address_on_map = $settings['address_on_map'];
				$phone_on_map   = $settings['phone_on_map'];
		?> 
<section class="appointment-section">
	<div class="pattern-layer" style="background-image: url(<?php echo $background_shape; ?>);"></div>
	<div class="auto-container">
		<div class="sec-title centred">
			<span><?php echo $tagline; ?></span>
			<?php echo $heading_html; ?>
			<p><?php echo $sub_heading; ?></p>
		</div>
		<div class="inner-content">
			<div class="row align-items-center clearfix">
				<div class="col-lg-6 col-md-6 col-sm-12 map-column">
					<div class="map-inner">
						<div>
							<?php echo $map_embed; ?>
						</div>
						<div class="map-content">
							<div class="inner">
								<div class="icon-box"><i class="far fa-map-marker-alt"></i></div>
								<p><?php echo $address_on_map; ?></p>
								<h6><?php echo $phone_on_map; ?></h6>
							</div>
						</div>
					</div>
				</div>
				<div class="col-lg-6 col-md-6 col-sm-12 form-column">
					<div class="form-inner">
						<?php echo $form_title_html; ?>
					 
						<?php
						if ( $contact_form ) :
							echo do_shortcode( '[contact-form-7 id="' . $contact_form . '"]' );
						endif;
						?>
					</div>
				</div>
			</div>
		</div>
		<div class="cta-text centred">
			<?php echo $cta_content; ?>
		</div>
	</div>
</section> 
		<?php
	}

	protected function content_template() {
	}
}
