<?php
namespace Dormatic\Helper\Elementor\Settings;

use Elementor\Utils;

class Header {





	public static function dormatic_get_wow_animation_control( $obj, $animationClass = 'fadeInLeft', $animationDuration = '1500ms', $animationDelay = '500ms' ) {
		$obj->add_control(
			'animation_class',
			array(
				'label'     => __( 'Animation', 'dormatic-core' ),
				'separator' => 'before',
				'type'      => \Elementor\Controls_Manager::ANIMATION,
				'default'   => $animationClass,
				'options'   => \dormatic\Helper\Elementor\Settings\Animation::dormatic_get_animation_name(),
			)
		);

		$obj->add_control(
			'duration_time',
			array(
				'label'       => __( 'Duration Time', 'dormatic-core' ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'default'     => $animationDuration,
				'placeholder' => esc_html__( 'Animation duration value ex:200s.', 'dormatic-core' ),
			)
		);

		$obj->add_control(
			'delay_time',
			array(
				'label'       => __( 'Delay Time', 'dormatic-core' ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'default'     => $animationDelay,
				'placeholder' => esc_html__( 'Animation duration value ex:200s.', 'dormatic-core' ),
			)
		);
	}

	public static function dormatic_coloumn( $obj, $settings ) {
		$number_of_coloumns = $settings['number_of_coloumns'];
		return $number_of_coloumns;
	}


	public static function dormatic_coloumn_control( $obj, $max = 3, $min = 1 ) {
		$option = array();

		for ( $i = $min; $i <= $max; $i++ ) {
			switch ( $i ) {
				case 1:
					$option['col-lg-12'] = __( '1', 'dormatic-core' );
					break;
				case 2:
					$option['col-lg-6'] = __( '2', 'dormatic-core' );
					break;
				case 3:
					   $option['col-lg-4'] = __( '3', 'dormatic-core' );
					break;
				case 4:
					$option['col-lg-3'] = __( '4', 'dormatic-core' );
					break;
				case 6:
					$option['col-lg-2'] = __( '6', 'dormatic-core' );
					break;
				case 12:
					$option['col-lg-1'] = __( '12', 'dormatic-core' );
					break;
			}
		}

		$obj->add_control(
			'number_of_coloumns',
			array(
				'label'     => __( 'Number Of Coloumns', 'dormatic-core' ),
				'separator' => 'before',
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options'   => $option,
				'default'   => 'col-lg-4',

			)
		);
	}


}
